/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.subscription.model;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.interceptor.model.RequestPartitionId;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.server.messaging.BaseResourceMessage;
import ca.uhn.fhir.rest.server.messaging.BaseResourceModifiedMessage;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.hl7.fhir.instance.model.api.IBaseResource;

public class ResourceModifiedMessage
extends BaseResourceModifiedMessage {
    @JsonProperty(value="subscriptionId", required=false)
    private String mySubscriptionId;
    @JsonProperty(value="partitionId", required=false)
    private RequestPartitionId myPartitionId;

    public ResourceModifiedMessage() {
    }

    public ResourceModifiedMessage(FhirContext theFhirContext, IBaseResource theResource, BaseResourceMessage.OperationTypeEnum theOperationType) {
        super(theFhirContext, theResource, theOperationType);
        this.myPartitionId = RequestPartitionId.defaultPartition();
    }

    public ResourceModifiedMessage(FhirContext theFhirContext, IBaseResource theNewResource, BaseResourceMessage.OperationTypeEnum theOperationType, RequestDetails theRequest) {
        super(theFhirContext, theNewResource, theOperationType, theRequest);
        this.myPartitionId = RequestPartitionId.defaultPartition();
    }

    public ResourceModifiedMessage(FhirContext theFhirContext, IBaseResource theNewResource, BaseResourceMessage.OperationTypeEnum theOperationType, RequestDetails theRequest, RequestPartitionId theRequestPartitionId) {
        super(theFhirContext, theNewResource, theOperationType, theRequest);
        this.myPartitionId = theRequestPartitionId;
    }

    public String getSubscriptionId() {
        return this.mySubscriptionId;
    }

    public void setSubscriptionId(String theSubscriptionId) {
        this.mySubscriptionId = theSubscriptionId;
    }

    public RequestPartitionId getPartitionId() {
        return this.myPartitionId;
    }

    public void setPartitionId(RequestPartitionId thePartitionId) {
        this.myPartitionId = thePartitionId;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("operationType", (Object)this.myOperationType).append("subscriptionId", (Object)this.mySubscriptionId).append("payloadId", (Object)this.myPayloadId).append("partitionId", (Object)this.myPartitionId).toString();
    }
}

