/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.subscription.match.registry;

import ca.uhn.fhir.context.ConfigurationException;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.interceptor.model.RequestPartitionId;
import ca.uhn.fhir.jpa.subscription.match.matcher.matching.SubscriptionMatchingStrategy;
import ca.uhn.fhir.jpa.subscription.model.CanonicalSubscription;
import ca.uhn.fhir.jpa.subscription.model.CanonicalSubscriptionChannelType;
import ca.uhn.fhir.model.api.ExtensionDt;
import ca.uhn.fhir.rest.api.Constants;
import ca.uhn.fhir.rest.server.exceptions.InternalErrorException;
import ca.uhn.fhir.rest.server.exceptions.PreconditionFailedException;
import ca.uhn.fhir.util.SubscriptionUtil;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.hl7.fhir.dstu3.model.Subscription;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseCoding;
import org.hl7.fhir.instance.model.api.IBaseHasExtensions;
import org.hl7.fhir.instance.model.api.IBaseMetaType;
import org.hl7.fhir.instance.model.api.IBaseReference;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.instance.model.api.IPrimitiveType;
import org.hl7.fhir.r4.model.BooleanType;
import org.hl7.fhir.r4.model.Extension;
import org.hl7.fhir.r4.model.Subscription;
import org.hl7.fhir.r5.model.Coding;
import org.hl7.fhir.r5.model.Enumerations;
import org.hl7.fhir.r5.model.SubscriptionTopic;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class SubscriptionCanonicalizer {
    private static final Logger ourLog = LoggerFactory.getLogger(SubscriptionCanonicalizer.class);
    final FhirContext myFhirContext;

    @Autowired
    public SubscriptionCanonicalizer(FhirContext theFhirContext) {
        this.myFhirContext = theFhirContext;
    }

    public CanonicalSubscription canonicalize(IBaseResource theSubscription) {
        switch (this.myFhirContext.getVersion().getVersion()) {
            case DSTU2: {
                return this.canonicalizeDstu2(theSubscription);
            }
            case DSTU3: {
                return this.canonicalizeDstu3(theSubscription);
            }
            case R4: {
                return this.canonicalizeR4(theSubscription);
            }
            case R5: {
                return this.canonicalizeR5(theSubscription);
            }
        }
        throw new ConfigurationException(Msg.code((int)556) + "Subscription not supported for version: " + this.myFhirContext.getVersion().getVersion());
    }

    private CanonicalSubscription canonicalizeDstu2(IBaseResource theSubscription) {
        ca.uhn.fhir.model.dstu2.resource.Subscription subscription = (ca.uhn.fhir.model.dstu2.resource.Subscription)theSubscription;
        CanonicalSubscription retVal = new CanonicalSubscription();
        try {
            retVal.setStatus(Subscription.SubscriptionStatus.fromCode((String)subscription.getStatus()));
            retVal.setChannelType(this.getChannelType(theSubscription));
            retVal.setCriteriaString(subscription.getCriteria());
            retVal.setEndpointUrl(subscription.getChannel().getEndpoint());
            retVal.setHeaders(subscription.getChannel().getHeader());
            retVal.setChannelExtensions(this.extractExtension((IBaseResource)subscription));
            retVal.setIdElement(subscription.getIdElement());
            retVal.setPayloadString(subscription.getChannel().getPayload());
            retVal.setTags(this.extractTags((IBaseResource)subscription));
            retVal.setCrossPartitionEnabled(SubscriptionUtil.isCrossPartition((IBaseResource)theSubscription));
            retVal.setSendDeleteMessages(this.extractDeleteExtensionDstu2(subscription));
        }
        catch (FHIRException theE) {
            throw new InternalErrorException(Msg.code((int)557) + theE);
        }
        return retVal;
    }

    private boolean extractDeleteExtensionDstu2(ca.uhn.fhir.model.dstu2.resource.Subscription theSubscription) {
        return theSubscription.getChannel().getUndeclaredExtensionsByUrl("http://hapifhir.io/fhir/StructureDefinition/subscription-send-delete-messages").stream().map(ExtensionDt::getValue).map(value -> (org.hl7.fhir.dstu2.model.BooleanType)value).map(org.hl7.fhir.dstu2.model.BooleanType::booleanValue).findFirst().orElse(false);
    }

    private Map<String, String> extractTags(IBaseResource theSubscription) {
        return theSubscription.getMeta().getTag().stream().filter(t -> t.getSystem() != null && t.getCode() != null).collect(Collectors.toMap(IBaseCoding::getSystem, IBaseCoding::getCode));
    }

    private CanonicalSubscription canonicalizeDstu3(IBaseResource theSubscription) {
        org.hl7.fhir.dstu3.model.Subscription subscription = (org.hl7.fhir.dstu3.model.Subscription)theSubscription;
        CanonicalSubscription retVal = new CanonicalSubscription();
        try {
            Subscription.SubscriptionStatus status = subscription.getStatus();
            if (status != null) {
                retVal.setStatus(Subscription.SubscriptionStatus.fromCode((String)status.toCode()));
            }
            this.setPartitionIdOnReturnValue(theSubscription, retVal);
            retVal.setChannelType(this.getChannelType(theSubscription));
            retVal.setCriteriaString(subscription.getCriteria());
            retVal.setEndpointUrl(subscription.getChannel().getEndpoint());
            retVal.setHeaders(subscription.getChannel().getHeader());
            retVal.setChannelExtensions(this.extractExtension((IBaseResource)subscription));
            retVal.setIdElement((IIdType)subscription.getIdElement());
            retVal.setPayloadString(subscription.getChannel().getPayload());
            retVal.setPayloadSearchCriteria(this.getExtensionString((IBaseHasExtensions)subscription, "http://hapifhir.io/fhir/StructureDefinition/subscription-payload-search-criteria"));
            retVal.setTags(this.extractTags((IBaseResource)subscription));
            retVal.setCrossPartitionEnabled(SubscriptionUtil.isCrossPartition((IBaseResource)theSubscription));
            if (retVal.getChannelType() == CanonicalSubscriptionChannelType.EMAIL) {
                String subjectTemplate;
                String from;
                try {
                    from = subscription.getChannel().getExtensionString("http://hapifhir.io/fhir/StructureDefinition/subscription-email-from");
                    subjectTemplate = subscription.getChannel().getExtensionString("http://hapifhir.io/fhir/StructureDefinition/subscription-email-subject-template");
                }
                catch (FHIRException theE) {
                    throw new ConfigurationException(Msg.code((int)558) + "Failed to extract subscription extension(s): " + theE.getMessage(), (Throwable)theE);
                }
                retVal.getEmailDetails().setFrom(from);
                retVal.getEmailDetails().setSubjectTemplate(subjectTemplate);
            }
            if (retVal.getChannelType() == CanonicalSubscriptionChannelType.RESTHOOK) {
                String deliverLatestVersion;
                String stripVersionIds;
                try {
                    stripVersionIds = subscription.getChannel().getExtensionString("http://hapifhir.io/fhir/StructureDefinition/subscription-resthook-strip-version-ids");
                    deliverLatestVersion = subscription.getChannel().getExtensionString("http://hapifhir.io/fhir/StructureDefinition/subscription-resthook-deliver-latest-version");
                }
                catch (FHIRException theE) {
                    throw new ConfigurationException(Msg.code((int)559) + "Failed to extract subscription extension(s): " + theE.getMessage(), (Throwable)theE);
                }
                retVal.getRestHookDetails().setStripVersionId(Boolean.parseBoolean(stripVersionIds));
                retVal.getRestHookDetails().setDeliverLatestVersion(Boolean.parseBoolean(deliverLatestVersion));
            }
            retVal.setSendDeleteMessages(this.extractSendDeletesDstu3(subscription));
        }
        catch (FHIRException theE) {
            throw new InternalErrorException(Msg.code((int)560) + theE);
        }
        return retVal;
    }

    @NotNull
    private Boolean extractSendDeletesDstu3(org.hl7.fhir.dstu3.model.Subscription subscription) {
        return subscription.getChannel().getExtensionsByUrl("http://hapifhir.io/fhir/StructureDefinition/subscription-send-delete-messages").stream().map(org.hl7.fhir.dstu3.model.Extension::getValue).filter(val -> val instanceof org.hl7.fhir.dstu3.model.BooleanType).map(val -> (org.hl7.fhir.dstu3.model.BooleanType)val).map(org.hl7.fhir.dstu3.model.BooleanType::booleanValue).findFirst().orElse(false);
    }

    @Nonnull
    private Map<String, List<String>> extractExtension(IBaseResource theSubscription) {
        try {
            switch (theSubscription.getStructureFhirVersionEnum()) {
                case DSTU2: {
                    ca.uhn.fhir.model.dstu2.resource.Subscription subscription = (ca.uhn.fhir.model.dstu2.resource.Subscription)theSubscription;
                    return subscription.getChannel().getUndeclaredExtensions().stream().collect(Collectors.groupingBy(t -> t.getUrl(), Collectors.mapping(t -> t.getValueAsPrimitive().getValueAsString(), Collectors.toList())));
                }
                case DSTU3: {
                    org.hl7.fhir.dstu3.model.Subscription subscription = (org.hl7.fhir.dstu3.model.Subscription)theSubscription;
                    return subscription.getChannel().getExtension().stream().collect(Collectors.groupingBy(t -> t.getUrl(), Collectors.mapping(t -> t.getValueAsPrimitive().getValueAsString(), Collectors.toList())));
                }
                case R4: {
                    Subscription subscription = (Subscription)theSubscription;
                    return subscription.getChannel().getExtension().stream().collect(Collectors.groupingBy(t -> t.getUrl(), Collectors.mapping(t -> t.getValueAsPrimitive().getValueAsString(), Collectors.toList())));
                }
                case R5: {
                    org.hl7.fhir.r5.model.Subscription subscription = (org.hl7.fhir.r5.model.Subscription)theSubscription;
                    return subscription.getExtension().stream().collect(Collectors.groupingBy(t -> t.getUrl(), Collectors.mapping(t -> t.getValueAsPrimitive().getValueAsString(), Collectors.toList())));
                }
            }
            ourLog.error("Failed to extract extension from subscription {}", (Object)theSubscription.getIdElement().toUnqualified().getValue());
        }
        catch (FHIRException theE) {
            ourLog.error("Failed to extract extension from subscription {}", (Object)theSubscription.getIdElement().toUnqualified().getValue(), (Object)theE);
        }
        return Collections.emptyMap();
    }

    private CanonicalSubscription canonicalizeR4(IBaseResource theSubscription) {
        IBaseReference ref;
        List topicExts;
        Subscription subscription = (Subscription)theSubscription;
        CanonicalSubscription retVal = new CanonicalSubscription();
        retVal.setStatus(subscription.getStatus());
        retVal.setChannelType(this.getChannelType(theSubscription));
        retVal.setCriteriaString(subscription.getCriteria());
        retVal.setEndpointUrl(subscription.getChannel().getEndpoint());
        retVal.setHeaders(subscription.getChannel().getHeader());
        retVal.setChannelExtensions(this.extractExtension((IBaseResource)subscription));
        retVal.setIdElement((IIdType)subscription.getIdElement());
        retVal.setPayloadString(subscription.getChannel().getPayload());
        retVal.setPayloadSearchCriteria(this.getExtensionString((IBaseHasExtensions)subscription, "http://hapifhir.io/fhir/StructureDefinition/subscription-payload-search-criteria"));
        retVal.setTags(this.extractTags((IBaseResource)subscription));
        this.setPartitionIdOnReturnValue(theSubscription, retVal);
        retVal.setCrossPartitionEnabled(SubscriptionUtil.isCrossPartition((IBaseResource)theSubscription));
        if (retVal.getChannelType() == CanonicalSubscriptionChannelType.EMAIL) {
            String subjectTemplate;
            String from;
            try {
                from = subscription.getChannel().getExtensionString("http://hapifhir.io/fhir/StructureDefinition/subscription-email-from");
                subjectTemplate = subscription.getChannel().getExtensionString("http://hapifhir.io/fhir/StructureDefinition/subscription-email-subject-template");
            }
            catch (FHIRException theE) {
                throw new ConfigurationException(Msg.code((int)561) + "Failed to extract subscription extension(s): " + theE.getMessage(), (Throwable)theE);
            }
            retVal.getEmailDetails().setFrom(from);
            retVal.getEmailDetails().setSubjectTemplate(subjectTemplate);
        }
        if (retVal.getChannelType() == CanonicalSubscriptionChannelType.RESTHOOK) {
            String deliverLatestVersion;
            String stripVersionIds;
            try {
                stripVersionIds = subscription.getChannel().getExtensionString("http://hapifhir.io/fhir/StructureDefinition/subscription-resthook-strip-version-ids");
                deliverLatestVersion = subscription.getChannel().getExtensionString("http://hapifhir.io/fhir/StructureDefinition/subscription-resthook-deliver-latest-version");
            }
            catch (FHIRException theE) {
                throw new ConfigurationException(Msg.code((int)562) + "Failed to extract subscription extension(s): " + theE.getMessage(), (Throwable)theE);
            }
            retVal.getRestHookDetails().setStripVersionId(Boolean.parseBoolean(stripVersionIds));
            retVal.getRestHookDetails().setDeliverLatestVersion(Boolean.parseBoolean(deliverLatestVersion));
        }
        if ((topicExts = subscription.getExtensionsByUrl("http://hl7.org/fhir/subscription/topics")).size() > 0 && !"EventDefinition".equals((ref = (IBaseReference)((Extension)topicExts.get(0)).getValueAsPrimitive()).getReferenceElement().getResourceType())) {
            throw new PreconditionFailedException(Msg.code((int)563) + "Topic reference must be an EventDefinition");
        }
        Extension extension = subscription.getChannel().getExtensionByUrl("http://hapifhir.io/fhir/StructureDefinition/subscription-send-delete-messages");
        if (extension != null && extension.hasValue() && extension.getValue() instanceof BooleanType) {
            retVal.setSendDeleteMessages(((BooleanType)extension.getValue()).booleanValue());
        }
        return retVal;
    }

    private CanonicalSubscription canonicalizeR5(IBaseResource theSubscription) {
        IBaseReference ref;
        List topicExts;
        org.hl7.fhir.r5.model.Subscription subscription = (org.hl7.fhir.r5.model.Subscription)theSubscription;
        CanonicalSubscription retVal = new CanonicalSubscription();
        Enumerations.SubscriptionState status = subscription.getStatus();
        if (status != null) {
            retVal.setStatus(Subscription.SubscriptionStatus.fromCode((String)status.toCode()));
        }
        this.setPartitionIdOnReturnValue(theSubscription, retVal);
        retVal.setChannelType(this.getChannelType((IBaseResource)subscription));
        retVal.setCriteriaString(this.getCriteria(theSubscription));
        retVal.setEndpointUrl(subscription.getEndpoint());
        retVal.setHeaders(subscription.getHeader());
        retVal.setChannelExtensions(this.extractExtension((IBaseResource)subscription));
        retVal.setIdElement((IIdType)subscription.getIdElement());
        retVal.setPayloadString(subscription.getContentType());
        retVal.setPayloadSearchCriteria(this.getExtensionString((IBaseHasExtensions)subscription, "http://hapifhir.io/fhir/StructureDefinition/subscription-payload-search-criteria"));
        retVal.setTags(this.extractTags((IBaseResource)subscription));
        if (retVal.getChannelType() == CanonicalSubscriptionChannelType.EMAIL) {
            String subjectTemplate;
            String from;
            try {
                from = this.getExtensionString((IBaseHasExtensions)subscription, "http://hapifhir.io/fhir/StructureDefinition/subscription-email-from");
                subjectTemplate = this.getExtensionString((IBaseHasExtensions)subscription, "http://hapifhir.io/fhir/StructureDefinition/subscription-email-subject-template");
            }
            catch (FHIRException theE) {
                throw new ConfigurationException(Msg.code((int)564) + "Failed to extract subscription extension(s): " + theE.getMessage(), (Throwable)theE);
            }
            retVal.getEmailDetails().setFrom(from);
            retVal.getEmailDetails().setSubjectTemplate(subjectTemplate);
        }
        if (retVal.getChannelType() == CanonicalSubscriptionChannelType.RESTHOOK) {
            String deliverLatestVersion;
            String stripVersionIds;
            try {
                stripVersionIds = this.getExtensionString((IBaseHasExtensions)subscription, "http://hapifhir.io/fhir/StructureDefinition/subscription-resthook-strip-version-ids");
                deliverLatestVersion = this.getExtensionString((IBaseHasExtensions)subscription, "http://hapifhir.io/fhir/StructureDefinition/subscription-resthook-deliver-latest-version");
            }
            catch (FHIRException theE) {
                throw new ConfigurationException(Msg.code((int)565) + "Failed to extract subscription extension(s): " + theE.getMessage(), (Throwable)theE);
            }
            retVal.getRestHookDetails().setStripVersionId(Boolean.parseBoolean(stripVersionIds));
            retVal.getRestHookDetails().setDeliverLatestVersion(Boolean.parseBoolean(deliverLatestVersion));
        }
        if ((topicExts = subscription.getExtensionsByUrl("http://hl7.org/fhir/subscription/topics")).size() > 0 && !"EventDefinition".equals((ref = (IBaseReference)((org.hl7.fhir.r5.model.Extension)topicExts.get(0)).getValueAsPrimitive()).getReferenceElement().getResourceType())) {
            throw new PreconditionFailedException(Msg.code((int)566) + "Topic reference must be an EventDefinition");
        }
        return retVal;
    }

    private void setPartitionIdOnReturnValue(IBaseResource theSubscription, CanonicalSubscription retVal) {
        RequestPartitionId requestPartitionId = (RequestPartitionId)theSubscription.getUserData(Constants.RESOURCE_PARTITION_ID);
        if (requestPartitionId != null) {
            retVal.setPartitionId(requestPartitionId.getFirstPartitionIdOrNull());
        }
    }

    private String getExtensionString(IBaseHasExtensions theBase, String theUrl) {
        return theBase.getExtension().stream().filter(t -> theUrl.equals(t.getUrl())).filter(t -> t.getValue() instanceof IPrimitiveType).map(t -> (IPrimitiveType)t.getValue()).map(t -> t.getValueAsString()).findFirst().orElse(null);
    }

    public CanonicalSubscriptionChannelType getChannelType(IBaseResource theSubscription) {
        CanonicalSubscriptionChannelType retVal = null;
        switch (this.myFhirContext.getVersion().getVersion()) {
            case DSTU2: {
                String channelTypeCode = ((ca.uhn.fhir.model.dstu2.resource.Subscription)theSubscription).getChannel().getType();
                retVal = CanonicalSubscriptionChannelType.fromCode(null, channelTypeCode);
                break;
            }
            case DSTU3: {
                Subscription.SubscriptionChannelType type = ((org.hl7.fhir.dstu3.model.Subscription)theSubscription).getChannel().getType();
                if (type == null) break;
                String channelTypeCode = type.toCode();
                retVal = CanonicalSubscriptionChannelType.fromCode(null, channelTypeCode);
                break;
            }
            case R4: {
                Subscription.SubscriptionChannelType type = ((Subscription)theSubscription).getChannel().getType();
                if (type == null) break;
                String channelTypeCode = type.toCode();
                retVal = CanonicalSubscriptionChannelType.fromCode(null, channelTypeCode);
                break;
            }
            case R5: {
                Coding nextTypeCode = ((org.hl7.fhir.r5.model.Subscription)theSubscription).getChannelType();
                CanonicalSubscriptionChannelType code = CanonicalSubscriptionChannelType.fromCode(nextTypeCode.getSystem(), nextTypeCode.getCode());
                if (code == null) break;
                retVal = code;
                break;
            }
        }
        return retVal;
    }

    @Nullable
    public String getCriteria(IBaseResource theSubscription) {
        String retVal = null;
        switch (this.myFhirContext.getVersion().getVersion()) {
            case DSTU2: {
                retVal = ((ca.uhn.fhir.model.dstu2.resource.Subscription)theSubscription).getCriteria();
                break;
            }
            case DSTU3: {
                retVal = ((org.hl7.fhir.dstu3.model.Subscription)theSubscription).getCriteria();
                break;
            }
            case R4: {
                retVal = ((Subscription)theSubscription).getCriteria();
                break;
            }
            case R5: {
                org.hl7.fhir.r5.model.Subscription subscription = (org.hl7.fhir.r5.model.Subscription)theSubscription;
                String topicElement = (String)subscription.getTopicElement().getValue();
                SubscriptionTopic topic = subscription.getContained().stream().filter(t -> ("#" + t.getId()).equals(topicElement) || t.getId().equals(topicElement)).findFirst().orElse(null);
                if (topic == null) {
                    ourLog.warn("Missing contained subscription topic in R5 subscription");
                    return null;
                }
                retVal = topic.getResourceTriggerFirstRep().getQueryCriteria().getCurrent();
            }
        }
        return retVal;
    }

    public void setMatchingStrategyTag(@Nonnull IBaseResource theSubscription, @Nullable SubscriptionMatchingStrategy theStrategy) {
        String display;
        IBaseMetaType meta = theSubscription.getMeta();
        meta.getTag().stream().filter(t -> "http://hapifhir.io/fhir/StructureDefinition/subscription-matching-strategy".equals(t.getSystem())).forEach(t -> {
            t.setCode(null);
            t.setSystem(null);
            t.setDisplay(null);
        });
        if (theStrategy == null) {
            return;
        }
        String value = theStrategy.toString();
        if (theStrategy == SubscriptionMatchingStrategy.DATABASE) {
            display = "Database";
        } else if (theStrategy == SubscriptionMatchingStrategy.IN_MEMORY) {
            display = "In-memory";
        } else {
            throw new IllegalStateException(Msg.code((int)567) + "Unknown " + SubscriptionMatchingStrategy.class.getSimpleName() + ": " + theStrategy);
        }
        meta.addTag().setSystem("http://hapifhir.io/fhir/StructureDefinition/subscription-matching-strategy").setCode(value).setDisplay(display);
    }

    public String getSubscriptionStatus(IBaseResource theSubscription) {
        IPrimitiveType status = (IPrimitiveType)this.myFhirContext.newTerser().getSingleValueOrNull((IBase)theSubscription, "Subscription.status", IPrimitiveType.class);
        if (status == null) {
            return null;
        }
        return status.getValueAsString();
    }
}

