/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.provider;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.jpa.subscription.triggering.ISubscriptionTriggeringSvc;
import ca.uhn.fhir.model.dstu2.valueset.ResourceTypeEnum;
import ca.uhn.fhir.rest.annotation.IdParam;
import ca.uhn.fhir.rest.annotation.Operation;
import ca.uhn.fhir.rest.annotation.OperationParam;
import ca.uhn.fhir.rest.server.IResourceProvider;
import java.util.List;
import org.hl7.fhir.instance.model.api.IBaseParameters;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.instance.model.api.IPrimitiveType;
import org.springframework.beans.factory.annotation.Autowired;

public class SubscriptionTriggeringProvider
implements IResourceProvider {
    @Autowired
    private FhirContext myFhirContext;
    @Autowired
    private ISubscriptionTriggeringSvc mySubscriptionTriggeringSvc;

    @Operation(name="$trigger-subscription")
    public IBaseParameters triggerSubscription(@OperationParam(name="resourceId", min=0, max=-1, typeName="uri") List<IPrimitiveType<String>> theResourceIds, @OperationParam(name="searchUrl", min=0, max=-1, typeName="string") List<IPrimitiveType<String>> theSearchUrls) {
        return this.mySubscriptionTriggeringSvc.triggerSubscription(theResourceIds, theSearchUrls, null);
    }

    @Operation(name="$trigger-subscription")
    public IBaseParameters triggerSubscription(@IdParam IIdType theSubscriptionId, @OperationParam(name="resourceId", min=0, max=-1, typeName="uri") List<IPrimitiveType<String>> theResourceIds, @OperationParam(name="searchUrl", min=0, max=-1, typeName="string") List<IPrimitiveType<String>> theSearchUrls) {
        return this.mySubscriptionTriggeringSvc.triggerSubscription(theResourceIds, theSearchUrls, theSubscriptionId);
    }

    public Class<? extends IBaseResource> getResourceType() {
        return this.myFhirContext.getResourceDefinition(ResourceTypeEnum.SUBSCRIPTION.getCode()).getImplementingClass();
    }
}

