/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.provider;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.jpa.api.dao.IFhirResourceDao;
import ca.uhn.fhir.jpa.api.model.DaoMethodOutcome;
import ca.uhn.fhir.jpa.api.model.DeleteMethodOutcome;
import ca.uhn.fhir.jpa.api.model.ExpungeOptions;
import ca.uhn.fhir.jpa.api.model.ExpungeOutcome;
import ca.uhn.fhir.jpa.provider.BaseJpaProvider;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.rest.annotation.At;
import ca.uhn.fhir.rest.annotation.ConditionalUrlParam;
import ca.uhn.fhir.rest.annotation.Create;
import ca.uhn.fhir.rest.annotation.Delete;
import ca.uhn.fhir.rest.annotation.History;
import ca.uhn.fhir.rest.annotation.IdParam;
import ca.uhn.fhir.rest.annotation.Offset;
import ca.uhn.fhir.rest.annotation.Operation;
import ca.uhn.fhir.rest.annotation.OperationParam;
import ca.uhn.fhir.rest.annotation.Patch;
import ca.uhn.fhir.rest.annotation.Read;
import ca.uhn.fhir.rest.annotation.ResourceParam;
import ca.uhn.fhir.rest.annotation.Since;
import ca.uhn.fhir.rest.annotation.Update;
import ca.uhn.fhir.rest.annotation.Validate;
import ca.uhn.fhir.rest.api.EncodingEnum;
import ca.uhn.fhir.rest.api.MethodOutcome;
import ca.uhn.fhir.rest.api.PatchTypeEnum;
import ca.uhn.fhir.rest.api.ValidationModeEnum;
import ca.uhn.fhir.rest.api.server.IBundleProvider;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.param.DateRangeParam;
import ca.uhn.fhir.rest.server.IResourceProvider;
import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;
import ca.uhn.fhir.util.CoverageIgnore;
import ca.uhn.fhir.util.ParametersUtil;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import org.hl7.fhir.instance.model.api.IBaseMetaType;
import org.hl7.fhir.instance.model.api.IBaseParameters;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.instance.model.api.IPrimitiveType;
import org.springframework.beans.factory.annotation.Required;

public abstract class BaseJpaResourceProvider<T extends IBaseResource>
extends BaseJpaProvider
implements IResourceProvider {
    private IFhirResourceDao<T> myDao;

    public BaseJpaResourceProvider() {
    }

    @CoverageIgnore
    public BaseJpaResourceProvider(IFhirResourceDao<T> theDao) {
        this.myDao = theDao;
    }

    protected IBaseParameters doExpunge(IIdType theIdParam, IPrimitiveType<? extends Integer> theLimit, IPrimitiveType<? extends Boolean> theExpungeDeletedResources, IPrimitiveType<? extends Boolean> theExpungeOldVersions, IPrimitiveType<? extends Boolean> theExpungeEverything, RequestDetails theRequest) {
        ExpungeOptions options = this.createExpungeOptions(theLimit, theExpungeDeletedResources, theExpungeOldVersions, theExpungeEverything);
        ExpungeOutcome outcome = theIdParam != null ? this.getDao().expunge(theIdParam, options, theRequest) : this.getDao().expunge(options, theRequest);
        return this.createExpungeResponse(outcome);
    }

    public IFhirResourceDao<T> getDao() {
        return this.myDao;
    }

    @Required
    public void setDao(IFhirResourceDao<T> theDao) {
        this.myDao = theDao;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @History
    public IBundleProvider getHistoryForResourceInstance(HttpServletRequest theRequest, @Offset Integer theOffset, @IdParam IIdType theId, @Since Date theSince, @At DateRangeParam theAt, RequestDetails theRequestDetails) {
        this.startRequest(theRequest);
        try {
            DateRangeParam sinceOrAt = this.processSinceOrAt(theSince, theAt);
            IBundleProvider iBundleProvider = this.myDao.history(theId, sinceOrAt.getLowerBoundAsInstant(), sinceOrAt.getUpperBoundAsInstant(), theOffset, theRequestDetails);
            return iBundleProvider;
        }
        finally {
            this.endRequest(theRequest);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @History
    public IBundleProvider getHistoryForResourceType(HttpServletRequest theRequest, @Offset Integer theOffset, @Since Date theSince, @At DateRangeParam theAt, RequestDetails theRequestDetails) {
        this.startRequest(theRequest);
        try {
            DateRangeParam sinceOrAt = this.processSinceOrAt(theSince, theAt);
            IBundleProvider iBundleProvider = this.myDao.history(sinceOrAt.getLowerBoundAsInstant(), sinceOrAt.getUpperBoundAsInstant(), theOffset, theRequestDetails);
            return iBundleProvider;
        }
        finally {
            this.endRequest(theRequest);
        }
    }

    public Class<? extends IBaseResource> getResourceType() {
        return this.myDao.getResourceType();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Patch
    public DaoMethodOutcome patch(HttpServletRequest theRequest, @IdParam IIdType theId, @ConditionalUrlParam String theConditionalUrl, RequestDetails theRequestDetails, @ResourceParam String theBody, PatchTypeEnum thePatchType, @ResourceParam IBaseParameters theRequestBody) {
        this.startRequest(theRequest);
        try {
            DaoMethodOutcome daoMethodOutcome = this.myDao.patch(theId, theConditionalUrl, thePatchType, theBody, theRequestBody, theRequestDetails);
            return daoMethodOutcome;
        }
        finally {
            this.endRequest(theRequest);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Read(version=true)
    public T read(HttpServletRequest theRequest, @IdParam IIdType theId, RequestDetails theRequestDetails) {
        this.startRequest(theRequest);
        try {
            T t = this.myDao.read(theId, theRequestDetails);
            return t;
        }
        finally {
            this.endRequest(theRequest);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Create
    public MethodOutcome create(HttpServletRequest theRequest, @ResourceParam T theResource, @ConditionalUrlParam String theConditional, RequestDetails theRequestDetails) {
        this.startRequest(theRequest);
        try {
            if (theConditional != null) {
                DaoMethodOutcome daoMethodOutcome = this.getDao().create(theResource, theConditional, theRequestDetails);
                return daoMethodOutcome;
            }
            DaoMethodOutcome daoMethodOutcome = this.getDao().create(theResource, theRequestDetails);
            return daoMethodOutcome;
        }
        finally {
            this.endRequest(theRequest);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Delete
    public MethodOutcome delete(HttpServletRequest theRequest, @IdParam IIdType theResource, @ConditionalUrlParam(supportsMultiple=true) String theConditional, RequestDetails theRequestDetails) {
        this.startRequest(theRequest);
        try {
            if (theConditional != null) {
                DeleteMethodOutcome deleteMethodOutcome = this.getDao().deleteByUrl(theConditional, theRequestDetails);
                return deleteMethodOutcome;
            }
            DaoMethodOutcome daoMethodOutcome = this.getDao().delete(theResource, theRequestDetails);
            return daoMethodOutcome;
        }
        finally {
            this.endRequest(theRequest);
        }
    }

    @Operation(name="$expunge", idempotent=false, returnParameters={@OperationParam(name="count", typeName="integer")})
    public IBaseParameters expunge(@IdParam IIdType theIdParam, @OperationParam(name="limit", typeName="integer") IPrimitiveType<Integer> theLimit, @OperationParam(name="expungeDeletedResources", typeName="boolean") IPrimitiveType<Boolean> theExpungeDeletedResources, @OperationParam(name="expungePreviousVersions", typeName="boolean") IPrimitiveType<Boolean> theExpungeOldVersions, RequestDetails theRequest) {
        return this.doExpunge(theIdParam, theLimit, theExpungeDeletedResources, theExpungeOldVersions, null, theRequest);
    }

    @Operation(name="$expunge", idempotent=false, returnParameters={@OperationParam(name="count", typeName="integer")})
    public IBaseParameters expunge(@OperationParam(name="limit", typeName="integer") IPrimitiveType<Integer> theLimit, @OperationParam(name="expungeDeletedResources", typeName="boolean") IPrimitiveType<Boolean> theExpungeDeletedResources, @OperationParam(name="expungePreviousVersions", typeName="boolean") IPrimitiveType<Boolean> theExpungeOldVersions, RequestDetails theRequest) {
        return this.doExpunge(null, theLimit, theExpungeDeletedResources, theExpungeOldVersions, null, theRequest);
    }

    @Description(value="Request a global list of tags, profiles, and security labels")
    @Operation(name="$meta", idempotent=true, returnParameters={@OperationParam(name="return", typeName="Meta")})
    public IBaseParameters meta(RequestDetails theRequestDetails) {
        Class metaType = this.getContext().getElementDefinition("Meta").getImplementingClass();
        Object metaGetOperation = this.getDao().metaGetOperation(metaType, theRequestDetails);
        IBaseParameters parameters = ParametersUtil.newInstance((FhirContext)this.getContext());
        ParametersUtil.addParameterToParameters((FhirContext)this.getContext(), (IBaseParameters)parameters, (String)"return", metaGetOperation);
        return parameters;
    }

    @Description(value="Request a list of tags, profiles, and security labels for a specfic resource instance")
    @Operation(name="$meta", idempotent=true, returnParameters={@OperationParam(name="return", typeName="Meta")})
    public IBaseParameters meta(@IdParam IIdType theId, RequestDetails theRequestDetails) {
        Class metaType = this.getContext().getElementDefinition("Meta").getImplementingClass();
        Object metaGetOperation = this.getDao().metaGetOperation(metaType, theId, theRequestDetails);
        IBaseParameters parameters = ParametersUtil.newInstance((FhirContext)this.getContext());
        ParametersUtil.addParameterToParameters((FhirContext)this.getContext(), (IBaseParameters)parameters, (String)"return", metaGetOperation);
        return parameters;
    }

    @Description(value="Add tags, profiles, and/or security labels to a resource")
    @Operation(name="$meta-add", idempotent=false, returnParameters={@OperationParam(name="return", typeName="Meta")})
    public IBaseParameters metaAdd(@IdParam IIdType theId, @OperationParam(name="meta", typeName="Meta") IBaseMetaType theMeta, RequestDetails theRequestDetails) {
        if (theMeta == null) {
            throw new InvalidRequestException(Msg.code((int)554) + "Input contains no parameter with name 'meta'");
        }
        IBaseMetaType metaAddOperation = this.getDao().metaAddOperation(theId, theMeta, theRequestDetails);
        IBaseParameters parameters = ParametersUtil.newInstance((FhirContext)this.getContext());
        ParametersUtil.addParameterToParameters((FhirContext)this.getContext(), (IBaseParameters)parameters, (String)"return", (Object)metaAddOperation);
        return parameters;
    }

    @Description(value="Delete tags, profiles, and/or security labels from a resource")
    @Operation(name="$meta-delete", idempotent=false, returnParameters={@OperationParam(name="return", typeName="Meta")})
    public IBaseParameters metaDelete(@IdParam IIdType theId, @OperationParam(name="meta", typeName="Meta") IBaseMetaType theMeta, RequestDetails theRequestDetails) {
        if (theMeta == null) {
            throw new InvalidRequestException(Msg.code((int)555) + "Input contains no parameter with name 'meta'");
        }
        IBaseMetaType metaDelete = this.getDao().metaDeleteOperation(theId, theMeta, theRequestDetails);
        IBaseParameters parameters = ParametersUtil.newInstance((FhirContext)this.getContext());
        ParametersUtil.addParameterToParameters((FhirContext)this.getContext(), (IBaseParameters)parameters, (String)"return", (Object)metaDelete);
        return parameters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Update
    public MethodOutcome update(HttpServletRequest theRequest, @ResourceParam T theResource, @IdParam IIdType theId, @ConditionalUrlParam String theConditional, RequestDetails theRequestDetails) {
        this.startRequest(theRequest);
        try {
            if (theConditional != null) {
                DaoMethodOutcome daoMethodOutcome = this.getDao().update(theResource, theConditional, theRequestDetails);
                return daoMethodOutcome;
            }
            DaoMethodOutcome daoMethodOutcome = this.getDao().update(theResource, theRequestDetails);
            return daoMethodOutcome;
        }
        finally {
            this.endRequest(theRequest);
        }
    }

    @Validate
    public MethodOutcome validate(@ResourceParam T theResource, @ResourceParam String theRawResource, @ResourceParam EncodingEnum theEncoding, @Validate.Mode ValidationModeEnum theMode, @Validate.Profile String theProfile, RequestDetails theRequestDetails) {
        return this.validate(theResource, null, theRawResource, theEncoding, theMode, theProfile, theRequestDetails);
    }

    @Validate
    public MethodOutcome validate(@ResourceParam T theResource, @IdParam IIdType theId, @ResourceParam String theRawResource, @ResourceParam EncodingEnum theEncoding, @Validate.Mode ValidationModeEnum theMode, @Validate.Profile String theProfile, RequestDetails theRequestDetails) {
        return this.getDao().validate(theResource, theId, theRawResource, theEncoding, theMode, theProfile, theRequestDetails);
    }
}

