/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.provider;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.jpa.api.config.DaoConfig;
import ca.uhn.fhir.jpa.api.model.ExpungeOptions;
import ca.uhn.fhir.jpa.api.model.ExpungeOutcome;
import ca.uhn.fhir.rest.param.DateRangeParam;
import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;
import ca.uhn.fhir.rest.server.servlet.ServletRequestDetails;
import ca.uhn.fhir.util.ParametersUtil;
import java.util.Date;
import java.util.Enumeration;
import java.util.TreeSet;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.instance.model.api.IBaseParameters;
import org.hl7.fhir.instance.model.api.IPrimitiveType;
import org.jboss.logging.MDC;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class BaseJpaProvider {
    public static final String REMOTE_ADDR = "req.remoteAddr";
    public static final String REMOTE_UA = "req.userAgent";
    private static final Logger ourLog = LoggerFactory.getLogger(BaseJpaProvider.class);
    @Autowired
    protected DaoConfig myDaoConfig;
    @Autowired
    private FhirContext myContext;

    public void setDaoConfigForUnitTest(DaoConfig theDaoConfig) {
        this.myDaoConfig = theDaoConfig;
    }

    protected ExpungeOptions createExpungeOptions(IPrimitiveType<? extends Integer> theLimit, IPrimitiveType<? extends Boolean> theExpungeDeletedResources, IPrimitiveType<? extends Boolean> theExpungeOldVersions, IPrimitiveType<? extends Boolean> theExpungeEverything) {
        ExpungeOptions options = new ExpungeOptions();
        if (theLimit != null && theLimit.getValue() != null) {
            options.setLimit((Integer)theLimit.getValue());
        }
        if (theExpungeOldVersions != null && theExpungeOldVersions.getValue() != null) {
            options.setExpungeOldVersions((Boolean)theExpungeOldVersions.getValue());
        }
        if (theExpungeDeletedResources != null && theExpungeDeletedResources.getValue() != null) {
            options.setExpungeDeletedResources((Boolean)theExpungeDeletedResources.getValue());
        }
        if (theExpungeEverything != null && theExpungeEverything.getValue() != null) {
            options.setExpungeEverything((Boolean)theExpungeEverything.getValue());
        }
        return options;
    }

    protected IBaseParameters createExpungeResponse(ExpungeOutcome theOutcome) {
        IBaseParameters parameters = ParametersUtil.newInstance((FhirContext)this.getContext());
        String value = Integer.toString(theOutcome.getDeletedCount());
        ParametersUtil.addParameterToParameters((FhirContext)this.getContext(), (IBaseParameters)parameters, (String)"count", (String)"integer", (String)value);
        return parameters;
    }

    public void endRequest(HttpServletRequest theRequest) {
        MDC.remove((String)REMOTE_ADDR);
        MDC.remove((String)REMOTE_UA);
    }

    public void endRequest(ServletRequestDetails theRequest) {
        this.endRequest(theRequest.getServletRequest());
    }

    public FhirContext getContext() {
        return this.myContext;
    }

    public void setContext(FhirContext theContext) {
        this.myContext = theContext;
    }

    protected DateRangeParam processSinceOrAt(Date theSince, DateRangeParam theAt) {
        boolean haveAt;
        boolean bl = haveAt = theAt != null && (theAt.getLowerBoundAsInstant() != null || theAt.getUpperBoundAsInstant() != null);
        if (haveAt && theSince != null) {
            String msg = this.getContext().getLocalizer().getMessage(BaseJpaProvider.class, "cantCombintAtAndSince", new Object[0]);
            throw new InvalidRequestException(Msg.code((int)553) + msg);
        }
        if (haveAt) {
            return theAt;
        }
        return new DateRangeParam(theSince, null);
    }

    public void startRequest(HttpServletRequest theRequest) {
        if (theRequest == null) {
            return;
        }
        TreeSet<String> headerNames = new TreeSet<String>();
        Enumeration enums = theRequest.getHeaderNames();
        while (enums.hasMoreElements()) {
            headerNames.add((String)enums.nextElement());
        }
        ourLog.debug("Request headers: {}", headerNames);
        Enumeration forwardedFors = theRequest.getHeaders("x-forwarded-for");
        StringBuilder b = new StringBuilder();
        Enumeration enums2 = forwardedFors;
        while (enums2 != null && enums2.hasMoreElements()) {
            if (b.length() > 0) {
                b.append(" / ");
            }
            b.append((String)enums2.nextElement());
        }
        String forwardedFor = b.toString();
        String ip = theRequest.getRemoteAddr();
        if (StringUtils.isBlank((CharSequence)forwardedFor)) {
            org.slf4j.MDC.put((String)REMOTE_ADDR, (String)ip);
            ourLog.debug("Request is from address: {}", (Object)ip);
        } else {
            org.slf4j.MDC.put((String)REMOTE_ADDR, (String)forwardedFor);
            ourLog.debug("Request is from forwarded address: {}", (Object)forwardedFor);
        }
        String userAgent = StringUtils.defaultString((String)theRequest.getHeader("user-agent"));
        org.slf4j.MDC.put((String)REMOTE_UA, (String)userAgent);
    }

    public void startRequest(ServletRequestDetails theRequest) {
        this.startRequest(theRequest.getServletRequest());
    }
}

