/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.patch;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.parser.DataFormatException;
import ca.uhn.fhir.parser.IParser;
import ca.uhn.fhir.parser.IParserErrorHandler;
import ca.uhn.fhir.parser.StrictErrorHandler;
import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.fge.jsonpatch.JsonPatch;
import com.github.fge.jsonpatch.JsonPatchException;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.intellij.lang.annotations.Language;

public class JsonPatchUtils {
    public static <T extends IBaseResource> T apply(FhirContext theCtx, T theResourceToUpdate, @Language(value="JSON") String thePatchBody) {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(JsonParser.Feature.INCLUDE_SOURCE_IN_LOCATION, false);
        JsonFactory factory = mapper.getFactory();
        try {
            IBaseResource retVal;
            JsonParser parser = factory.createParser(thePatchBody);
            JsonNode jsonPatchNode = (JsonNode)mapper.readTree(parser);
            JsonPatch patch = JsonPatch.fromJson((JsonNode)jsonPatchNode);
            JsonNode originalJsonDocument = mapper.readTree(theCtx.newJsonParser().encodeResourceToString(theResourceToUpdate));
            JsonNode after = patch.apply(originalJsonDocument);
            Class<?> clazz = theResourceToUpdate.getClass();
            String postPatchedContent = mapper.writeValueAsString((Object)after);
            IParser fhirJsonParser = theCtx.newJsonParser();
            fhirJsonParser.setParserErrorHandler((IParserErrorHandler)new StrictErrorHandler());
            try {
                retVal = fhirJsonParser.parseResource(clazz, postPatchedContent);
            }
            catch (DataFormatException e) {
                String resourceId = theResourceToUpdate.getIdElement().toUnqualifiedVersionless().getValue();
                String resourceType = theCtx.getResourceDefinition(theResourceToUpdate).getName();
                resourceId = StringUtils.defaultString((String)resourceId, (String)resourceType);
                String msg = theCtx.getLocalizer().getMessage(JsonPatchUtils.class, "failedToApplyPatch", new Object[]{resourceId, e.getMessage()});
                throw new InvalidRequestException(Msg.code((int)1271) + msg);
            }
            return (T)retVal;
        }
        catch (JsonPatchException | IOException theE) {
            throw new InvalidRequestException(Msg.code((int)1272) + theE.getMessage());
        }
    }
}

