/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.interceptor.validation;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.support.IValidationSupport;
import ca.uhn.fhir.interceptor.api.IInterceptorBroadcaster;
import ca.uhn.fhir.jpa.interceptor.validation.IRepositoryValidatingRule;
import ca.uhn.fhir.jpa.interceptor.validation.IRuleRoot;
import ca.uhn.fhir.jpa.interceptor.validation.RequireValidationRule;
import ca.uhn.fhir.jpa.interceptor.validation.RuleDisallowProfile;
import ca.uhn.fhir.jpa.interceptor.validation.RuleRequireProfileDeclaration;
import ca.uhn.fhir.jpa.validation.ValidatorPolicyAdvisor;
import ca.uhn.fhir.jpa.validation.ValidatorResourceFetcher;
import ca.uhn.fhir.validation.ResultSeverityEnum;
import com.google.common.base.Ascii;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.text.WordUtils;
import org.hl7.fhir.r5.utils.validation.constants.BestPracticeWarningLevel;
import org.springframework.beans.factory.annotation.Autowired;

public final class RepositoryValidatingRuleBuilder
implements IRuleRoot {
    public static final String REPOSITORY_VALIDATING_RULE_BUILDER = "repositoryValidatingRuleBuilder";
    private final List<IRepositoryValidatingRule> myRules = new ArrayList<IRepositoryValidatingRule>();
    @Autowired
    private FhirContext myFhirContext;
    private final IValidationSupport myValidationSupport;
    @Autowired
    private ValidatorResourceFetcher myValidatorResourceFetcher;
    @Autowired
    private ValidatorPolicyAdvisor myValidationPolicyAdvisor;
    @Autowired
    private IInterceptorBroadcaster myInterceptorBroadcaster;

    public RepositoryValidatingRuleBuilder(IValidationSupport theValidationSupport) {
        this.myValidationSupport = theValidationSupport;
    }

    @Override
    public RepositoryValidatingRuleBuilderTyped forResourcesOfType(String theType) {
        return new RepositoryValidatingRuleBuilderTyped(theType);
    }

    @Override
    public List<IRepositoryValidatingRule> build() {
        return this.myRules;
    }

    public final class RepositoryValidatingRuleBuilderTyped {
        private final String myType;

        RepositoryValidatingRuleBuilderTyped(String theType) {
            this.myType = RepositoryValidatingRuleBuilder.this.myFhirContext.getResourceType(theType);
        }

        public FinalizedTypedRule requireAtLeastProfile(String theProfileUrl) {
            return this.requireAtLeastOneProfileOf(theProfileUrl);
        }

        public FinalizedTypedRule requireAtLeastOneProfileOf(String ... theProfileUrls) {
            Validate.notNull((Object)theProfileUrls, (String)"theProfileUrls must not be null", (Object[])new Object[0]);
            this.requireAtLeastOneProfileOf(Arrays.asList(theProfileUrls));
            return new FinalizedTypedRule(this.myType);
        }

        private FinalizedTypedRule requireAtLeastOneProfileOf(Collection<String> theProfileUrls) {
            Validate.notNull(theProfileUrls, (String)"theProfileUrls must not be null", (Object[])new Object[0]);
            Validate.notEmpty(theProfileUrls, (String)"theProfileUrls must not be null or empty", (Object[])new Object[0]);
            RepositoryValidatingRuleBuilder.this.myRules.add(new RuleRequireProfileDeclaration(RepositoryValidatingRuleBuilder.this.myFhirContext, this.myType, theProfileUrls));
            return new FinalizedTypedRule(this.myType);
        }

        public FinalizedTypedRule disallowProfile(String theProfileUrl) {
            return this.disallowProfiles(theProfileUrl);
        }

        public FinalizedRequireValidationRule requireValidationToDeclaredProfiles() {
            RequireValidationRule rule = new RequireValidationRule(RepositoryValidatingRuleBuilder.this.myFhirContext, this.myType, RepositoryValidatingRuleBuilder.this.myValidationSupport, RepositoryValidatingRuleBuilder.this.myValidatorResourceFetcher, RepositoryValidatingRuleBuilder.this.myValidationPolicyAdvisor, RepositoryValidatingRuleBuilder.this.myInterceptorBroadcaster);
            RepositoryValidatingRuleBuilder.this.myRules.add(rule);
            return new FinalizedRequireValidationRule(rule);
        }

        public FinalizedTypedRule disallowProfiles(String ... theProfileUrls) {
            Validate.notNull((Object)theProfileUrls, (String)"theProfileUrl must not be null or empty", (Object[])new Object[0]);
            Validate.notEmpty((Object[])theProfileUrls, (String)"theProfileUrl must not be null or empty", (Object[])new Object[0]);
            RepositoryValidatingRuleBuilder.this.myRules.add(new RuleDisallowProfile(RepositoryValidatingRuleBuilder.this.myFhirContext, this.myType, theProfileUrls));
            return new FinalizedTypedRule(this.myType);
        }

        public class FinalizedRequireValidationRule
        extends FinalizedTypedRule {
            private final RequireValidationRule myRule;

            public FinalizedRequireValidationRule(RequireValidationRule theRule) {
                super(RepositoryValidatingRuleBuilderTyped.this.myType);
                this.myRule = theRule;
            }

            @Nonnull
            public FinalizedRequireValidationRule withBestPracticeWarningLevel(String theBestPracticeWarningLevel) {
                BestPracticeWarningLevel level = null;
                if (StringUtils.isNotBlank((CharSequence)theBestPracticeWarningLevel)) {
                    level = BestPracticeWarningLevel.valueOf((String)WordUtils.capitalize((String)theBestPracticeWarningLevel.toLowerCase()));
                }
                return this.withBestPracticeWarningLevel(level);
            }

            @Nonnull
            public FinalizedRequireValidationRule withBestPracticeWarningLevel(BestPracticeWarningLevel bestPracticeWarningLevel) {
                this.myRule.setBestPracticeWarningLevel(bestPracticeWarningLevel);
                return this;
            }

            @Nonnull
            public FinalizedRequireValidationRule neverReject() {
                this.myRule.dontReject();
                return this;
            }

            @Nonnull
            public FinalizedRequireValidationRule rejectOnSeverity(@Nonnull String theSeverity) {
                ResultSeverityEnum severity = ResultSeverityEnum.fromCode((String)Ascii.toLowerCase((String)theSeverity));
                Validate.notNull((Object)severity, (String)"Invalid severity code: %s", (Object[])new Object[]{theSeverity});
                return this.rejectOnSeverity(severity);
            }

            @Nonnull
            public FinalizedRequireValidationRule rejectOnSeverity(@Nonnull ResultSeverityEnum theSeverity) {
                this.myRule.rejectOnSeverity(theSeverity);
                return this;
            }

            @Nonnull
            public FinalizedRequireValidationRule tagOnSeverity(@Nonnull String theSeverity, @Nonnull String theTagSystem, @Nonnull String theTagCode) {
                ResultSeverityEnum severity = ResultSeverityEnum.fromCode((String)Ascii.toLowerCase((String)theSeverity));
                return this.tagOnSeverity(severity, theTagSystem, theTagCode);
            }

            @Nonnull
            public FinalizedRequireValidationRule tagOnSeverity(@Nonnull ResultSeverityEnum theSeverity, @Nonnull String theTagSystem, @Nonnull String theTagCode) {
                this.myRule.tagOnSeverity(theSeverity, theTagSystem, theTagCode);
                return this;
            }

            @Nonnull
            public FinalizedRequireValidationRule allowAnyExtensions() {
                this.myRule.getValidator().setAnyExtensionsAllowed(true);
                return this;
            }

            @Nonnull
            public FinalizedRequireValidationRule rejectUnknownExtensions() {
                this.myRule.getValidator().setAnyExtensionsAllowed(false);
                return this;
            }

            @Nonnull
            public FinalizedRequireValidationRule disableTerminologyChecks() {
                this.myRule.getValidator().setNoTerminologyChecks(true);
                return this;
            }

            @Nonnull
            public FinalizedRequireValidationRule errorOnUnknownProfiles() {
                this.myRule.getValidator().setErrorForUnknownProfiles(true);
                return this;
            }

            @Nonnull
            public FinalizedRequireValidationRule suppressNoBindingMessage() {
                this.myRule.getValidator().setNoBindingMsgSuppressed(true);
                return this;
            }

            @Nonnull
            public FinalizedRequireValidationRule suppressWarningForExtensibleValueSetValidation() {
                this.myRule.getValidator().setNoExtensibleWarnings(true);
                return this;
            }
        }
    }

    public class FinalizedTypedRule
    implements IRuleRoot {
        private final String myType;

        FinalizedTypedRule(String theType) {
            this.myType = theType;
        }

        @Override
        public RepositoryValidatingRuleBuilderTyped forResourcesOfType(String theType) {
            return RepositoryValidatingRuleBuilder.this.forResourcesOfType(theType);
        }

        @Override
        public List<IRepositoryValidatingRule> build() {
            return RepositoryValidatingRuleBuilder.this.build();
        }

        public RepositoryValidatingRuleBuilderTyped and() {
            return new RepositoryValidatingRuleBuilderTyped(this.myType);
        }
    }
}

