/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.interceptor.validation;

import ca.uhn.fhir.rest.api.server.RequestDetails;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.Validate;
import org.hl7.fhir.instance.model.api.IBaseOperationOutcome;
import org.hl7.fhir.instance.model.api.IBaseResource;

public interface IRepositoryValidatingRule {
    @Nonnull
    public String getResourceType();

    @Nonnull
    public RuleEvaluation evaluate(RequestDetails var1, @Nonnull IBaseResource var2);

    public static class RuleEvaluation {
        private final IBaseOperationOutcome myOperationOutcome;
        private IRepositoryValidatingRule myRule;
        private boolean myPasses;
        private String myFailureDescription;

        private RuleEvaluation(IRepositoryValidatingRule theRule, boolean thePasses, String theFailureDescription, IBaseOperationOutcome theOperationOutcome) {
            this.myRule = theRule;
            this.myPasses = thePasses;
            this.myFailureDescription = theFailureDescription;
            this.myOperationOutcome = theOperationOutcome;
        }

        static RuleEvaluation forSuccess(IRepositoryValidatingRule theRule) {
            Validate.notNull((Object)theRule);
            return new RuleEvaluation(theRule, true, null, null);
        }

        static RuleEvaluation forFailure(IRepositoryValidatingRule theRule, String theFailureDescription) {
            Validate.notNull((Object)theRule);
            Validate.notNull((Object)theFailureDescription);
            return new RuleEvaluation(theRule, false, theFailureDescription, null);
        }

        static RuleEvaluation forFailure(IRepositoryValidatingRule theRule, IBaseOperationOutcome theOperationOutcome) {
            Validate.notNull((Object)theRule);
            Validate.notNull((Object)theOperationOutcome);
            return new RuleEvaluation(theRule, false, null, theOperationOutcome);
        }

        public IBaseOperationOutcome getOperationOutcome() {
            return this.myOperationOutcome;
        }

        public IRepositoryValidatingRule getRule() {
            return this.myRule;
        }

        public boolean isPasses() {
            return this.myPasses;
        }

        public String getFailureDescription() {
            return this.myFailureDescription;
        }
    }
}

