/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.interceptor;

import ca.uhn.fhir.interceptor.api.Hook;
import ca.uhn.fhir.interceptor.api.Interceptor;
import ca.uhn.fhir.interceptor.api.Pointcut;
import ca.uhn.fhir.jpa.api.model.ResourceVersionConflictResolutionStrategy;
import ca.uhn.fhir.jpa.partition.SystemRequestDetails;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;

@Interceptor
public class UserRequestRetryVersionConflictsInterceptor {
    public static final String HEADER_NAME = "X-Retry-On-Version-Conflict";
    public static final String MAX_RETRIES = "max-retries";
    public static final String RETRY = "retry";

    @Hook(value=Pointcut.STORAGE_VERSION_CONFLICT, order=100)
    public ResourceVersionConflictResolutionStrategy check(RequestDetails theRequestDetails) {
        List headers;
        ResourceVersionConflictResolutionStrategy retVal = new ResourceVersionConflictResolutionStrategy();
        if (theRequestDetails != null && (headers = theRequestDetails.getHeaders(HEADER_NAME)) != null) {
            for (String headerValue : headers) {
                if (!StringUtils.isNotBlank((CharSequence)headerValue)) continue;
                StringTokenizer tok = new StringTokenizer(headerValue, ";");
                while (tok.hasMoreTokens()) {
                    String next = StringUtils.trim((String)tok.nextToken());
                    if (next.equals(RETRY)) {
                        retVal.setRetry(true);
                        continue;
                    }
                    if (!next.startsWith("max-retries=")) continue;
                    String val = StringUtils.trim((String)next.substring("max-retries=".length()));
                    int maxRetries = Integer.parseInt(val);
                    maxRetries = Math.min(100, maxRetries);
                    retVal.setMaxRetries(maxRetries);
                }
            }
        }
        return retVal;
    }

    public static void addRetryHeader(SystemRequestDetails theRequestDetails, int theMaxRetries) {
        Validate.inclusiveBetween((long)1L, (long)Integer.MAX_VALUE, (long)theMaxRetries, (String)"Max retries must be > 0");
        String value = "retry; max-retries=" + theMaxRetries;
        theRequestDetails.addHeader(HEADER_NAME, value);
    }
}

