/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.interceptor;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.RuntimeResourceDefinition;
import ca.uhn.fhir.context.RuntimeSearchParam;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.interceptor.api.Hook;
import ca.uhn.fhir.interceptor.api.Interceptor;
import ca.uhn.fhir.interceptor.api.Pointcut;
import ca.uhn.fhir.interceptor.model.ReadPartitionIdRequestDetails;
import ca.uhn.fhir.interceptor.model.RequestPartitionId;
import ca.uhn.fhir.jpa.searchparam.SearchParameterMap;
import ca.uhn.fhir.jpa.searchparam.extractor.BaseSearchParamExtractor;
import ca.uhn.fhir.jpa.searchparam.extractor.ISearchParamExtractor;
import ca.uhn.fhir.model.api.IQueryParameterType;
import ca.uhn.fhir.rest.api.RestSearchParameterTypeEnum;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.param.ReferenceParam;
import ca.uhn.fhir.rest.server.exceptions.MethodNotAllowedException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseReference;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.r4.model.IdType;
import org.springframework.beans.factory.annotation.Autowired;

@Interceptor
public class PatientIdPartitionInterceptor {
    @Autowired
    private FhirContext myFhirContext;
    @Autowired
    private ISearchParamExtractor mySearchParamExtractor;

    public PatientIdPartitionInterceptor() {
    }

    public PatientIdPartitionInterceptor(FhirContext theFhirContext, ISearchParamExtractor theSearchParamExtractor) {
        this();
        this.myFhirContext = theFhirContext;
        this.mySearchParamExtractor = theSearchParamExtractor;
    }

    @Hook(value=Pointcut.STORAGE_PARTITION_IDENTIFY_CREATE)
    public RequestPartitionId identifyForCreate(IBaseResource theResource, RequestDetails theRequestDetails) {
        String compartmentIdentity;
        RuntimeResourceDefinition resourceDef = this.myFhirContext.getResourceDefinition(theResource);
        List<RuntimeSearchParam> compartmentSps = this.getCompartmentSearchParams(resourceDef);
        if (compartmentSps.isEmpty()) {
            return this.provideNonCompartmentMemberTypeResponse(theResource);
        }
        if (resourceDef.getName().equals("Patient")) {
            compartmentIdentity = theResource.getIdElement().getIdPart();
            if (StringUtils.isBlank((CharSequence)compartmentIdentity)) {
                throw new MethodNotAllowedException(Msg.code((int)1321) + "Patient resource IDs must be client-assigned in patient compartment mode");
            }
        } else {
            compartmentIdentity = compartmentSps.stream().flatMap(param -> Arrays.stream(BaseSearchParamExtractor.splitPathsR4((String)param.getPath()))).filter(StringUtils::isNotBlank).map(path -> this.mySearchParamExtractor.getPathValueExtractor(theResource, path).get()).filter(t -> !t.isEmpty()).map(t -> (IBase)t.get(0)).filter(t -> t instanceof IBaseReference).map(t -> (IBaseReference)t).map(t -> t.getReferenceElement().getValue()).map(t -> new IdType(t).getIdPart()).filter(StringUtils::isNotBlank).findFirst().orElse(null);
            if (StringUtils.isBlank((CharSequence)compartmentIdentity)) {
                return this.provideNonCompartmentMemberInstanceResponse(theResource);
            }
        }
        return this.provideCompartmentMemberInstanceResponse(theRequestDetails, compartmentIdentity);
    }

    @Hook(value=Pointcut.STORAGE_PARTITION_IDENTIFY_READ)
    public RequestPartitionId identifyForRead(ReadPartitionIdRequestDetails theReadDetails, RequestDetails theRequestDetails) {
        RuntimeResourceDefinition resourceDef = this.myFhirContext.getResourceDefinition(theReadDetails.getResourceType());
        List<RuntimeSearchParam> compartmentSps = this.getCompartmentSearchParams(resourceDef);
        if (compartmentSps.isEmpty()) {
            return this.provideNonCompartmentMemberTypeResponse(null);
        }
        switch (theReadDetails.getRestOperationType()) {
            case READ: 
            case VREAD: {
                if (!"Patient".equals(theReadDetails.getResourceType())) break;
                return this.provideCompartmentMemberInstanceResponse(theRequestDetails, theReadDetails.getReadResourceId().getIdPart());
            }
            case SEARCH_TYPE: {
                SearchParameterMap params = (SearchParameterMap)theReadDetails.getSearchParams();
                String idPart = null;
                if ("Patient".equals(theReadDetails.getResourceType())) {
                    idPart = this.getSingleResourceIdValueOrNull(params, "_id", "Patient");
                } else {
                    RuntimeSearchParam nextCompartmentSp;
                    Iterator<RuntimeSearchParam> iterator = compartmentSps.iterator();
                    while (iterator.hasNext() && (idPart = this.getSingleResourceIdValueOrNull(params, (nextCompartmentSp = iterator.next()).getName(), "Patient")) == null) {
                    }
                }
                if (!StringUtils.isNotBlank((CharSequence)idPart)) break;
                return this.provideCompartmentMemberInstanceResponse(theRequestDetails, idPart);
            }
        }
        if (theReadDetails.getConditionalTargetOrNull() != null) {
            return this.identifyForCreate(theReadDetails.getConditionalTargetOrNull(), theRequestDetails);
        }
        return this.provideNonPatientSpecificQueryResponse(theReadDetails);
    }

    @Nonnull
    private List<RuntimeSearchParam> getCompartmentSearchParams(RuntimeResourceDefinition resourceDef) {
        return resourceDef.getSearchParams().stream().filter(param -> param.getParamType() == RestSearchParameterTypeEnum.REFERENCE).filter(param -> param.getProvidesMembershipInCompartments() != null && param.getProvidesMembershipInCompartments().contains("Patient")).collect(Collectors.toList());
    }

    private String getSingleResourceIdValueOrNull(SearchParameterMap theParams, String theParamName, String theResourceType) {
        String idPart = null;
        List idParamAndList = theParams.get(theParamName);
        if (idParamAndList != null && idParamAndList.size() == 1) {
            List idParamOrList = (List)idParamAndList.get(0);
            if (idParamOrList.size() == 1) {
                String chain;
                IQueryParameterType idParam = (IQueryParameterType)idParamOrList.get(0);
                if (StringUtils.isNotBlank((CharSequence)idParam.getQueryParameterQualifier())) {
                    throw new MethodNotAllowedException(Msg.code((int)1322) + "The parameter " + theParamName + idParam.getQueryParameterQualifier() + " is not supported in patient compartment mode");
                }
                if (idParam instanceof ReferenceParam && (chain = ((ReferenceParam)idParam).getChain()) != null) {
                    throw new MethodNotAllowedException(Msg.code((int)1323) + "The parameter " + theParamName + "." + chain + " is not supported in patient compartment mode");
                }
                IdType id = new IdType(idParam.getValueAsQueryToken(this.myFhirContext));
                if (!id.hasResourceType() || id.getResourceType().equals(theResourceType)) {
                    idPart = id.getIdPart();
                }
            } else if (idParamOrList.size() > 1) {
                throw new MethodNotAllowedException(Msg.code((int)1324) + "Multiple values for parameter " + theParamName + " is not supported in patient compartment mode");
            }
        } else if (idParamAndList != null && idParamAndList.size() > 1) {
            throw new MethodNotAllowedException(Msg.code((int)1325) + "Multiple values for parameter " + theParamName + " is not supported in patient compartment mode");
        }
        return idPart;
    }

    protected RequestPartitionId provideNonPatientSpecificQueryResponse(ReadPartitionIdRequestDetails theRequestDetails) {
        return RequestPartitionId.allPartitions();
    }

    @Nonnull
    protected RequestPartitionId provideCompartmentMemberInstanceResponse(RequestDetails theRequestDetails, String theResourceIdPart) {
        int partitionId = this.providePartitionIdForPatientId(theRequestDetails, theResourceIdPart);
        return RequestPartitionId.fromPartitionId((Integer)partitionId);
    }

    protected int providePartitionIdForPatientId(RequestDetails theRequestDetails, String theResourceIdPart) {
        return Math.abs(theResourceIdPart.hashCode() % 15000);
    }

    @Nonnull
    protected RequestPartitionId provideNonCompartmentMemberInstanceResponse(IBaseResource theResource) {
        throw new MethodNotAllowedException(Msg.code((int)1326) + "Resource of type " + this.myFhirContext.getResourceType(theResource) + " has no values placing it in the Patient compartment");
    }

    @Nonnull
    protected RequestPartitionId provideNonCompartmentMemberTypeResponse(IBaseResource theResource) {
        return RequestPartitionId.defaultPartition();
    }
}

