/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.dao.tx;

import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.interceptor.api.HookParams;
import ca.uhn.fhir.interceptor.api.IInterceptorBroadcaster;
import ca.uhn.fhir.interceptor.api.Pointcut;
import ca.uhn.fhir.jpa.api.model.ResourceVersionConflictResolutionStrategy;
import ca.uhn.fhir.jpa.dao.DaoFailureUtil;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.api.server.storage.TransactionDetails;
import ca.uhn.fhir.rest.server.exceptions.InternalErrorException;
import ca.uhn.fhir.rest.server.exceptions.ResourceVersionConflictException;
import ca.uhn.fhir.rest.server.servlet.ServletRequestDetails;
import ca.uhn.fhir.rest.server.util.CompositeInterceptorBroadcaster;
import ca.uhn.fhir.util.TestUtil;
import com.google.common.annotations.VisibleForTesting;
import javax.annotation.Nullable;
import javax.annotation.PostConstruct;
import org.hl7.fhir.instance.model.api.IBaseOperationOutcome;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionTemplate;

public class HapiTransactionService {
    public static final String XACT_USERDATA_KEY_RESOLVED_TAG_DEFINITIONS = HapiTransactionService.class.getName() + "_RESOLVED_TAG_DEFINITIONS";
    public static final String XACT_USERDATA_KEY_EXISTING_SEARCH_PARAMS = HapiTransactionService.class.getName() + "_EXISTING_SEARCH_PARAMS";
    private static final Logger ourLog = LoggerFactory.getLogger(HapiTransactionService.class);
    @Autowired
    protected IInterceptorBroadcaster myInterceptorBroadcaster;
    @Autowired
    protected PlatformTransactionManager myTransactionManager;
    protected TransactionTemplate myTxTemplate;

    @VisibleForTesting
    public void setInterceptorBroadcaster(IInterceptorBroadcaster theInterceptorBroadcaster) {
        this.myInterceptorBroadcaster = theInterceptorBroadcaster;
    }

    @VisibleForTesting
    public void setTransactionManager(PlatformTransactionManager theTransactionManager) {
        this.myTransactionManager = theTransactionManager;
    }

    @PostConstruct
    public void start() {
        this.myTxTemplate = new TransactionTemplate(this.myTransactionManager);
    }

    public <T> T execute(RequestDetails theRequestDetails, TransactionDetails theTransactionDetails, TransactionCallback<T> theCallback) {
        return this.execute(theRequestDetails, theTransactionDetails, theCallback, null);
    }

    public <T> T execute(RequestDetails theRequestDetails, TransactionDetails theTransactionDetails, TransactionCallback<T> theCallback, Runnable theOnRollback) {
        int i = 0;
        while (true) {
            try {
                return this.doExecuteCallback(theCallback);
            }
            catch (ResourceVersionConflictException | DataIntegrityViolationException e) {
                HookParams params;
                ResourceVersionConflictResolutionStrategy conflictResolutionStrategy;
                ourLog.debug("Version conflict detected", e);
                if (theOnRollback != null) {
                    theOnRollback.run();
                }
                int maxRetries = 0;
                if (DaoFailureUtil.isTagStorageFailure(e)) {
                    maxRetries = 3;
                }
                if (maxRetries == 0 && (conflictResolutionStrategy = (ResourceVersionConflictResolutionStrategy)CompositeInterceptorBroadcaster.doCallHooksAndReturnObject((IInterceptorBroadcaster)this.myInterceptorBroadcaster, (RequestDetails)theRequestDetails, (Pointcut)Pointcut.STORAGE_VERSION_CONFLICT, (HookParams)(params = new HookParams().add(RequestDetails.class, (Object)theRequestDetails).addIfMatchesType(ServletRequestDetails.class, (Object)theRequestDetails)))) != null && conflictResolutionStrategy.isRetry()) {
                    maxRetries = conflictResolutionStrategy.getMaxRetries();
                }
                if (i >= maxRetries) {
                    IBaseOperationOutcome oo = null;
                    if (e instanceof ResourceVersionConflictException) {
                        oo = ((ResourceVersionConflictException)e).getOperationOutcome();
                    }
                    if (maxRetries > 0) {
                        String msg = "Max retries (" + maxRetries + ") exceeded for version conflict: " + e.getMessage();
                        ourLog.info(msg, (Object)maxRetries);
                        throw new ResourceVersionConflictException(Msg.code((int)549) + msg);
                    }
                    throw new ResourceVersionConflictException(Msg.code((int)550) + e.getMessage(), e, oo);
                }
                theTransactionDetails.getRollbackUndoActions().forEach(t -> t.run());
                theTransactionDetails.clearRollbackUndoActions();
                theTransactionDetails.clearResolvedItems();
                theTransactionDetails.clearUserData(XACT_USERDATA_KEY_RESOLVED_TAG_DEFINITIONS);
                theTransactionDetails.clearUserData(XACT_USERDATA_KEY_EXISTING_SEARCH_PARAMS);
                double sleepAmount = 250.0 * (double)i * Math.random();
                long sleepAmountLong = (long)sleepAmount;
                TestUtil.sleepAtLeast((long)sleepAmountLong, (boolean)false);
                ourLog.info("About to start a transaction retry due to conflict or constraint error. Sleeping {}ms first.", (Object)sleepAmountLong);
                ++i;
                continue;
            }
            break;
        }
    }

    @Nullable
    protected <T> T doExecuteCallback(TransactionCallback<T> theCallback) {
        try {
            return (T)this.myTxTemplate.execute(theCallback);
        }
        catch (MyException e) {
            if (e.getCause() instanceof RuntimeException) {
                throw (RuntimeException)e.getCause();
            }
            throw new InternalErrorException(Msg.code((int)551) + e);
        }
    }

    static class MyException
    extends RuntimeException {
        public MyException(Throwable theThrowable) {
            super(theThrowable);
        }
    }
}

