/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.dao.expunge;

import ca.uhn.fhir.jpa.api.config.DaoConfig;
import ca.uhn.fhir.jpa.api.model.ExpungeOptions;
import ca.uhn.fhir.jpa.api.model.ExpungeOutcome;
import ca.uhn.fhir.jpa.dao.expunge.ExpungeService;
import ca.uhn.fhir.jpa.dao.expunge.IResourceExpungeService;
import ca.uhn.fhir.jpa.dao.expunge.PartitionRunner;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.api.server.storage.ResourcePersistentId;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
public class ExpungeOperation
implements Callable<ExpungeOutcome> {
    private static final Logger ourLog = LoggerFactory.getLogger(ExpungeService.class);
    public static final String PROCESS_NAME = "Expunging";
    public static final String THREAD_PREFIX = "expunge";
    @Autowired
    private IResourceExpungeService myExpungeDaoService;
    @Autowired
    private DaoConfig myDaoConfig;
    private final String myResourceName;
    private final ResourcePersistentId myResourceId;
    private final ExpungeOptions myExpungeOptions;
    private final RequestDetails myRequestDetails;
    private final AtomicInteger myRemainingCount;

    public ExpungeOperation(String theResourceName, ResourcePersistentId theResourceId, ExpungeOptions theExpungeOptions, RequestDetails theRequestDetails) {
        this.myResourceName = theResourceName;
        this.myResourceId = theResourceId;
        this.myExpungeOptions = theExpungeOptions;
        this.myRequestDetails = theRequestDetails;
        this.myRemainingCount = new AtomicInteger(this.myExpungeOptions.getLimit());
    }

    @Override
    public ExpungeOutcome call() {
        if (this.myExpungeOptions.isExpungeDeletedResources() && (this.myResourceId == null || this.myResourceId.getVersion() == null)) {
            this.expungeDeletedResources();
            if (this.expungeLimitReached()) {
                return this.expungeOutcome();
            }
        }
        if (this.myExpungeOptions.isExpungeOldVersions()) {
            this.expungeOldVersions();
            if (this.expungeLimitReached()) {
                return this.expungeOutcome();
            }
        }
        return this.expungeOutcome();
    }

    private void expungeDeletedResources() {
        List<ResourcePersistentId> resourceIds = this.findHistoricalVersionsOfDeletedResources();
        this.deleteHistoricalVersions(resourceIds);
        if (this.expungeLimitReached()) {
            return;
        }
        this.deleteCurrentVersionsOfDeletedResources(resourceIds);
    }

    private List<ResourcePersistentId> findHistoricalVersionsOfDeletedResources() {
        List<ResourcePersistentId> retVal = this.myExpungeDaoService.findHistoricalVersionsOfDeletedResources(this.myResourceName, this.myResourceId, this.myRemainingCount.get());
        ourLog.debug("Found {} historical versions", (Object)retVal.size());
        return retVal;
    }

    private List<ResourcePersistentId> findHistoricalVersionsOfNonDeletedResources() {
        return this.myExpungeDaoService.findHistoricalVersionsOfNonDeletedResources(this.myResourceName, this.myResourceId, this.myRemainingCount.get());
    }

    private boolean expungeLimitReached() {
        boolean expungeLimitReached;
        boolean bl = expungeLimitReached = this.myRemainingCount.get() <= 0;
        if (expungeLimitReached) {
            ourLog.debug("Expunge limit has been hit - Stopping operation");
        }
        return expungeLimitReached;
    }

    private void expungeOldVersions() {
        List<ResourcePersistentId> historicalIds = this.findHistoricalVersionsOfNonDeletedResources();
        this.getPartitionRunner().runInPartitionedThreads(historicalIds, partition -> this.myExpungeDaoService.expungeHistoricalVersions(this.myRequestDetails, (List<ResourcePersistentId>)partition, this.myRemainingCount));
    }

    private PartitionRunner getPartitionRunner() {
        return new PartitionRunner(PROCESS_NAME, THREAD_PREFIX, this.myDaoConfig.getExpungeBatchSize(), this.myDaoConfig.getExpungeThreadCount());
    }

    private void deleteCurrentVersionsOfDeletedResources(List<ResourcePersistentId> theResourceIds) {
        this.getPartitionRunner().runInPartitionedThreads(theResourceIds, partition -> this.myExpungeDaoService.expungeCurrentVersionOfResources(this.myRequestDetails, (List<ResourcePersistentId>)partition, this.myRemainingCount));
    }

    private void deleteHistoricalVersions(List<ResourcePersistentId> theResourceIds) {
        this.getPartitionRunner().runInPartitionedThreads(theResourceIds, partition -> this.myExpungeDaoService.expungeHistoricalVersionsOfIds(this.myRequestDetails, (List<ResourcePersistentId>)partition, this.myRemainingCount));
    }

    private ExpungeOutcome expungeOutcome() {
        return new ExpungeOutcome().setDeletedCount(this.myExpungeOptions.getLimit() - this.myRemainingCount.get());
    }
}

