/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.dao;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.RuntimeResourceDefinition;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.interceptor.api.HookParams;
import ca.uhn.fhir.interceptor.api.IInterceptorBroadcaster;
import ca.uhn.fhir.interceptor.api.Pointcut;
import ca.uhn.fhir.jpa.api.config.DaoConfig;
import ca.uhn.fhir.jpa.api.dao.DaoRegistry;
import ca.uhn.fhir.jpa.api.dao.IFhirResourceDao;
import ca.uhn.fhir.jpa.model.search.StorageProcessingMessage;
import ca.uhn.fhir.jpa.searchparam.MatchUrlService;
import ca.uhn.fhir.jpa.searchparam.SearchParameterMap;
import ca.uhn.fhir.jpa.util.MemoryCacheService;
import ca.uhn.fhir.rest.api.server.IPreResourceShowDetails;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.api.server.SimplePreResourceShowDetails;
import ca.uhn.fhir.rest.api.server.storage.ResourcePersistentId;
import ca.uhn.fhir.rest.api.server.storage.TransactionDetails;
import ca.uhn.fhir.rest.server.exceptions.ForbiddenOperationException;
import ca.uhn.fhir.rest.server.exceptions.InternalErrorException;
import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;
import ca.uhn.fhir.rest.server.servlet.ServletRequestDetails;
import ca.uhn.fhir.rest.server.util.CompositeInterceptorBroadcaster;
import ca.uhn.fhir.util.StopWatch;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.commons.lang3.Validate;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MatchResourceUrlService {
    private static final Logger ourLog = LoggerFactory.getLogger(MatchResourceUrlService.class);
    @Autowired
    private DaoRegistry myDaoRegistry;
    @Autowired
    private FhirContext myContext;
    @Autowired
    private MatchUrlService myMatchUrlService;
    @Autowired
    private DaoConfig myDaoConfig;
    @Autowired
    private IInterceptorBroadcaster myInterceptorBroadcaster;
    @Autowired
    private MemoryCacheService myMemoryCacheService;

    public <R extends IBaseResource> Set<ResourcePersistentId> processMatchUrl(String theMatchUrl, Class<R> theResourceType, TransactionDetails theTransactionDetails, RequestDetails theRequest) {
        return this.processMatchUrl(theMatchUrl, theResourceType, theTransactionDetails, theRequest, null);
    }

    public <R extends IBaseResource> Set<ResourcePersistentId> processMatchUrl(String theMatchUrl, Class<R> theResourceType, TransactionDetails theTransactionDetails, RequestDetails theRequest, IBaseResource theConditionalOperationTargetOrNull) {
        Set<Object> retVal = null;
        String resourceType = this.myContext.getResourceType(theResourceType);
        String matchUrl = this.massageForStorage(resourceType, theMatchUrl);
        ResourcePersistentId resolvedInTransaction = (ResourcePersistentId)theTransactionDetails.getResolvedMatchUrls().get(matchUrl);
        if (resolvedInTransaction != null) {
            if (resolvedInTransaction == TransactionDetails.NOT_FOUND) {
                return Collections.emptySet();
            }
            return Collections.singleton(resolvedInTransaction);
        }
        ResourcePersistentId resolvedInCache = this.processMatchUrlUsingCacheOnly(resourceType, matchUrl);
        if (resolvedInCache != null) {
            retVal = Collections.singleton(resolvedInCache);
        }
        if (retVal == null) {
            RuntimeResourceDefinition resourceDef = this.myContext.getResourceDefinition(theResourceType);
            SearchParameterMap paramMap = this.myMatchUrlService.translateMatchUrl(matchUrl, resourceDef, new MatchUrlService.Flag[0]);
            if (paramMap.isEmpty() && paramMap.getLastUpdated() == null) {
                throw new InvalidRequestException(Msg.code((int)518) + "Invalid match URL[" + matchUrl + "] - URL has no search parameters");
            }
            paramMap.setLoadSynchronousUpTo(Integer.valueOf(2));
            retVal = this.search(paramMap, theResourceType, theRequest, theConditionalOperationTargetOrNull);
        }
        if (CompositeInterceptorBroadcaster.hasHooks((Pointcut)Pointcut.STORAGE_PRESHOW_RESOURCES, (IInterceptorBroadcaster)this.myInterceptorBroadcaster, (RequestDetails)theRequest)) {
            HashMap<R, ResourcePersistentId> resourceToPidMap = new HashMap<R, ResourcePersistentId>();
            IFhirResourceDao<R> dao = this.getResourceDao(theResourceType);
            for (ResourcePersistentId pid : retVal) {
                resourceToPidMap.put(dao.readByPid(pid), pid);
            }
            SimplePreResourceShowDetails accessDetails = new SimplePreResourceShowDetails(resourceToPidMap.keySet());
            HookParams params = new HookParams().add(IPreResourceShowDetails.class, (Object)accessDetails).add(RequestDetails.class, (Object)theRequest).addIfMatchesType(ServletRequestDetails.class, (Object)theRequest);
            try {
                CompositeInterceptorBroadcaster.doCallHooks((IInterceptorBroadcaster)this.myInterceptorBroadcaster, (RequestDetails)theRequest, (Pointcut)Pointcut.STORAGE_PRESHOW_RESOURCES, (HookParams)params);
                retVal = accessDetails.toList().stream().map(resourceToPidMap::get).filter(Objects::nonNull).collect(Collectors.toSet());
            }
            catch (ForbiddenOperationException e) {
                ourLog.warn("Inline match URL [" + matchUrl + "] specified a resource the user is not authorized to access.", (Throwable)e);
                retVal = new HashSet<ResourcePersistentId>();
            }
        }
        if (retVal.size() == 1) {
            ResourcePersistentId pid = retVal.iterator().next();
            theTransactionDetails.addResolvedMatchUrl(matchUrl, pid);
            if (this.myDaoConfig.isMatchUrlCacheEnabled()) {
                this.myMemoryCacheService.putAfterCommit(MemoryCacheService.CacheEnum.MATCH_URL, matchUrl, pid);
            }
        }
        return retVal;
    }

    private <R extends IBaseResource> IFhirResourceDao<R> getResourceDao(Class<R> theResourceType) {
        IFhirResourceDao<R> dao = this.myDaoRegistry.getResourceDao(theResourceType);
        if (dao == null) {
            throw new InternalErrorException(Msg.code((int)519) + "No DAO for resource type: " + theResourceType.getName());
        }
        return dao;
    }

    private String massageForStorage(String theResourceType, String theMatchUrl) {
        Validate.notBlank((CharSequence)theMatchUrl, (String)"theMatchUrl must not be null or blank", (Object[])new Object[0]);
        int questionMarkIdx = theMatchUrl.indexOf("?");
        if (questionMarkIdx > 0) {
            return theMatchUrl;
        }
        if (questionMarkIdx == 0) {
            return theResourceType + theMatchUrl;
        }
        return theResourceType + "?" + theMatchUrl;
    }

    @Nullable
    public ResourcePersistentId processMatchUrlUsingCacheOnly(String theResourceType, String theMatchUrl) {
        ResourcePersistentId existing = null;
        if (this.myDaoConfig.isMatchUrlCacheEnabled()) {
            String matchUrl = this.massageForStorage(theResourceType, theMatchUrl);
            existing = (ResourcePersistentId)this.myMemoryCacheService.getIfPresent(MemoryCacheService.CacheEnum.MATCH_URL, matchUrl);
        }
        return existing;
    }

    public <R extends IBaseResource> Set<ResourcePersistentId> search(SearchParameterMap theParamMap, Class<R> theResourceType, RequestDetails theRequest, @Nullable IBaseResource theConditionalOperationTargetOrNull) {
        StopWatch sw = new StopWatch();
        IFhirResourceDao<R> dao = this.getResourceDao(theResourceType);
        List<ResourcePersistentId> retVal = dao.searchForIds(theParamMap, theRequest, theConditionalOperationTargetOrNull);
        if (CompositeInterceptorBroadcaster.hasHooks((Pointcut)Pointcut.JPA_PERFTRACE_INFO, (IInterceptorBroadcaster)this.myInterceptorBroadcaster, (RequestDetails)theRequest)) {
            StorageProcessingMessage message = new StorageProcessingMessage();
            message.setMessage("Processed conditional resource URL with " + retVal.size() + " result(s) in " + sw);
            HookParams params = new HookParams().add(RequestDetails.class, (Object)theRequest).addIfMatchesType(ServletRequestDetails.class, (Object)theRequest).add(StorageProcessingMessage.class, (Object)message);
            CompositeInterceptorBroadcaster.doCallHooks((IInterceptorBroadcaster)this.myInterceptorBroadcaster, (RequestDetails)theRequest, (Pointcut)Pointcut.JPA_PERFTRACE_INFO, (HookParams)params);
        }
        return new HashSet<ResourcePersistentId>(retVal);
    }

    public void matchUrlResolved(TransactionDetails theTransactionDetails, String theResourceType, String theMatchUrl, ResourcePersistentId theResourcePersistentId) {
        Validate.notBlank((CharSequence)theMatchUrl);
        Validate.notNull((Object)theResourcePersistentId);
        String matchUrl = this.massageForStorage(theResourceType, theMatchUrl);
        theTransactionDetails.addResolvedMatchUrl(matchUrl, theResourcePersistentId);
        if (this.myDaoConfig.isMatchUrlCacheEnabled()) {
            this.myMemoryCacheService.putAfterCommit(MemoryCacheService.CacheEnum.MATCH_URL, matchUrl, theResourcePersistentId);
        }
    }
}

