/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.dao;

import ca.uhn.fhir.jpa.dao.IdSubstitutionMap;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IIdType;

public class EntriesToProcessMap {
    private final IdentityHashMap<IBase, IIdType> myEntriesToProcess = new IdentityHashMap();
    private final Map<String, IIdType> myVersionlessIdToVersionedId = new HashMap<String, IIdType>();

    public void put(IBase theBundleEntry, IIdType theId) {
        this.myEntriesToProcess.put(theBundleEntry, theId);
        this.myVersionlessIdToVersionedId.put(IdSubstitutionMap.toVersionlessValue(theId), theId);
    }

    public IIdType getIdWithVersionlessComparison(IIdType theId) {
        return this.myVersionlessIdToVersionedId.get(IdSubstitutionMap.toVersionlessValue(theId));
    }

    public Set<Map.Entry<IBase, IIdType>> entrySet() {
        return this.myEntriesToProcess.entrySet();
    }
}

