/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.bulk.export.svc;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.RuntimeResourceDefinition;
import ca.uhn.fhir.jpa.bulk.export.model.ExportPIDIteratorParameters;
import ca.uhn.fhir.jpa.searchparam.MatchUrlService;
import ca.uhn.fhir.jpa.searchparam.SearchParameterMap;
import ca.uhn.fhir.rest.param.DateRangeParam;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.hl7.fhir.instance.model.api.IIdType;
import org.springframework.beans.factory.annotation.Autowired;

public class BulkExportHelperService {
    @Autowired
    private MatchUrlService myMatchUrlService;
    @Autowired
    private FhirContext myContext;

    public List<SearchParameterMap> createSearchParameterMapsForResourceType(RuntimeResourceDefinition theDef, ExportPIDIteratorParameters theParams) {
        String resourceType = theDef.getName();
        String[] typeFilters = theParams.getFilters().toArray(new String[0]);
        List<SearchParameterMap> spMaps = null;
        spMaps = Arrays.stream(typeFilters).filter(typeFilter -> typeFilter.startsWith(resourceType + "?")).map(filter -> this.buildSearchParameterMapForTypeFilter((String)filter, theDef, theParams.getStartDate())).collect(Collectors.toList());
        if (spMaps.isEmpty()) {
            SearchParameterMap defaultMap = new SearchParameterMap();
            this.enhanceSearchParameterMapWithCommonParameters(defaultMap, theParams.getStartDate());
            spMaps = Collections.singletonList(defaultMap);
        }
        return spMaps;
    }

    private SearchParameterMap buildSearchParameterMapForTypeFilter(String theFilter, RuntimeResourceDefinition theDef, Date theSinceDate) {
        SearchParameterMap searchParameterMap = this.myMatchUrlService.translateMatchUrl(theFilter, theDef, new MatchUrlService.Flag[0]);
        this.enhanceSearchParameterMapWithCommonParameters(searchParameterMap, theSinceDate);
        return searchParameterMap;
    }

    private void enhanceSearchParameterMapWithCommonParameters(SearchParameterMap map, Date theSinceDate) {
        map.setLoadSynchronous(true);
        if (theSinceDate != null) {
            map.setLastUpdated(new DateRangeParam(theSinceDate, null));
        }
    }

    public IIdType toId(String theResourceId) {
        IIdType retVal = this.myContext.getVersion().newIdType();
        retVal.setValue(theResourceId);
        return retVal;
    }
}

