/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.bulk.export.provider;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.RuntimeResourceDefinition;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.interceptor.api.HookParams;
import ca.uhn.fhir.interceptor.api.IInterceptorBroadcaster;
import ca.uhn.fhir.interceptor.api.Pointcut;
import ca.uhn.fhir.jpa.api.model.Batch2JobInfo;
import ca.uhn.fhir.jpa.api.model.BulkExportJobResults;
import ca.uhn.fhir.jpa.api.model.BulkExportParameters;
import ca.uhn.fhir.jpa.api.svc.IBatch2JobRunner;
import ca.uhn.fhir.jpa.batch.config.BatchConstants;
import ca.uhn.fhir.jpa.batch.models.Batch2JobStartResponse;
import ca.uhn.fhir.jpa.bulk.export.model.BulkExportJobStatusEnum;
import ca.uhn.fhir.jpa.bulk.export.model.BulkExportResponseJson;
import ca.uhn.fhir.jpa.bulk.export.provider.JobInfo;
import ca.uhn.fhir.jpa.util.BulkExportUtils;
import ca.uhn.fhir.rest.annotation.IdParam;
import ca.uhn.fhir.rest.annotation.Operation;
import ca.uhn.fhir.rest.annotation.OperationParam;
import ca.uhn.fhir.rest.api.CacheControlDirective;
import ca.uhn.fhir.rest.api.PreferHeader;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.api.server.bulk.BulkDataExportOptions;
import ca.uhn.fhir.rest.server.RestfulServerUtils;
import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;
import ca.uhn.fhir.rest.server.servlet.ServletRequestDetails;
import ca.uhn.fhir.rest.server.util.CompositeInterceptorBroadcaster;
import ca.uhn.fhir.util.ArrayUtil;
import ca.uhn.fhir.util.JsonUtil;
import ca.uhn.fhir.util.OperationOutcomeUtil;
import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.instance.model.api.IBaseOperationOutcome;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.instance.model.api.IPrimitiveType;
import org.hl7.fhir.r4.model.IdType;
import org.hl7.fhir.r4.model.InstantType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class BulkDataExportProvider {
    public static final String FARM_TO_TABLE_TYPE_FILTER_REGEX = "(?:,)(?=[A-Z][a-z]+\\?)";
    private static final Logger ourLog = LoggerFactory.getLogger(BulkDataExportProvider.class);
    @Autowired
    private IInterceptorBroadcaster myInterceptorBroadcaster;
    private Set<String> myCompartmentResources;
    @Autowired
    private FhirContext myFhirContext;
    @Autowired
    private IBatch2JobRunner myJobRunner;

    @Operation(name="$export", global=false, manualResponse=true, idempotent=true)
    public void export(@OperationParam(name="_outputFormat", min=0, max=1, typeName="string") IPrimitiveType<String> theOutputFormat, @OperationParam(name="_type", min=0, max=1, typeName="string") IPrimitiveType<String> theType, @OperationParam(name="_since", min=0, max=1, typeName="instant") IPrimitiveType<Date> theSince, @OperationParam(name="_typeFilter", min=0, max=-1, typeName="string") List<IPrimitiveType<String>> theTypeFilter, ServletRequestDetails theRequestDetails) {
        BulkDataExportProvider.validatePreferAsyncHeader(theRequestDetails, "$export");
        BulkDataExportOptions bulkDataExportOptions = this.buildSystemBulkExportOptions(theOutputFormat, theType, theSince, theTypeFilter);
        this.startJob(theRequestDetails, bulkDataExportOptions);
    }

    private void startJob(ServletRequestDetails theRequestDetails, BulkDataExportOptions theOptions) {
        HookParams params = new HookParams().add(BulkDataExportOptions.class, (Object)theOptions).add(RequestDetails.class, (Object)theRequestDetails).addIfMatchesType(ServletRequestDetails.class, (Object)theRequestDetails);
        CompositeInterceptorBroadcaster.doCallHooks((IInterceptorBroadcaster)this.myInterceptorBroadcaster, (RequestDetails)theRequestDetails, (Pointcut)Pointcut.STORAGE_INITIATE_BULK_EXPORT, (HookParams)params);
        boolean useCache = this.shouldUseCache(theRequestDetails);
        BulkExportParameters parameters = BulkExportUtils.createBulkExportJobParametersFromExportOptions(theOptions);
        parameters.setUseExistingJobsFirst(useCache);
        Batch2JobStartResponse response = this.myJobRunner.startNewJob(parameters);
        JobInfo info = new JobInfo();
        info.setJobMetadataId(response.getJobId());
        info.setStatus(BulkExportJobStatusEnum.SUBMITTED);
        this.writePollingLocationToResponseHeaders(theRequestDetails, info);
    }

    private boolean shouldUseCache(ServletRequestDetails theRequestDetails) {
        CacheControlDirective cacheControlDirective = new CacheControlDirective().parse(theRequestDetails.getHeaders("Cache-Control"));
        return !cacheControlDirective.isNoCache();
    }

    private String getServerBase(ServletRequestDetails theRequestDetails) {
        return StringUtils.removeEnd((String)theRequestDetails.getServerBaseForRequest(), (String)"/");
    }

    private String getDefaultPartitionServerBase(ServletRequestDetails theRequestDetails) {
        if (theRequestDetails.getTenantId() == null || theRequestDetails.getTenantId().equals("DEFAULT")) {
            return this.getServerBase(theRequestDetails);
        }
        return StringUtils.removeEnd((String)theRequestDetails.getServerBaseForRequest().replace(theRequestDetails.getTenantId(), "DEFAULT"), (String)"/");
    }

    @Operation(name="$export", manualResponse=true, idempotent=true, typeName="Group")
    public void groupExport(@IdParam IIdType theIdParam, @OperationParam(name="_outputFormat", min=0, max=1, typeName="string") IPrimitiveType<String> theOutputFormat, @OperationParam(name="_type", min=0, max=1, typeName="string") IPrimitiveType<String> theType, @OperationParam(name="_since", min=0, max=1, typeName="instant") IPrimitiveType<Date> theSince, @OperationParam(name="_typeFilter", min=0, max=-1, typeName="string") List<IPrimitiveType<String>> theTypeFilter, @OperationParam(name="_mdm", min=0, max=1, typeName="boolean") IPrimitiveType<Boolean> theMdm, ServletRequestDetails theRequestDetails) {
        ourLog.debug("Received Group Bulk Export Request for Group {}", (Object)theIdParam);
        ourLog.debug("_type={}", (Object)theIdParam);
        ourLog.debug("_since={}", theSince);
        ourLog.debug("_typeFilter={}", theTypeFilter);
        ourLog.debug("_mdm=", theMdm);
        BulkDataExportProvider.validatePreferAsyncHeader(theRequestDetails, "$export");
        BulkDataExportOptions bulkDataExportOptions = this.buildGroupBulkExportOptions(theOutputFormat, theType, theSince, theTypeFilter, theIdParam, theMdm);
        if (bulkDataExportOptions.getResourceTypes() != null && !bulkDataExportOptions.getResourceTypes().isEmpty()) {
            this.validateResourceTypesAllContainPatientSearchParams(bulkDataExportOptions.getResourceTypes());
        } else {
            bulkDataExportOptions.setResourceTypes(this.getPatientCompartmentResources());
        }
        this.startJob(theRequestDetails, bulkDataExportOptions);
    }

    private void validateResourceTypesAllContainPatientSearchParams(Set<String> theResourceTypes) {
        List badResourceTypes;
        if (theResourceTypes != null && !(badResourceTypes = theResourceTypes.stream().filter(resourceType -> !BatchConstants.PATIENT_BULK_EXPORT_FORWARD_REFERENCE_RESOURCE_TYPES.contains(resourceType)).filter(resourceType -> !this.getPatientCompartmentResources().contains(resourceType)).collect(Collectors.toList())).isEmpty()) {
            throw new InvalidRequestException(Msg.code((int)512) + String.format("Resource types [%s] are invalid for this type of export, as they do not contain search parameters that refer to patients.", String.join((CharSequence)",", badResourceTypes)));
        }
    }

    private Set<String> getPatientCompartmentResources() {
        if (this.myCompartmentResources == null) {
            this.myCompartmentResources = this.myFhirContext.getResourceTypes().stream().filter(this::resourceTypeIsInPatientCompartment).collect(Collectors.toSet());
        }
        return this.myCompartmentResources;
    }

    private boolean resourceTypeIsInPatientCompartment(String theResourceType) {
        RuntimeResourceDefinition runtimeResourceDefinition = this.myFhirContext.getResourceDefinition(theResourceType);
        List searchParams = runtimeResourceDefinition.getSearchParamsForCompartmentName("Patient");
        return searchParams != null && searchParams.size() >= 1;
    }

    @Operation(name="$export", manualResponse=true, idempotent=true, typeName="Patient")
    public void patientExport(@OperationParam(name="_outputFormat", min=0, max=1, typeName="string") IPrimitiveType<String> theOutputFormat, @OperationParam(name="_type", min=0, max=1, typeName="string") IPrimitiveType<String> theType, @OperationParam(name="_since", min=0, max=1, typeName="instant") IPrimitiveType<Date> theSince, @OperationParam(name="_typeFilter", min=0, max=-1, typeName="string") List<IPrimitiveType<String>> theTypeFilter, ServletRequestDetails theRequestDetails) {
        BulkDataExportProvider.validatePreferAsyncHeader(theRequestDetails, "$export");
        BulkDataExportOptions bulkDataExportOptions = this.buildPatientBulkExportOptions(theOutputFormat, theType, theSince, theTypeFilter);
        this.validateResourceTypesAllContainPatientSearchParams(bulkDataExportOptions.getResourceTypes());
        this.startJob(theRequestDetails, bulkDataExportOptions);
    }

    @Operation(name="$export-poll-status", manualResponse=true, idempotent=true)
    public void exportPollStatus(@OperationParam(name="_jobId", typeName="string", min=0, max=1) IPrimitiveType<String> theJobId, ServletRequestDetails theRequestDetails) throws IOException {
        HttpServletResponse response = theRequestDetails.getServletResponse();
        theRequestDetails.getServer().addHeadersToResponse(response);
        Batch2JobInfo info = this.myJobRunner.getJobInfo(theJobId.getValueAsString());
        switch (info.getStatus()) {
            case COMPLETE: {
                response.setStatus(200);
                response.setContentType("application/json");
                BulkExportResponseJson bulkResponseDocument = new BulkExportResponseJson();
                bulkResponseDocument.setTransactionTime(info.getEndTime());
                String report = info.getReport();
                if (StringUtils.isEmpty((CharSequence)report)) {
                    ourLog.error("No report for completed bulk export job.");
                    response.getWriter().close();
                    break;
                }
                BulkExportJobResults results = (BulkExportJobResults)JsonUtil.deserialize((String)report, BulkExportJobResults.class);
                bulkResponseDocument.setMsg(results.getReportMsg());
                String serverBase = this.getDefaultPartitionServerBase(theRequestDetails);
                for (Map.Entry<String, List<String>> entrySet : results.getResourceTypeToBinaryIds().entrySet()) {
                    String resourceType = entrySet.getKey();
                    List<String> binaryIds = entrySet.getValue();
                    for (String binaryId : binaryIds) {
                        IdType iId = new IdType(binaryId);
                        String nextUrl = serverBase + "/" + iId.toUnqualifiedVersionless().getValue();
                        bulkResponseDocument.addOutput().setType(resourceType).setUrl(nextUrl);
                    }
                }
                JsonUtil.serialize((Object)bulkResponseDocument, (Writer)response.getWriter());
                response.getWriter().close();
                break;
            }
            case ERROR: {
                response.setStatus(500);
                response.setContentType("application/json+fhir");
                IBaseOperationOutcome oo = OperationOutcomeUtil.newInstance((FhirContext)this.myFhirContext);
                OperationOutcomeUtil.addIssue((FhirContext)this.myFhirContext, (IBaseOperationOutcome)oo, (String)"error", (String)info.getErrorMsg(), null, null);
                this.myFhirContext.newJsonParser().setPrettyPrint(true).encodeResourceToWriter((IBaseResource)oo, (Writer)response.getWriter());
                response.getWriter().close();
                break;
            }
            default: {
                response.setStatus(202);
                String dateString = this.getTransitionTimeOfJobInfo(info);
                response.addHeader("X-Progress", "Build in progress - Status set to " + info.getStatus() + " at " + dateString);
                response.addHeader("Retry-After", "120");
            }
        }
    }

    private String getTransitionTimeOfJobInfo(Batch2JobInfo theInfo) {
        if (theInfo.getEndTime() != null) {
            return new InstantType(theInfo.getEndTime()).getValueAsString();
        }
        if (theInfo.getStartTime() != null) {
            return new InstantType(theInfo.getStartTime()).getValueAsString();
        }
        return "";
    }

    private BulkDataExportOptions buildSystemBulkExportOptions(IPrimitiveType<String> theOutputFormat, IPrimitiveType<String> theType, IPrimitiveType<Date> theSince, List<IPrimitiveType<String>> theTypeFilter) {
        return this.buildBulkDataExportOptions(theOutputFormat, theType, theSince, theTypeFilter, BulkDataExportOptions.ExportStyle.SYSTEM);
    }

    private BulkDataExportOptions buildGroupBulkExportOptions(IPrimitiveType<String> theOutputFormat, IPrimitiveType<String> theType, IPrimitiveType<Date> theSince, List<IPrimitiveType<String>> theTypeFilter, IIdType theGroupId, IPrimitiveType<Boolean> theExpandMdm) {
        BulkDataExportOptions bulkDataExportOptions = this.buildBulkDataExportOptions(theOutputFormat, theType, theSince, theTypeFilter, BulkDataExportOptions.ExportStyle.GROUP);
        bulkDataExportOptions.setGroupId(theGroupId);
        boolean mdm = false;
        if (theExpandMdm != null) {
            mdm = (Boolean)theExpandMdm.getValue();
        }
        bulkDataExportOptions.setExpandMdm(mdm);
        return bulkDataExportOptions;
    }

    private BulkDataExportOptions buildPatientBulkExportOptions(IPrimitiveType<String> theOutputFormat, IPrimitiveType<String> theType, IPrimitiveType<Date> theSince, List<IPrimitiveType<String>> theTypeFilter) {
        return this.buildBulkDataExportOptions(theOutputFormat, theType, theSince, theTypeFilter, BulkDataExportOptions.ExportStyle.PATIENT);
    }

    private BulkDataExportOptions buildBulkDataExportOptions(IPrimitiveType<String> theOutputFormat, IPrimitiveType<String> theType, IPrimitiveType<Date> theSince, List<IPrimitiveType<String>> theTypeFilter, BulkDataExportOptions.ExportStyle theExportStyle) {
        String outputFormat = theOutputFormat != null ? theOutputFormat.getValueAsString() : null;
        Set resourceTypes = null;
        if (theType != null) {
            resourceTypes = ArrayUtil.commaSeparatedListToCleanSet((String)theType.getValueAsString());
        }
        Date since = null;
        if (theSince != null) {
            since = (Date)theSince.getValue();
        }
        Set<String> typeFilters = this.splitTypeFilters(theTypeFilter);
        BulkDataExportOptions bulkDataExportOptions = new BulkDataExportOptions();
        bulkDataExportOptions.setFilters(typeFilters);
        bulkDataExportOptions.setExportStyle(theExportStyle);
        bulkDataExportOptions.setSince(since);
        bulkDataExportOptions.setResourceTypes(resourceTypes);
        bulkDataExportOptions.setOutputFormat(outputFormat);
        return bulkDataExportOptions;
    }

    public void writePollingLocationToResponseHeaders(ServletRequestDetails theRequestDetails, JobInfo theOutcome) {
        String serverBase = this.getServerBase(theRequestDetails);
        String pollLocation = serverBase + "/$export-poll-status?_jobId=" + theOutcome.getJobMetadataId();
        HttpServletResponse response = theRequestDetails.getServletResponse();
        theRequestDetails.getServer().addHeadersToResponse(response);
        response.addHeader("Content-Location", pollLocation);
        response.setStatus(202);
    }

    public static void validatePreferAsyncHeader(ServletRequestDetails theRequestDetails, String theOperationName) {
        String preferHeader = theRequestDetails.getHeader("Prefer");
        PreferHeader prefer = RestfulServerUtils.parsePreferHeader(null, (String)preferHeader);
        if (!prefer.getRespondAsync()) {
            throw new InvalidRequestException(Msg.code((int)513) + "Must request async processing for " + theOperationName);
        }
    }

    private Set<String> splitTypeFilters(List<IPrimitiveType<String>> theTypeFilter) {
        if (theTypeFilter == null) {
            return null;
        }
        HashSet<String> retVal = new HashSet<String>();
        for (IPrimitiveType<String> next : theTypeFilter) {
            String typeFilterString = next.getValueAsString();
            Arrays.stream(typeFilterString.split(FARM_TO_TABLE_TYPE_FILTER_REGEX)).filter(StringUtils::isNotBlank).forEach(t -> retVal.add((String)t));
        }
        return retVal;
    }
}

