/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.binary.svc;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.jpa.binary.api.IBinaryStorageSvc;
import ca.uhn.fhir.rest.server.exceptions.InternalErrorException;
import ca.uhn.fhir.rest.server.exceptions.PayloadTooLargeException;
import ca.uhn.fhir.util.BinaryUtil;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import com.google.common.hash.HashingInputStream;
import com.google.common.io.ByteStreams;
import java.io.IOException;
import java.io.InputStream;
import java.security.SecureRandom;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.apache.commons.io.input.CountingInputStream;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.hl7.fhir.instance.model.api.IBaseBinary;
import org.hl7.fhir.instance.model.api.IBaseHasExtensions;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.instance.model.api.IPrimitiveType;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class BaseBinaryStorageSvcImpl
implements IBinaryStorageSvc {
    private final SecureRandom myRandom;
    private final String CHARS = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";
    private final int ID_LENGTH = 100;
    private int myMaximumBinarySize = Integer.MAX_VALUE;
    private int myMinimumBinarySize;
    @Autowired
    private FhirContext myFhirContext;

    public BaseBinaryStorageSvcImpl() {
        this.myRandom = new SecureRandom();
    }

    @Override
    public int getMaximumBinarySize() {
        return this.myMaximumBinarySize;
    }

    @Override
    public void setMaximumBinarySize(int theMaximumBinarySize) {
        Validate.inclusiveBetween((long)1L, (long)Integer.MAX_VALUE, (long)theMaximumBinarySize);
        this.myMaximumBinarySize = theMaximumBinarySize;
    }

    @Override
    public int getMinimumBinarySize() {
        return this.myMinimumBinarySize;
    }

    @Override
    public void setMinimumBinarySize(int theMinimumBinarySize) {
        this.myMinimumBinarySize = theMinimumBinarySize;
    }

    @Override
    public String newBlobId() {
        StringBuilder b = new StringBuilder();
        for (int i = 0; i < 100; ++i) {
            int nextInt = Math.abs(this.myRandom.nextInt());
            b.append("abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789".charAt(nextInt % "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789".length()));
        }
        return b.toString();
    }

    @Override
    public boolean shouldStoreBlob(long theSize, IIdType theResourceId, String theContentType) {
        return theSize >= (long)this.getMinimumBinarySize();
    }

    @Nonnull
    protected HashingInputStream createHashingInputStream(InputStream theInputStream) {
        HashFunction hash = Hashing.sha256();
        return new HashingInputStream(hash, theInputStream);
    }

    @Nonnull
    protected CountingInputStream createCountingInputStream(InputStream theInputStream) {
        InputStream is = ByteStreams.limit((InputStream)theInputStream, (long)((long)this.getMaximumBinarySize() + 1L));
        return new CountingInputStream(is){

            public int getCount() {
                int retVal = super.getCount();
                if (retVal > BaseBinaryStorageSvcImpl.this.getMaximumBinarySize()) {
                    throw new PayloadTooLargeException(Msg.code((int)1343) + "Binary size exceeds maximum: " + BaseBinaryStorageSvcImpl.this.getMaximumBinarySize());
                }
                return retVal;
            }
        };
    }

    protected String provideIdForNewBlob(String theBlobIdOrNull) {
        String id = theBlobIdOrNull;
        if (StringUtils.isBlank((CharSequence)theBlobIdOrNull)) {
            id = this.newBlobId();
        }
        return id;
    }

    @Override
    public byte[] fetchDataBlobFromBinary(IBaseBinary theBaseBinary) throws IOException {
        IPrimitiveType dataElement = BinaryUtil.getOrCreateData((FhirContext)this.myFhirContext, (IBaseBinary)theBaseBinary);
        byte[] value = (byte[])dataElement.getValue();
        if (value == null) {
            Optional<String> attachmentId = this.getAttachmentId((IBaseHasExtensions)dataElement);
            if (attachmentId.isPresent()) {
                value = this.fetchBlob(theBaseBinary.getIdElement(), attachmentId.get());
            } else {
                throw new InternalErrorException(Msg.code((int)1344) + "Unable to load binary blob data for " + theBaseBinary.getIdElement());
            }
        }
        return value;
    }

    private Optional<String> getAttachmentId(IBaseHasExtensions theBaseBinary) {
        return theBaseBinary.getExtension().stream().filter(t -> "http://hapifhir.io/fhir/StructureDefinition/externalized-binary-id".equals(t.getUrl())).filter(t -> t.getValue() instanceof IPrimitiveType).map(t -> (IPrimitiveType)t.getValue()).map(t -> (String)t.getValue()).filter(t -> StringUtils.isNotBlank((CharSequence)t)).findFirst();
    }
}

