/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.binary.interceptor;

import ca.uhn.fhir.context.BaseRuntimeChildDefinition;
import ca.uhn.fhir.context.BaseRuntimeElementDefinition;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.interceptor.api.Hook;
import ca.uhn.fhir.interceptor.api.Interceptor;
import ca.uhn.fhir.interceptor.api.Pointcut;
import ca.uhn.fhir.jpa.binary.api.IBinaryStorageSvc;
import ca.uhn.fhir.jpa.binary.api.IBinaryTarget;
import ca.uhn.fhir.jpa.binary.api.StoredDetails;
import ca.uhn.fhir.jpa.binary.provider.BinaryAccessProvider;
import ca.uhn.fhir.jpa.model.util.JpaConstants;
import ca.uhn.fhir.rest.api.server.IPreResourceShowDetails;
import ca.uhn.fhir.rest.api.server.storage.TransactionDetails;
import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;
import ca.uhn.fhir.util.IModelVisitor2;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseHasExtensions;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.instance.model.api.IPrimitiveType;
import org.hl7.fhir.r4.model.IdType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@Interceptor
public class BinaryStorageInterceptor {
    private static final Logger ourLog = LoggerFactory.getLogger(BinaryStorageInterceptor.class);
    @Autowired
    private IBinaryStorageSvc myBinaryStorageSvc;
    @Autowired
    private FhirContext myCtx;
    @Autowired
    private BinaryAccessProvider myBinaryAccessProvider;
    private Class<? extends IPrimitiveType<byte[]>> myBinaryType;
    private String myDeferredListKey;
    private long myAutoInflateBinariesMaximumBytes = 0xA00000L;
    private boolean myAllowAutoInflateBinaries = true;

    public long getAutoInflateBinariesMaximumSize() {
        return this.myAutoInflateBinariesMaximumBytes;
    }

    public void setAutoInflateBinariesMaximumSize(long theAutoInflateBinariesMaximumBytes) {
        this.myAutoInflateBinariesMaximumBytes = theAutoInflateBinariesMaximumBytes;
    }

    @PostConstruct
    public void start() {
        BaseRuntimeElementDefinition base64Binary = this.myCtx.getElementDefinition("base64Binary");
        assert (base64Binary != null);
        this.myBinaryType = base64Binary.getImplementingClass();
        this.myDeferredListKey = this.getClass().getName() + "_" + this.hashCode() + "_DEFERRED_LIST";
    }

    @Hook(value=Pointcut.STORAGE_PRESTORAGE_EXPUNGE_RESOURCE)
    public void expungeResource(AtomicInteger theCounter, IBaseResource theResource) {
        List binaryElements = this.myCtx.newTerser().getAllPopulatedChildElementsOfType(theResource, this.myBinaryType);
        List attachmentIds = binaryElements.stream().flatMap(t -> ((IBaseHasExtensions)t).getExtension().stream()).filter(t -> "http://hapifhir.io/fhir/StructureDefinition/externalized-binary-id".equals(t.getUrl())).map(t -> ((IPrimitiveType)t.getValue()).getValueAsString()).collect(Collectors.toList());
        for (String next : attachmentIds) {
            this.myBinaryStorageSvc.expungeBlob(theResource.getIdElement(), next);
            theCounter.incrementAndGet();
            ourLog.info("Deleting binary blob {} because resource {} is being expunged", (Object)next, (Object)theResource.getIdElement().getValue());
        }
    }

    @Hook(value=Pointcut.STORAGE_PRESTORAGE_RESOURCE_CREATED)
    public void extractLargeBinariesBeforeCreate(TransactionDetails theTransactionDetails, IBaseResource theResource, Pointcut thePointcut) throws IOException {
        this.extractLargeBinaries(theTransactionDetails, theResource, thePointcut);
    }

    @Hook(value=Pointcut.STORAGE_PRESTORAGE_RESOURCE_UPDATED)
    public void extractLargeBinariesBeforeUpdate(TransactionDetails theTransactionDetails, IBaseResource thePreviousResource, IBaseResource theResource, Pointcut thePointcut) throws IOException {
        this.blockIllegalExternalBinaryIds(thePreviousResource, theResource);
        this.extractLargeBinaries(theTransactionDetails, theResource, thePointcut);
    }

    private void blockIllegalExternalBinaryIds(IBaseResource thePreviousResource, IBaseResource theResource) {
        List base64fields;
        HashSet existingBinaryIds = new HashSet();
        if (thePreviousResource != null) {
            base64fields = this.myCtx.newTerser().getAllPopulatedChildElementsOfType(thePreviousResource, this.myBinaryType);
            for (IPrimitiveType nextBase64 : base64fields) {
                if (!(nextBase64 instanceof IBaseHasExtensions)) continue;
                ((IBaseHasExtensions)nextBase64).getExtension().stream().filter(t -> t.getUserData(JpaConstants.EXTENSION_EXT_SYSTEMDEFINED) == null).filter(t -> "http://hapifhir.io/fhir/StructureDefinition/externalized-binary-id".equals(t.getUrl())).map(t -> (IPrimitiveType)t.getValue()).map(t -> t.getValueAsString()).filter(t -> StringUtils.isNotBlank((CharSequence)t)).forEach(t -> existingBinaryIds.add(t));
            }
        }
        base64fields = this.myCtx.newTerser().getAllPopulatedChildElementsOfType(theResource, this.myBinaryType);
        for (IPrimitiveType nextBase64 : base64fields) {
            Optional<String> hasExternalizedBinaryReference;
            if (!(nextBase64 instanceof IBaseHasExtensions) || !(hasExternalizedBinaryReference = ((IBaseHasExtensions)nextBase64).getExtension().stream().filter(t -> t.getUserData(JpaConstants.EXTENSION_EXT_SYSTEMDEFINED) == null).filter(t -> t.getUrl().equals("http://hapifhir.io/fhir/StructureDefinition/externalized-binary-id")).map(t -> (IPrimitiveType)t.getValue()).map(t -> t.getValueAsString()).filter(t -> StringUtils.isNotBlank((CharSequence)t)).filter(t -> !existingBinaryIds.contains(t)).findFirst()).isPresent()) continue;
            String msg = this.myCtx.getLocalizer().getMessage(BinaryStorageInterceptor.class, "externalizedBinaryStorageExtensionFoundInRequestBody", new Object[]{"http://hapifhir.io/fhir/StructureDefinition/externalized-binary-id", hasExternalizedBinaryReference.get()});
            throw new InvalidRequestException(Msg.code((int)1329) + msg);
        }
    }

    private void extractLargeBinaries(TransactionDetails theTransactionDetails, IBaseResource theResource, Pointcut thePointcut) throws IOException {
        IIdType resourceId = theResource.getIdElement();
        if (!resourceId.hasResourceType() && resourceId.hasIdPart()) {
            String resourceType = this.myCtx.getResourceType(theResource);
            resourceId = new IdType(resourceType + "/" + resourceId.getIdPart());
        }
        List<IBinaryTarget> attachments = this.recursivelyScanResourceForBinaryData(theResource);
        for (IBinaryTarget nextTarget : attachments) {
            String newBlobId;
            String nextContentType;
            long nextPayloadLength;
            boolean shouldStoreBlob;
            byte[] data = nextTarget.getData();
            if (data == null || data.length <= 0 || !(shouldStoreBlob = this.myBinaryStorageSvc.shouldStoreBlob(nextPayloadLength = (long)data.length, resourceId, nextContentType = nextTarget.getContentType()))) continue;
            if (resourceId.hasIdPart()) {
                ByteArrayInputStream inputStream = new ByteArrayInputStream(data);
                StoredDetails storedDetails = this.myBinaryStorageSvc.storeBlob(resourceId, null, nextContentType, inputStream);
                newBlobId = storedDetails.getBlobId();
            } else {
                assert (thePointcut == Pointcut.STORAGE_PRESTORAGE_RESOURCE_CREATED) : thePointcut.name();
                newBlobId = this.myBinaryStorageSvc.newBlobId();
                List<DeferredBinaryTarget> deferredBinaryTargets = this.getOrCreateDeferredBinaryStorageMap(theTransactionDetails);
                DeferredBinaryTarget newDeferredBinaryTarget = new DeferredBinaryTarget(newBlobId, nextTarget, data);
                deferredBinaryTargets.add(newDeferredBinaryTarget);
            }
            this.myBinaryAccessProvider.replaceDataWithExtension(nextTarget, newBlobId);
        }
    }

    @Nonnull
    private List<DeferredBinaryTarget> getOrCreateDeferredBinaryStorageMap(TransactionDetails theTransactionDetails) {
        return (List)theTransactionDetails.getOrCreateUserData(this.getDeferredListKey(), () -> new ArrayList());
    }

    @Hook(value=Pointcut.STORAGE_PRECOMMIT_RESOURCE_CREATED)
    public void storeLargeBinariesBeforeCreatePersistence(TransactionDetails theTransactionDetails, IBaseResource theResource, Pointcut thePoincut) throws IOException {
        if (theTransactionDetails == null) {
            return;
        }
        List deferredBinaryTargets = (List)theTransactionDetails.getUserData(this.getDeferredListKey());
        if (deferredBinaryTargets != null) {
            IIdType resourceId = theResource.getIdElement();
            for (DeferredBinaryTarget next : deferredBinaryTargets) {
                String blobId = next.getBlobId();
                IBinaryTarget target = next.getBinaryTarget();
                InputStream dataStream = next.getDataStream();
                String contentType = target.getContentType();
                this.myBinaryStorageSvc.storeBlob(resourceId, blobId, contentType, dataStream);
            }
        }
    }

    private String getDeferredListKey() {
        return this.myDeferredListKey;
    }

    @Hook(value=Pointcut.STORAGE_PRESHOW_RESOURCES)
    public void preShow(IPreResourceShowDetails theDetails) throws IOException {
        if (!this.isAllowAutoInflateBinaries()) {
            return;
        }
        long unmarshalledByteCount = 0L;
        for (IBaseResource nextResource : theDetails) {
            IIdType resourceId = nextResource.getIdElement();
            List<IBinaryTarget> attachments = this.recursivelyScanResourceForBinaryData(nextResource);
            for (IBinaryTarget nextTarget : attachments) {
                Optional<String> attachmentId = nextTarget.getAttachmentId();
                if (!attachmentId.isPresent()) continue;
                StoredDetails blobDetails = this.myBinaryStorageSvc.fetchBlobDetails(resourceId, attachmentId.get());
                if (blobDetails == null) {
                    String msg = this.myCtx.getLocalizer().getMessage(BinaryAccessProvider.class, "unknownBlobId", new Object[0]);
                    throw new InvalidRequestException(Msg.code((int)1330) + msg);
                }
                if (unmarshalledByteCount + blobDetails.getBytes() >= this.myAutoInflateBinariesMaximumBytes) continue;
                byte[] bytes = this.myBinaryStorageSvc.fetchBlob(resourceId, attachmentId.get());
                nextTarget.setData(bytes);
                unmarshalledByteCount += blobDetails.getBytes();
            }
        }
    }

    @Nonnull
    private List<IBinaryTarget> recursivelyScanResourceForBinaryData(IBaseResource theResource) {
        final ArrayList<IBinaryTarget> binaryTargets = new ArrayList<IBinaryTarget>();
        this.myCtx.newTerser().visit((IBase)theResource, new IModelVisitor2(){

            public boolean acceptElement(IBase theElement, List<IBase> theContainingElementPath, List<BaseRuntimeChildDefinition> theChildDefinitionPath, List<BaseRuntimeElementDefinition<?>> theElementDefinitionPath) {
                if (theElement.getClass().equals(BinaryStorageInterceptor.this.myBinaryType)) {
                    IBase parent = theContainingElementPath.get(theContainingElementPath.size() - 2);
                    Optional<IBinaryTarget> binaryTarget = BinaryStorageInterceptor.this.myBinaryAccessProvider.toBinaryTarget(parent);
                    binaryTarget.ifPresent(binaryTargets::add);
                }
                return true;
            }
        });
        return binaryTargets;
    }

    public void setAllowAutoInflateBinaries(boolean theAllowAutoInflateBinaries) {
        this.myAllowAutoInflateBinaries = theAllowAutoInflateBinaries;
    }

    public boolean isAllowAutoInflateBinaries() {
        return this.myAllowAutoInflateBinaries;
    }

    private static class DeferredBinaryTarget {
        private final String myBlobId;
        private final IBinaryTarget myBinaryTarget;
        private final InputStream myDataStream;

        private DeferredBinaryTarget(String theBlobId, IBinaryTarget theBinaryTarget, byte[] theData) {
            this.myBlobId = theBlobId;
            this.myBinaryTarget = theBinaryTarget;
            this.myDataStream = new ByteArrayInputStream(theData);
        }

        String getBlobId() {
            return this.myBlobId;
        }

        IBinaryTarget getBinaryTarget() {
            return this.myBinaryTarget;
        }

        InputStream getDataStream() {
            return this.myDataStream;
        }
    }
}

