/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.api.pid;

import ca.uhn.fhir.jpa.api.pid.IResourcePidList;
import ca.uhn.fhir.jpa.api.pid.TypedResourcePid;
import ca.uhn.fhir.rest.api.server.storage.ResourcePersistentId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class BaseResourcePidList
implements IResourcePidList {
    final List<ResourcePersistentId> myIds = new ArrayList<ResourcePersistentId>();
    @Nullable
    final Date myLastDate;

    BaseResourcePidList(Collection<ResourcePersistentId> theIds, Date theLastDate) {
        this.myIds.addAll(theIds);
        this.myLastDate = theLastDate;
    }

    @Override
    public Date getLastDate() {
        return this.myLastDate;
    }

    @Override
    public int size() {
        return this.myIds.size();
    }

    @Override
    @Nonnull
    public List<TypedResourcePid> getTypedResourcePids() {
        ArrayList<TypedResourcePid> retval = new ArrayList<TypedResourcePid>();
        for (int i = 0; i < this.myIds.size(); ++i) {
            retval.add(new TypedResourcePid(this.getResourceType(i), this.myIds.get(i)));
        }
        return Collections.unmodifiableList(retval);
    }

    @Override
    public boolean isEmpty() {
        return this.myIds.isEmpty();
    }

    @Override
    public List<ResourcePersistentId> getIds() {
        return Collections.unmodifiableList(this.myIds);
    }

    public ResourcePersistentId getId(int theIndex) {
        return this.myIds.get(theIndex);
    }
}

