/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.api.model;

import ca.uhn.fhir.context.support.IValidationSupport;
import ca.uhn.fhir.jpa.api.model.TranslationQuery;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.Validate;
import org.hl7.fhir.instance.model.api.IBaseCoding;
import org.hl7.fhir.r4.model.BooleanType;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.Coding;
import org.hl7.fhir.r4.model.StringType;
import org.hl7.fhir.r4.model.UriType;

public class TranslationRequest {
    private CodeableConcept myCodeableConcept = new CodeableConcept();
    private Long myResourceId;
    private BooleanType myReverse;
    private UriType myUrl;
    private StringType myConceptMapVersion;
    private UriType mySource;
    private UriType myTarget;
    private UriType myTargetSystem;

    public TranslationRequest addCode(String theSystem, String theCode) {
        Validate.notBlank((CharSequence)theSystem, (String)"theSystem must not be null", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)theCode, (String)"theCode must not be null", (Object[])new Object[0]);
        if (this.getCodeableConcept() == null) {
            this.setCodeableConcept(new CodeableConcept());
        }
        this.getCodeableConcept().addCoding(new Coding().setSystem(theSystem).setCode(theCode));
        return this;
    }

    public CodeableConcept getCodeableConcept() {
        return this.myCodeableConcept;
    }

    public TranslationRequest setCodeableConcept(CodeableConcept theCodeableConcept) {
        this.myCodeableConcept = theCodeableConcept;
        return this;
    }

    public Long getResourceId() {
        return this.myResourceId;
    }

    public void setResourceId(Long theResourceId) {
        this.myResourceId = theResourceId;
    }

    public BooleanType getReverse() {
        return this.myReverse;
    }

    public void setReverse(BooleanType theReverse) {
        this.myReverse = theReverse;
    }

    public void setReverse(boolean theReverse) {
        this.myReverse = new BooleanType(theReverse);
    }

    public boolean getReverseAsBoolean() {
        if (this.hasReverse()) {
            return this.myReverse.booleanValue();
        }
        return false;
    }

    public UriType getUrl() {
        return this.myUrl;
    }

    public TranslationRequest setUrl(UriType theUrl) {
        this.myUrl = theUrl;
        return this;
    }

    public StringType getConceptMapVersion() {
        return this.myConceptMapVersion;
    }

    public TranslationRequest setConceptMapVersion(StringType theConceptMapVersion) {
        this.myConceptMapVersion = theConceptMapVersion;
        return this;
    }

    public UriType getSource() {
        return this.mySource;
    }

    public TranslationRequest setSource(UriType theSource) {
        this.mySource = theSource;
        return this;
    }

    public UriType getTarget() {
        return this.myTarget;
    }

    public TranslationRequest setTarget(UriType theTarget) {
        this.myTarget = theTarget;
        return this;
    }

    public UriType getTargetSystem() {
        return this.myTargetSystem;
    }

    public TranslationRequest setTargetSystem(UriType theTargetSystem) {
        this.myTargetSystem = theTargetSystem;
        return this;
    }

    public List<TranslationQuery> getTranslationQueries() {
        ArrayList<TranslationQuery> retVal = new ArrayList<TranslationQuery>();
        for (Coding coding : this.getCodeableConcept().getCoding()) {
            TranslationQuery translationQuery = new TranslationQuery();
            translationQuery.setCoding(coding);
            if (this.hasResourceId()) {
                translationQuery.setResourceId(this.getResourceId());
            }
            if (this.hasUrl()) {
                translationQuery.setUrl(this.getUrl());
            }
            if (this.hasConceptMapVersion()) {
                translationQuery.setConceptMapVersion(this.getConceptMapVersion());
            }
            if (this.hasSource()) {
                translationQuery.setSource(this.getSource());
            }
            if (this.hasTarget()) {
                translationQuery.setTarget(this.getTarget());
            }
            if (this.hasTargetSystem()) {
                translationQuery.setTargetSystem(this.getTargetSystem());
            }
            retVal.add(translationQuery);
        }
        return retVal;
    }

    public boolean hasResourceId() {
        return this.myResourceId != null;
    }

    public boolean hasReverse() {
        return this.myReverse != null;
    }

    public boolean hasUrl() {
        return this.myUrl != null && this.myUrl.hasValue();
    }

    public boolean hasConceptMapVersion() {
        return this.myConceptMapVersion != null && this.myConceptMapVersion.hasValue();
    }

    public boolean hasSource() {
        return this.mySource != null && this.mySource.hasValue();
    }

    public boolean hasTarget() {
        return this.myTarget != null && this.myTarget.hasValue();
    }

    public boolean hasTargetSystem() {
        return this.myTargetSystem != null && this.myTargetSystem.hasValue();
    }

    public IValidationSupport.TranslateCodeRequest asTranslateCodeRequest() {
        return new IValidationSupport.TranslateCodeRequest(Collections.unmodifiableList(this.getCodeableConcept().getCoding()), this.getTargetSystem() != null ? this.getTargetSystem().asStringValue() : null, this.getUrl() != null ? this.getUrl().asStringValue() : null, this.getConceptMapVersion() != null ? this.getConceptMapVersion().asStringValue() : null, this.getSource() != null ? this.getSource().asStringValue() : null, this.getTarget() != null ? this.getTarget().asStringValue() : null, this.getResourceId(), this.getReverseAsBoolean());
    }

    public static TranslationRequest fromTranslateCodeRequest(IValidationSupport.TranslateCodeRequest theRequest) {
        CodeableConcept sourceCodeableConcept = new CodeableConcept();
        for (IBaseCoding aCoding : theRequest.getCodings()) {
            sourceCodeableConcept.addCoding().setSystem(aCoding.getSystem()).setCode(aCoding.getCode()).setVersion(((Coding)aCoding).getVersion());
        }
        TranslationRequest translationRequest = new TranslationRequest();
        translationRequest.setCodeableConcept(sourceCodeableConcept);
        translationRequest.setConceptMapVersion(new StringType(theRequest.getConceptMapVersion()));
        translationRequest.setUrl(new UriType(theRequest.getConceptMapUrl()));
        translationRequest.setSource(new UriType(theRequest.getSourceValueSetUrl()));
        translationRequest.setTarget(new UriType(theRequest.getTargetValueSetUrl()));
        translationRequest.setTargetSystem(new UriType(theRequest.getTargetSystemUrl()));
        translationRequest.setResourceId(theRequest.getResourcePid());
        translationRequest.setReverse(theRequest.isReverse());
        return translationRequest;
    }
}

