/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.api.dao;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.support.IValidationSupport;
import ca.uhn.fhir.jpa.api.dao.IFhirResourceDao;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.util.ParametersUtil;
import java.util.List;
import javax.annotation.Nonnull;
import javax.transaction.Transactional;
import org.hl7.fhir.instance.model.api.IBaseParameters;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.instance.model.api.IPrimitiveType;
import org.hl7.fhir.r4.model.codesystems.ConceptSubsumptionOutcome;

public interface IFhirResourceDaoCodeSystem<T extends IBaseResource, CD, CC>
extends IFhirResourceDao<T> {
    public List<IIdType> findCodeSystemIdsContainingSystemAndCode(String var1, String var2, RequestDetails var3);

    @Transactional
    @Nonnull
    public IValidationSupport.LookupCodeResult lookupCode(IPrimitiveType<String> var1, IPrimitiveType<String> var2, CD var3, RequestDetails var4);

    @Nonnull
    public IValidationSupport.LookupCodeResult lookupCode(IPrimitiveType<String> var1, IPrimitiveType<String> var2, CD var3, IPrimitiveType<String> var4, RequestDetails var5);

    public SubsumesResult subsumes(IPrimitiveType<String> var1, IPrimitiveType<String> var2, IPrimitiveType<String> var3, CD var4, CD var5, RequestDetails var6);

    public IValidationSupport.CodeValidationResult validateCode(IIdType var1, IPrimitiveType<String> var2, IPrimitiveType<String> var3, IPrimitiveType<String> var4, IPrimitiveType<String> var5, CD var6, CC var7, RequestDetails var8);

    public static class SubsumesResult {
        private final ConceptSubsumptionOutcome myOutcome;

        public SubsumesResult(ConceptSubsumptionOutcome theOutcome) {
            this.myOutcome = theOutcome;
        }

        public ConceptSubsumptionOutcome getOutcome() {
            return this.myOutcome;
        }

        public IBaseParameters toParameters(FhirContext theFhirContext) {
            IBaseParameters retVal = ParametersUtil.newInstance((FhirContext)theFhirContext);
            IPrimitiveType outcomeValue = (IPrimitiveType)theFhirContext.getElementDefinition("code").newInstance();
            outcomeValue.setValueAsString(this.getOutcome().toCode());
            ParametersUtil.addParameterToParameters((FhirContext)theFhirContext, (IBaseParameters)retVal, (String)"outcome", (Object)outcomeValue);
            return retVal;
        }
    }
}

