/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.mdm.batch2.clear;

import ca.uhn.fhir.batch2.api.IJobDataSink;
import ca.uhn.fhir.batch2.api.IJobStepWorker;
import ca.uhn.fhir.batch2.api.JobExecutionFailedException;
import ca.uhn.fhir.batch2.api.RunOutcome;
import ca.uhn.fhir.batch2.api.StepExecutionDetails;
import ca.uhn.fhir.batch2.api.VoidModel;
import ca.uhn.fhir.batch2.jobs.chunk.ResourceIdListWorkChunkJson;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.jpa.api.dao.DaoRegistry;
import ca.uhn.fhir.jpa.api.dao.IFhirResourceDao;
import ca.uhn.fhir.jpa.api.model.DeleteConflictList;
import ca.uhn.fhir.jpa.api.svc.IIdHelperService;
import ca.uhn.fhir.jpa.dao.tx.HapiTransactionService;
import ca.uhn.fhir.jpa.delete.DeleteConflictUtil;
import ca.uhn.fhir.jpa.partition.SystemRequestDetails;
import ca.uhn.fhir.mdm.batch2.clear.MdmClearJobParameters;
import ca.uhn.fhir.mdm.dao.IMdmLinkDao;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.api.server.storage.TransactionDetails;
import ca.uhn.fhir.util.StopWatch;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;

public class MdmClearStep
implements IJobStepWorker<MdmClearJobParameters, ResourceIdListWorkChunkJson, VoidModel> {
    private static final Logger ourLog = LoggerFactory.getLogger(MdmClearStep.class);
    @Autowired
    HapiTransactionService myHapiTransactionService;
    @Autowired
    DaoRegistry myDaoRegistry;
    @Autowired
    IIdHelperService myIdHelperService;
    @Autowired
    FhirContext myFhirContext;
    @Autowired
    IMdmLinkDao myMdmLinkSvc;

    @Nonnull
    public RunOutcome run(@Nonnull StepExecutionDetails<MdmClearJobParameters, ResourceIdListWorkChunkJson> theStepExecutionDetails, @Nonnull IJobDataSink<VoidModel> theDataSink) throws JobExecutionFailedException {
        SystemRequestDetails requestDetails = new SystemRequestDetails();
        requestDetails.setRequestPartitionId(((MdmClearJobParameters)theStepExecutionDetails.getParameters()).getRequestPartitionId());
        TransactionDetails transactionDetails = new TransactionDetails();
        this.myHapiTransactionService.execute((RequestDetails)requestDetails, transactionDetails, (TransactionCallback)this.buildJob((RequestDetails)requestDetails, transactionDetails, theStepExecutionDetails));
        return new RunOutcome(((ResourceIdListWorkChunkJson)theStepExecutionDetails.getData()).size());
    }

    MdmClearJob buildJob(RequestDetails requestDetails, TransactionDetails transactionDetails, StepExecutionDetails<MdmClearJobParameters, ResourceIdListWorkChunkJson> theStepExecutionDetails) {
        return new MdmClearJob(requestDetails, transactionDetails, theStepExecutionDetails);
    }

    class MdmClearJob
    implements TransactionCallback<Void> {
        private final RequestDetails myRequestDetails;
        private final TransactionDetails myTransactionDetails;
        private final ResourceIdListWorkChunkJson myData;
        private final String myChunkId;
        private final String myInstanceId;

        public MdmClearJob(RequestDetails theRequestDetails, TransactionDetails theTransactionDetails, StepExecutionDetails<MdmClearJobParameters, ResourceIdListWorkChunkJson> theStepExecutionDetails) {
            this.myRequestDetails = theRequestDetails;
            this.myTransactionDetails = theTransactionDetails;
            this.myData = (ResourceIdListWorkChunkJson)theStepExecutionDetails.getData();
            this.myInstanceId = theStepExecutionDetails.getInstance().getInstanceId();
            this.myChunkId = theStepExecutionDetails.getChunkId();
        }

        public Void doInTransaction(@Nonnull TransactionStatus theStatus) {
            List persistentIds = this.myData.getResourcePersistentIds();
            if (persistentIds.isEmpty()) {
                return null;
            }
            ourLog.info("Starting mdm clear work chunk with {} resources - Instance[{}] Chunk[{}]", new Object[]{persistentIds.size(), this.myInstanceId, this.myChunkId});
            StopWatch sw = new StopWatch();
            MdmClearStep.this.myMdmLinkSvc.deleteLinksWithAnyReferenceToPids(persistentIds);
            String resourceName = this.myData.getResourceType(0);
            IFhirResourceDao dao = MdmClearStep.this.myDaoRegistry.getResourceDao(resourceName);
            DeleteConflictList conflicts = new DeleteConflictList();
            dao.deletePidList("$mdm-clear", (Collection)persistentIds, conflicts, this.myRequestDetails);
            DeleteConflictUtil.validateDeleteConflictsEmptyOrThrowException((FhirContext)MdmClearStep.this.myFhirContext, (DeleteConflictList)conflicts);
            ourLog.info("Finished removing {} golden resources in {} - {}/sec - Instance[{}] Chunk[{}]", new Object[]{persistentIds.size(), sw, sw.formatThroughput((long)persistentIds.size(), TimeUnit.SECONDS), this.myInstanceId, this.myChunkId});
            return null;
        }
    }
}

