/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.mdm.batch2;

import ca.uhn.fhir.batch2.api.IFirstJobStepWorker;
import ca.uhn.fhir.batch2.api.IJobDataSink;
import ca.uhn.fhir.batch2.api.JobExecutionFailedException;
import ca.uhn.fhir.batch2.api.RunOutcome;
import ca.uhn.fhir.batch2.api.StepExecutionDetails;
import ca.uhn.fhir.batch2.api.VoidModel;
import ca.uhn.fhir.batch2.config.Batch2Constants;
import ca.uhn.fhir.mdm.batch2.MdmChunkRangeJson;
import ca.uhn.fhir.mdm.batch2.clear.MdmClearJobParameters;
import ca.uhn.fhir.model.api.IModelJson;
import java.util.Date;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MdmGenerateRangeChunksStep
implements IFirstJobStepWorker<MdmClearJobParameters, MdmChunkRangeJson> {
    private static final Logger ourLog = LoggerFactory.getLogger(MdmGenerateRangeChunksStep.class);

    @Nonnull
    public RunOutcome run(@Nonnull StepExecutionDetails<MdmClearJobParameters, VoidModel> theStepExecutionDetails, @Nonnull IJobDataSink<MdmChunkRangeJson> theDataSink) throws JobExecutionFailedException {
        MdmClearJobParameters params = (MdmClearJobParameters)theStepExecutionDetails.getParameters();
        Date start = Batch2Constants.BATCH_START_DATE;
        Date end = new Date();
        for (String nextResourceType : params.getResourceNames()) {
            ourLog.info("Initiating mdm clear of [{}]] Golden Resources from {} to {}", new Object[]{nextResourceType, start, end});
            MdmChunkRangeJson nextRange = new MdmChunkRangeJson();
            nextRange.setResourceType(nextResourceType);
            nextRange.setStart(start);
            nextRange.setEnd(end);
            theDataSink.accept((IModelJson)nextRange);
        }
        return RunOutcome.SUCCESS;
    }
}

