/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.batch2.progress;

import ca.uhn.fhir.batch2.api.IJobCompletionHandler;
import ca.uhn.fhir.batch2.api.JobCompletionDetails;
import ca.uhn.fhir.batch2.coordinator.JobDefinitionRegistry;
import ca.uhn.fhir.batch2.model.JobDefinition;
import ca.uhn.fhir.batch2.model.JobInstance;
import ca.uhn.fhir.batch2.model.StatusEnum;
import ca.uhn.fhir.model.api.IModelJson;
import ca.uhn.fhir.util.Logs;
import org.slf4j.Logger;

public class JobInstanceStatusUpdater {
    private static final Logger ourLog = Logs.getBatchTroubleshootingLog();
    private final JobDefinitionRegistry myJobDefinitionRegistry;

    public JobInstanceStatusUpdater(JobDefinitionRegistry theJobDefinitionRegistry) {
        this.myJobDefinitionRegistry = theJobDefinitionRegistry;
    }

    public boolean updateInstanceStatus(JobInstance theJobInstance, StatusEnum theNewStatus) {
        StatusEnum origStatus = theJobInstance.getStatus();
        if (origStatus == theNewStatus) {
            return false;
        }
        if (!StatusEnum.isLegalStateTransition(origStatus, theNewStatus)) {
            ourLog.error("Ignoring illegal state transition for job instance {} of type {} from {} to {}", new Object[]{theJobInstance.getInstanceId(), theJobInstance.getJobDefinitionId(), origStatus, theNewStatus});
            return false;
        }
        theJobInstance.setStatus(theNewStatus);
        ourLog.debug("Updating job instance {} of type {} from {} to {}", new Object[]{theJobInstance.getInstanceId(), theJobInstance.getJobDefinitionId(), origStatus, theNewStatus});
        this.handleStatusChange(theJobInstance);
        return true;
    }

    private <PT extends IModelJson> void handleStatusChange(JobInstance theJobInstance) {
        JobDefinition definition = this.myJobDefinitionRegistry.getJobDefinitionOrThrowException(theJobInstance);
        assert (definition != null);
        switch (theJobInstance.getStatus()) {
            case COMPLETED: {
                this.invokeCompletionHandler(theJobInstance, definition, definition.getCompletionHandler());
                break;
            }
            case FAILED: 
            case CANCELLED: {
                this.invokeCompletionHandler(theJobInstance, definition, definition.getErrorHandler());
                break;
            }
        }
    }

    private <PT extends IModelJson> void invokeCompletionHandler(JobInstance theJobInstance, JobDefinition<PT> theJobDefinition, IJobCompletionHandler<PT> theJobCompletionHandler) {
        if (theJobCompletionHandler == null) {
            return;
        }
        PT jobParameters = theJobInstance.getParameters(theJobDefinition.getParametersType());
        JobCompletionDetails<PT> completionDetails = new JobCompletionDetails<PT>(jobParameters, theJobInstance);
        theJobCompletionHandler.jobComplete(completionDetails);
    }
}

