/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.batch2.model;

import ca.uhn.fhir.batch2.model.JobDefinition;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class WorkChunkCreateEvent {
    public final String jobDefinitionId;
    public final int jobDefinitionVersion;
    public final String targetStepId;
    public final String instanceId;
    public final int sequence;
    public final String serializedData;

    public WorkChunkCreateEvent(@Nonnull String theJobDefinitionId, int theJobDefinitionVersion, @Nonnull String theTargetStepId, @Nonnull String theInstanceId, int theSequence, @Nullable String theSerializedData) {
        this.jobDefinitionId = theJobDefinitionId;
        this.jobDefinitionVersion = theJobDefinitionVersion;
        this.targetStepId = theTargetStepId;
        this.instanceId = theInstanceId;
        this.sequence = theSequence;
        this.serializedData = theSerializedData;
    }

    public static WorkChunkCreateEvent firstChunk(JobDefinition<?> theJobDefinition, String theInstanceId) {
        String firstStepId = theJobDefinition.getFirstStepId();
        String jobDefinitionId = theJobDefinition.getJobDefinitionId();
        int jobDefinitionVersion = theJobDefinition.getJobDefinitionVersion();
        return new WorkChunkCreateEvent(jobDefinitionId, jobDefinitionVersion, firstStepId, theInstanceId, 0, null);
    }

    public boolean equals(Object theO) {
        if (this == theO) {
            return true;
        }
        if (theO == null || this.getClass() != theO.getClass()) {
            return false;
        }
        WorkChunkCreateEvent that = (WorkChunkCreateEvent)theO;
        return new EqualsBuilder().append((Object)this.jobDefinitionId, (Object)that.jobDefinitionId).append(this.jobDefinitionVersion, that.jobDefinitionVersion).append((Object)this.targetStepId, (Object)that.targetStepId).append((Object)this.instanceId, (Object)that.instanceId).append(this.sequence, that.sequence).append((Object)this.serializedData, (Object)that.serializedData).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append((Object)this.jobDefinitionId).append(this.jobDefinitionVersion).append((Object)this.targetStepId).append((Object)this.instanceId).append(this.sequence).append((Object)this.serializedData).toHashCode();
    }
}

