/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.batch2.model;

import ca.uhn.fhir.batch2.model.WorkChunkStatusEnum;
import ca.uhn.fhir.model.api.IModelJson;
import ca.uhn.fhir.rest.server.util.JsonDateDeserializer;
import ca.uhn.fhir.rest.server.util.JsonDateSerializer;
import ca.uhn.fhir.util.JsonUtil;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class WorkChunk
implements IModelJson {
    @JsonProperty(value="id")
    private String myId;
    @JsonProperty(value="sequence")
    private int mySequence;
    @JsonProperty(value="status")
    private WorkChunkStatusEnum myStatus;
    @JsonProperty(value="jobDefinitionId")
    private String myJobDefinitionId;
    @JsonProperty(value="jobDefinitionVersion")
    private int myJobDefinitionVersion;
    @JsonProperty(value="targetStepId")
    private String myTargetStepId;
    @JsonProperty(value="instanceId")
    private String myInstanceId;
    @JsonProperty(value="data")
    private String myData;
    @JsonProperty(value="createTime")
    @JsonSerialize(using=JsonDateSerializer.class)
    @JsonDeserialize(using=JsonDateDeserializer.class)
    private Date myCreateTime;
    @JsonProperty(value="startTime")
    @JsonSerialize(using=JsonDateSerializer.class)
    @JsonDeserialize(using=JsonDateDeserializer.class)
    private Date myStartTime;
    @JsonProperty(value="endTime")
    @JsonSerialize(using=JsonDateSerializer.class)
    @JsonDeserialize(using=JsonDateDeserializer.class)
    private Date myEndTime;
    @JsonProperty(value="updateTime")
    @JsonSerialize(using=JsonDateSerializer.class)
    @JsonDeserialize(using=JsonDateDeserializer.class)
    private Date myUpdateTime;
    @JsonProperty(value="recordsProcessed", access=JsonProperty.Access.READ_ONLY)
    private Integer myRecordsProcessed;
    @JsonProperty(value="errorMessage", access=JsonProperty.Access.READ_ONLY)
    private String myErrorMessage;
    @JsonProperty(value="errorCount", access=JsonProperty.Access.READ_ONLY)
    private int myErrorCount;
    @JsonProperty(value="warningMessage", access=JsonProperty.Access.READ_ONLY)
    private String myWarningMessage;

    public int getErrorCount() {
        return this.myErrorCount;
    }

    public WorkChunk setErrorCount(int theErrorCount) {
        this.myErrorCount = theErrorCount;
        return this;
    }

    public Date getStartTime() {
        return this.myStartTime;
    }

    public WorkChunk setStartTime(Date theStartTime) {
        this.myStartTime = theStartTime;
        return this;
    }

    public Date getEndTime() {
        return this.myEndTime;
    }

    public WorkChunk setEndTime(Date theEndTime) {
        this.myEndTime = theEndTime;
        return this;
    }

    public Integer getRecordsProcessed() {
        return this.myRecordsProcessed;
    }

    public WorkChunk setRecordsProcessed(Integer theRecordsProcessed) {
        this.myRecordsProcessed = theRecordsProcessed;
        return this;
    }

    public WorkChunkStatusEnum getStatus() {
        return this.myStatus;
    }

    public WorkChunk setStatus(WorkChunkStatusEnum theStatus) {
        this.myStatus = theStatus;
        return this;
    }

    public String getJobDefinitionId() {
        return this.myJobDefinitionId;
    }

    public WorkChunk setJobDefinitionId(String theJobDefinitionId) {
        Validate.notBlank((CharSequence)theJobDefinitionId);
        this.myJobDefinitionId = theJobDefinitionId;
        return this;
    }

    public int getJobDefinitionVersion() {
        return this.myJobDefinitionVersion;
    }

    public WorkChunk setJobDefinitionVersion(int theJobDefinitionVersion) {
        Validate.isTrue((theJobDefinitionVersion >= 1 ? 1 : 0) != 0);
        this.myJobDefinitionVersion = theJobDefinitionVersion;
        return this;
    }

    public String getTargetStepId() {
        return this.myTargetStepId;
    }

    public WorkChunk setTargetStepId(String theTargetStepId) {
        Validate.notBlank((CharSequence)theTargetStepId);
        this.myTargetStepId = theTargetStepId;
        return this;
    }

    public String getData() {
        return this.myData;
    }

    public WorkChunk setData(String theData) {
        this.myData = theData;
        return this;
    }

    public WorkChunk setData(IModelJson theData) {
        this.setData(JsonUtil.serializeOrInvalidRequest((IModelJson)theData));
        return this;
    }

    public <T extends IModelJson> T getData(Class<T> theType) {
        return (T)((IModelJson)JsonUtil.deserialize((String)this.getData(), theType));
    }

    public String getInstanceId() {
        return this.myInstanceId;
    }

    public WorkChunk setInstanceId(String theInstanceId) {
        this.myInstanceId = theInstanceId;
        return this;
    }

    public String getId() {
        return this.myId;
    }

    public WorkChunk setId(String theId) {
        Validate.notBlank((CharSequence)theId);
        this.myId = theId;
        return this;
    }

    public int getSequence() {
        return this.mySequence;
    }

    public void setSequence(int theSequence) {
        this.mySequence = theSequence;
    }

    public Date getCreateTime() {
        return this.myCreateTime;
    }

    public void setCreateTime(Date theCreateTime) {
        this.myCreateTime = theCreateTime;
    }

    public String getErrorMessage() {
        return this.myErrorMessage;
    }

    public WorkChunk setErrorMessage(String theErrorMessage) {
        this.myErrorMessage = theErrorMessage;
        return this;
    }

    public Date getUpdateTime() {
        return this.myUpdateTime;
    }

    public void setUpdateTime(Date theUpdateTime) {
        this.myUpdateTime = theUpdateTime;
    }

    public String getWarningMessage() {
        return this.myWarningMessage;
    }

    public WorkChunk setWarningMessage(String theWarningMessage) {
        this.myWarningMessage = theWarningMessage;
        return this;
    }

    public String toString() {
        ToStringBuilder b = new ToStringBuilder((Object)this);
        b.append("Id", (Object)this.myId);
        b.append("Sequence", this.mySequence);
        b.append("Status", (Object)this.myStatus);
        b.append("JobDefinitionId", (Object)this.myJobDefinitionId);
        b.append("JobDefinitionVersion", this.myJobDefinitionVersion);
        b.append("TargetStepId", (Object)this.myTargetStepId);
        b.append("InstanceId", (Object)this.myInstanceId);
        b.append("Data", (Object)(StringUtils.isNotBlank((CharSequence)this.myData) ? "(present)" : "(absent)"));
        b.append("CreateTime", (Object)this.myCreateTime);
        b.append("StartTime", (Object)this.myStartTime);
        b.append("EndTime", (Object)this.myEndTime);
        b.append("UpdateTime", (Object)this.myUpdateTime);
        b.append("RecordsProcessed", (Object)this.myRecordsProcessed);
        if (StringUtils.isNotBlank((CharSequence)this.myErrorMessage)) {
            b.append("ErrorMessage", (Object)this.myErrorMessage);
        }
        if (this.myErrorCount > 0) {
            b.append("ErrorCount", this.myErrorCount);
        }
        if (StringUtils.isNotBlank((CharSequence)this.myWarningMessage)) {
            b.append("WarningMessage", (Object)this.myWarningMessage);
        }
        return b.toString();
    }
}

