/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.batch2.jobs.step;

import ca.uhn.fhir.batch2.api.IJobDataSink;
import ca.uhn.fhir.batch2.api.IJobStepWorker;
import ca.uhn.fhir.batch2.api.JobExecutionFailedException;
import ca.uhn.fhir.batch2.api.RunOutcome;
import ca.uhn.fhir.batch2.api.StepExecutionDetails;
import ca.uhn.fhir.batch2.jobs.chunk.ChunkRangeJson;
import ca.uhn.fhir.batch2.jobs.chunk.ResourceIdListWorkChunkJson;
import ca.uhn.fhir.batch2.jobs.chunk.TypedPidJson;
import ca.uhn.fhir.batch2.jobs.parameters.PartitionedJobParameters;
import ca.uhn.fhir.batch2.jobs.step.IIdChunkProducer;
import ca.uhn.fhir.interceptor.model.RequestPartitionId;
import ca.uhn.fhir.jpa.api.pid.IResourcePidStream;
import ca.uhn.fhir.util.Logs;
import ca.uhn.fhir.util.StreamUtil;
import jakarta.annotation.Nonnull;
import java.util.Collection;
import java.util.Date;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Stream;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;

public class ResourceIdListStep<PT extends PartitionedJobParameters, IT extends ChunkRangeJson>
implements IJobStepWorker<PT, IT, ResourceIdListWorkChunkJson> {
    private static final Logger ourLog = Logs.getBatchTroubleshootingLog();
    public static final int DEFAULT_PAGE_SIZE = 20000;
    protected static final int MAX_BATCH_OF_IDS = 500;
    private final IIdChunkProducer<IT> myIdChunkProducer;

    public ResourceIdListStep(IIdChunkProducer<IT> theIdChunkProducer) {
        this.myIdChunkProducer = theIdChunkProducer;
    }

    @Override
    @Nonnull
    public RunOutcome run(@Nonnull StepExecutionDetails<PT, IT> theStepExecutionDetails, @Nonnull IJobDataSink<ResourceIdListWorkChunkJson> theDataSink) throws JobExecutionFailedException {
        ChunkRangeJson data = (ChunkRangeJson)theStepExecutionDetails.getData();
        Date start = data.getStart();
        Date end = data.getEnd();
        Integer batchSize = ((PartitionedJobParameters)theStepExecutionDetails.getParameters()).getBatchSize();
        ourLog.info("Beginning scan for reindex IDs in range {} to {}", (Object)start, (Object)end);
        RequestPartitionId requestPartitionId = ((PartitionedJobParameters)theStepExecutionDetails.getParameters()).getRequestPartitionId();
        int chunkSize = Math.min((Integer)ObjectUtils.defaultIfNull((Object)batchSize, (Object)500), 500);
        IResourcePidStream searchResult = this.myIdChunkProducer.fetchResourceIdStream(start, end, requestPartitionId, (ChunkRangeJson)theStepExecutionDetails.getData());
        searchResult.visitStreamNoResult(typedResourcePidStream -> {
            AtomicInteger totalIdsFound = new AtomicInteger();
            AtomicInteger chunkCount = new AtomicInteger();
            Stream<TypedPidJson> jsonStream = typedResourcePidStream.map(TypedPidJson::new);
            StreamUtil.partition(jsonStream, (int)chunkSize).forEach(idBatch -> {
                totalIdsFound.addAndGet(idBatch.size());
                chunkCount.getAndIncrement();
                this.submitWorkChunk((Collection<TypedPidJson>)idBatch, searchResult.getRequestPartitionId(), theDataSink);
            });
            ourLog.info("Submitted {} chunks with {} resource IDs", (Object)chunkCount, (Object)totalIdsFound);
        });
        return RunOutcome.SUCCESS;
    }

    private void submitWorkChunk(Collection<TypedPidJson> theTypedPids, RequestPartitionId theRequestPartitionId, IJobDataSink<ResourceIdListWorkChunkJson> theDataSink) {
        if (theTypedPids.isEmpty()) {
            return;
        }
        ourLog.info("Submitting work chunk with {} IDs", (Object)theTypedPids.size());
        ResourceIdListWorkChunkJson data = new ResourceIdListWorkChunkJson(theTypedPids, theRequestPartitionId);
        ourLog.debug("IDs are: {}", (Object)data);
        theDataSink.accept(data);
    }
}

