/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.batch2.jobs.parameters;

import ca.uhn.fhir.batch2.jobs.parameters.IUrlListValidator;
import ca.uhn.fhir.batch2.jobs.parameters.PartitionedUrl;
import ca.uhn.fhir.jpa.api.svc.IBatch2DaoSvc;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class UrlListValidator
implements IUrlListValidator {
    private final String myOperationName;
    private final IBatch2DaoSvc myBatch2DaoSvc;

    public UrlListValidator(String theOperationName, IBatch2DaoSvc theBatch2DaoSvc) {
        this.myOperationName = theOperationName;
        this.myBatch2DaoSvc = theBatch2DaoSvc;
    }

    @Override
    @Nullable
    public List<String> validateUrls(@Nonnull List<String> theUrls) {
        if (theUrls.isEmpty() && !this.myBatch2DaoSvc.isAllResourceTypeSupported()) {
            return Collections.singletonList("At least one type-specific search URL must be provided for " + this.myOperationName + " on this server");
        }
        return Collections.emptyList();
    }

    @Override
    @Nullable
    public List<String> validatePartitionedUrls(@Nonnull List<PartitionedUrl> thePartitionedUrls) {
        List<String> urls = thePartitionedUrls.stream().map(PartitionedUrl::getUrl).collect(Collectors.toList());
        return this.validateUrls(urls);
    }
}

