/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.batch2.jobs.chunk;

import ca.uhn.fhir.batch2.jobs.chunk.TypedPidJson;
import ca.uhn.fhir.interceptor.model.RequestPartitionId;
import ca.uhn.fhir.jpa.api.svc.IIdHelperService;
import ca.uhn.fhir.model.api.IModelJson;
import ca.uhn.fhir.rest.api.server.storage.IResourcePersistentId;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

public class ResourceIdListWorkChunkJson
implements IModelJson {
    @JsonProperty(value="requestPartitionId")
    private RequestPartitionId myRequestPartitionId;
    @JsonProperty(value="ids")
    private List<TypedPidJson> myTypedPids;

    public ResourceIdListWorkChunkJson() {
    }

    public ResourceIdListWorkChunkJson(Collection<TypedPidJson> theTypedPids, RequestPartitionId theRequestPartitionId) {
        this();
        this.getTypedPids().addAll(theTypedPids);
        this.myRequestPartitionId = theRequestPartitionId;
    }

    public RequestPartitionId getRequestPartitionId() {
        return this.myRequestPartitionId;
    }

    private List<TypedPidJson> getTypedPids() {
        if (this.myTypedPids == null) {
            this.myTypedPids = new ArrayList<TypedPidJson>();
        }
        return this.myTypedPids;
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("ids", this.myTypedPids).toString();
    }

    public <T extends IResourcePersistentId> List<T> getResourcePersistentIds(IIdHelperService<T> theIdHelperService) {
        if (this.myTypedPids.isEmpty()) {
            return Collections.emptyList();
        }
        return this.myTypedPids.stream().map(t -> {
            IResourcePersistentId retval = theIdHelperService.newPidFromStringIdAndResourceName(t.getPid(), t.getResourceType());
            return retval;
        }).collect(Collectors.toList());
    }

    public int size() {
        return this.getTypedPids().size();
    }

    public void addTypedPid(String theResourceType, Long thePid) {
        this.getTypedPids().add(new TypedPidJson(theResourceType, thePid.toString()));
    }

    public String getResourceType(int index) {
        return this.getTypedPids().get(index).getResourceType();
    }
}

