/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.batch2.coordinator;

import ca.uhn.fhir.batch2.api.IJobPersistence;
import ca.uhn.fhir.batch2.coordinator.JobDefinitionRegistry;
import ca.uhn.fhir.batch2.model.JobDefinition;
import ca.uhn.fhir.batch2.model.JobInstance;
import ca.uhn.fhir.batch2.model.StatusEnum;
import ca.uhn.fhir.batch2.models.JobInstanceFetchRequest;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.model.api.annotation.PasswordField;
import ca.uhn.fhir.rest.server.exceptions.InternalErrorException;
import ca.uhn.fhir.rest.server.exceptions.ResourceNotFoundException;
import ca.uhn.fhir.util.JsonUtil;
import ca.uhn.fhir.util.UrlUtil;
import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.data.domain.Page;

class JobQuerySvc {
    private final IJobPersistence myJobPersistence;
    private final JobDefinitionRegistry myJobDefinitionRegistry;

    JobQuerySvc(@Nonnull IJobPersistence theJobPersistence, @Nonnull JobDefinitionRegistry theJobDefinitionRegistry) {
        this.myJobPersistence = theJobPersistence;
        this.myJobDefinitionRegistry = theJobDefinitionRegistry;
    }

    @Nonnull
    JobInstance fetchInstance(String theInstanceId) {
        return this.myJobPersistence.fetchInstance(theInstanceId).map(this::massageInstanceForUserAccess).orElseThrow(() -> new ResourceNotFoundException(Msg.code((int)2040) + "Unknown instance ID: " + UrlUtil.escapeUrlParam((String)theInstanceId) + ". Please check if the input job ID is valid."));
    }

    List<JobInstance> fetchInstances(int thePageSize, int thePageIndex) {
        return this.myJobPersistence.fetchInstances(thePageSize, thePageIndex).stream().map(this::massageInstanceForUserAccess).collect(Collectors.toList());
    }

    public Page<JobInstance> fetchAllInstances(JobInstanceFetchRequest theFetchRequest) {
        return this.myJobPersistence.fetchJobInstances(theFetchRequest);
    }

    public List<JobInstance> fetchRecentInstances(int theCount, int theStart) {
        return this.massageInstancesForUserAccess(this.myJobPersistence.fetchRecentInstances(theCount, theStart));
    }

    private List<JobInstance> massageInstancesForUserAccess(List<JobInstance> theFetchRecentInstances) {
        return theFetchRecentInstances.stream().map(this::massageInstanceForUserAccess).collect(Collectors.toList());
    }

    private JobInstance massageInstanceForUserAccess(JobInstance theInstance) {
        JobInstance retVal = new JobInstance(theInstance);
        JobDefinition definition = this.myJobDefinitionRegistry.getJobDefinitionOrThrowException(theInstance);
        Object parameters = retVal.getParameters(definition.getParametersType());
        JobQuerySvc.stripPasswordFields(parameters);
        String parametersString = JsonUtil.serializeOrInvalidRequest(parameters);
        retVal.setParameters(parametersString);
        return retVal;
    }

    private static void stripPasswordFields(@Nonnull Object theParameters) {
        Field[] declaredFields;
        for (Field nextField : declaredFields = theParameters.getClass().getDeclaredFields()) {
            JsonProperty propertyAnnotation = nextField.getAnnotation(JsonProperty.class);
            if (propertyAnnotation == null) continue;
            nextField.setAccessible(true);
            try {
                Object nextValue = nextField.get(theParameters);
                if (nextField.getAnnotation(PasswordField.class) != null) {
                    nextField.set(theParameters, null);
                    continue;
                }
                if (nextValue == null) continue;
                JobQuerySvc.stripPasswordFields(nextValue);
            }
            catch (IllegalAccessException e) {
                throw new InternalErrorException(Msg.code((int)2044) + e.getMessage(), (Throwable)e);
            }
        }
    }

    public List<JobInstance> getInstancesByJobDefinitionIdAndEndedStatus(String theJobDefinitionId, @Nullable Boolean theEnded, int theCount, int theStart) {
        if (theEnded == null) {
            return this.myJobPersistence.fetchInstancesByJobDefinitionId(theJobDefinitionId, theCount, theStart);
        }
        Set<StatusEnum> requestedStatus = theEnded != false ? StatusEnum.getEndedStatuses() : StatusEnum.getNotEndedStatuses();
        return this.getInstancesByJobDefinitionAndStatuses(theJobDefinitionId, requestedStatus, theCount, theStart);
    }

    public List<JobInstance> getInstancesByJobDefinitionAndStatuses(String theJobDefinitionId, Set<StatusEnum> theStatuses, int theCount, int theStart) {
        return this.myJobPersistence.fetchInstancesByJobDefinitionIdAndStatus(theJobDefinitionId, theStatuses, theCount, theStart);
    }
}

