/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.batch2.coordinator;

import ca.uhn.fhir.batch2.api.IJobDataSink;
import ca.uhn.fhir.batch2.api.IWarningProcessor;
import ca.uhn.fhir.batch2.model.JobDefinitionStep;
import ca.uhn.fhir.batch2.model.JobWorkCursor;
import ca.uhn.fhir.model.api.IModelJson;
import ca.uhn.fhir.util.Logs;
import org.slf4j.Logger;

abstract class BaseDataSink<PT extends IModelJson, IT extends IModelJson, OT extends IModelJson>
implements IJobDataSink<OT> {
    private static final Logger ourLog = Logs.getBatchTroubleshootingLog();
    private final String myInstanceId;
    private final JobWorkCursor<PT, IT, OT> myJobWorkCursor;
    private int myRecoveredErrorCount;
    protected final String myJobDefinitionId;
    private IWarningProcessor myWarningProcessor;

    protected BaseDataSink(String theInstanceId, JobWorkCursor<PT, IT, OT> theJobWorkCursor) {
        this.myInstanceId = theInstanceId;
        this.myJobWorkCursor = theJobWorkCursor;
        this.myJobDefinitionId = theJobWorkCursor.getJobDefinition().getJobDefinitionId();
    }

    public String getInstanceId() {
        return this.myInstanceId;
    }

    @Override
    public void recoveredError(String theMessage) {
        ourLog.error("Error during job[{}] step[{}]: {}", new Object[]{this.myInstanceId, this.myJobWorkCursor.getCurrentStepId(), theMessage});
        if (this.myWarningProcessor != null) {
            this.myWarningProcessor.recoverWarningMessage(theMessage);
        }
        ++this.myRecoveredErrorCount;
    }

    @Override
    public void setWarningProcessor(IWarningProcessor theWarningProcessor) {
        this.myWarningProcessor = theWarningProcessor;
    }

    public int getRecoveredErrorCount() {
        return this.myRecoveredErrorCount;
    }

    public String getRecoveredWarning() {
        if (this.myWarningProcessor != null) {
            return this.myWarningProcessor.getRecoveredWarningMessage();
        }
        return null;
    }

    public abstract int getWorkChunkCount();

    public boolean firstStepProducedNothing() {
        return this.myJobWorkCursor.isFirstStep && this.getWorkChunkCount() == 0;
    }

    public boolean hasExactlyOneChunk() {
        return this.getWorkChunkCount() == 1;
    }

    public JobDefinitionStep<PT, IT, OT> getTargetStep() {
        return this.myJobWorkCursor.currentStep;
    }

    public String getJobDefinitionId() {
        return this.myJobDefinitionId;
    }
}

