/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.batch2.config;

import ca.uhn.fhir.batch2.coordinator.JobDefinitionRegistry;
import ca.uhn.fhir.batch2.model.JobDefinition;
import ca.uhn.fhir.util.Logs;
import java.util.Map;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.context.event.EventListener;
import org.springframework.core.annotation.Order;

public class Batch2JobRegisterer {
    private static final Logger ourLog = Logs.getBatchTroubleshootingLog();
    @Autowired
    private ApplicationContext myApplicationContext;

    @EventListener(classes={ContextRefreshedEvent.class})
    @Order(value=100)
    public void start() {
        Map batchJobs = this.myApplicationContext.getBeansOfType(JobDefinition.class);
        JobDefinitionRegistry jobRegistry = (JobDefinitionRegistry)this.myApplicationContext.getBean(JobDefinitionRegistry.class);
        for (Map.Entry next : batchJobs.entrySet()) {
            JobDefinition jobDefinition = (JobDefinition)next.getValue();
            ourLog.info("Registering Batch2 Job Definition: {} / {}", (Object)jobDefinition.getJobDefinitionId(), (Object)jobDefinition.getJobDefinitionVersion());
            jobRegistry.addJobDefinition(jobDefinition);
        }
    }
}

