/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.server.util;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.RuntimeResourceDefinition;
import ca.uhn.fhir.context.RuntimeSearchParam;
import ca.uhn.fhir.context.phonetic.IPhoneticEncoder;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.rest.server.util.ISearchParamRegistry;
import ca.uhn.fhir.rest.server.util.ResourceSearchParams;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.Validate;

public class FhirContextSearchParamRegistry
implements ISearchParamRegistry {
    private final List<RuntimeSearchParam> myExtraSearchParams = new ArrayList<RuntimeSearchParam>();
    private final FhirContext myCtx;

    public FhirContextSearchParamRegistry(@Nonnull FhirContext theCtx) {
        Validate.notNull((Object)theCtx, (String)"theCtx must not be null", (Object[])new Object[0]);
        this.myCtx = theCtx;
    }

    @Override
    public void forceRefresh() {
    }

    @Override
    public RuntimeSearchParam getActiveSearchParam(String theResourceName, String theParamName) {
        return this.getActiveSearchParams(theResourceName).get(theParamName);
    }

    @Override
    public ResourceSearchParams getActiveSearchParams(String theResourceName) {
        ResourceSearchParams retval = new ResourceSearchParams(theResourceName);
        RuntimeResourceDefinition nextResDef = this.myCtx.getResourceDefinition(theResourceName);
        for (RuntimeSearchParam nextSp : nextResDef.getSearchParams()) {
            retval.put(nextSp.getName(), nextSp);
        }
        for (RuntimeSearchParam next : this.myExtraSearchParams) {
            retval.put(next.getName(), next);
        }
        return retval;
    }

    public void addSearchParam(RuntimeSearchParam theSearchParam) {
        this.myExtraSearchParams.add(theSearchParam);
    }

    @Override
    public List<RuntimeSearchParam> getActiveComboSearchParams(String theResourceName, Set<String> theParamNames) {
        throw new UnsupportedOperationException(Msg.code((int)2066));
    }

    @Override
    @Nullable
    public RuntimeSearchParam getActiveSearchParamByUrl(String theUrl) {
        throw new UnsupportedOperationException(Msg.code((int)2067));
    }

    @Override
    public List<RuntimeSearchParam> getActiveComboSearchParams(String theResourceName) {
        throw new UnsupportedOperationException(Msg.code((int)2068));
    }

    @Override
    public void requestRefresh() {
    }

    @Override
    public void setPhoneticEncoder(IPhoneticEncoder thePhoneticEncoder) {
    }
}

