/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.server.method;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.model.valueset.BundleTypeEnum;
import ca.uhn.fhir.rest.annotation.OperationParam;
import ca.uhn.fhir.rest.annotation.Validate;
import ca.uhn.fhir.rest.api.EncodingEnum;
import ca.uhn.fhir.rest.server.method.IParameter;
import ca.uhn.fhir.rest.server.method.OperationMethodBinding;
import ca.uhn.fhir.rest.server.method.OperationParameter;
import ca.uhn.fhir.rest.server.method.ResourceParameter;
import ca.uhn.fhir.util.ParametersUtil;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.instance.model.api.IBaseResource;

public class ValidateMethodBindingDstu2Plus
extends OperationMethodBinding {
    public ValidateMethodBindingDstu2Plus(Class<?> theReturnResourceType, Class<? extends IBaseResource> theReturnTypeFromRp, Method theMethod, FhirContext theContext, Object theProvider, Validate theAnnotation) {
        super(theReturnResourceType, theReturnTypeFromRp, theMethod, theContext, theProvider, true, "$validate", theAnnotation.type(), null, new OperationParam[0], BundleTypeEnum.COLLECTION, false);
        ArrayList<IParameter> newParams = new ArrayList<IParameter>();
        int idx = 0;
        for (IParameter next : this.getParameters()) {
            if (next instanceof ResourceParameter) {
                if (IBaseResource.class.isAssignableFrom(((ResourceParameter)next).getResourceType())) {
                    Class<?> parameterType = theMethod.getParameterTypes()[idx];
                    if (String.class.equals(parameterType) || EncodingEnum.class.equals(parameterType)) {
                        newParams.add(next);
                    } else {
                        Annotation[] parameterAnnotations = theMethod.getParameterAnnotations()[idx];
                        String description = ParametersUtil.extractDescription((Annotation[])parameterAnnotations);
                        List examples = ParametersUtil.extractExamples((Annotation[])parameterAnnotations);
                        OperationParameter parameter = new OperationParameter(theContext, "$validate", "resource", 0, 1, description, examples);
                        parameter.initializeTypes(theMethod, null, null, parameterType);
                        newParams.add(parameter);
                    }
                } else {
                    newParams.add(next);
                }
            } else {
                newParams.add(next);
            }
            ++idx;
        }
        this.setParameters(newParams);
    }
}

