/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.server.mail;

import ca.uhn.fhir.rest.server.mail.IMailSvc;
import ca.uhn.fhir.rest.server.mail.MailConfig;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.Validate;
import org.simplejavamail.MailException;
import org.simplejavamail.api.email.Email;
import org.simplejavamail.api.email.Recipient;
import org.simplejavamail.api.mailer.AsyncResponse;
import org.simplejavamail.api.mailer.Mailer;
import org.simplejavamail.api.mailer.config.TransportStrategy;
import org.simplejavamail.mailer.MailerBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MailSvc
implements IMailSvc {
    private static final Logger ourLog = LoggerFactory.getLogger(MailSvc.class);
    private final MailConfig myMailConfig;
    private final Mailer myMailer;

    public MailSvc(@Nonnull MailConfig theMailConfig) {
        Validate.notNull((Object)theMailConfig);
        this.myMailConfig = theMailConfig;
        this.myMailer = this.makeMailer(this.myMailConfig);
    }

    @Override
    public void sendMail(@Nonnull List<Email> theEmails) {
        Validate.notNull(theEmails);
        theEmails.forEach(theEmail -> this.send((Email)theEmail, new OnSuccess((Email)theEmail), new ErrorHandler((Email)theEmail)));
    }

    @Override
    public void sendMail(@Nonnull Email theEmail) {
        this.send(theEmail, new OnSuccess(theEmail), new ErrorHandler(theEmail));
    }

    @Override
    public void sendMail(@Nonnull Email theEmail, @Nonnull Runnable theOnSuccess, @Nonnull AsyncResponse.ExceptionConsumer theErrorHandler) {
        this.send(theEmail, theOnSuccess, theErrorHandler);
    }

    private void send(@Nonnull Email theEmail, @Nonnull Runnable theOnSuccess, @Nonnull AsyncResponse.ExceptionConsumer theErrorHandler) {
        Validate.notNull((Object)theEmail);
        Validate.notNull((Object)theOnSuccess);
        Validate.notNull((Object)theErrorHandler);
        try {
            AsyncResponse asyncResponse = this.myMailer.sendMail(theEmail, true);
            if (asyncResponse != null) {
                asyncResponse.onSuccess(theOnSuccess);
                asyncResponse.onException(theErrorHandler);
            }
        }
        catch (MailException e) {
            theErrorHandler.accept((Exception)((Object)e));
        }
    }

    @Nonnull
    private Mailer makeMailer(@Nonnull MailConfig theMailConfig) {
        ourLog.info("SMTP Mailer config Hostname:[{}] | Port:[{}] | Username:[{}] | TLS:[{}]", new Object[]{theMailConfig.getSmtpHostname(), theMailConfig.getSmtpPort(), theMailConfig.getSmtpUsername(), theMailConfig.isSmtpUseStartTLS()});
        return MailerBuilder.withSMTPServer((String)theMailConfig.getSmtpHostname(), (Integer)theMailConfig.getSmtpPort(), (String)theMailConfig.getSmtpUsername(), (String)theMailConfig.getSmtpPassword()).withTransportStrategy(theMailConfig.isSmtpUseStartTLS() ? TransportStrategy.SMTP_TLS : TransportStrategy.SMTP).buildMailer();
    }

    @Nonnull
    private String makeMessage(@Nonnull Email theEmail) {
        return " with subject [" + theEmail.getSubject() + "] and recipients [" + theEmail.getRecipients().stream().map(Recipient::getAddress).collect(Collectors.joining(",")) + "]";
    }

    private class OnSuccess
    implements Runnable {
        private final Email myEmail;

        private OnSuccess(Email theEmail) {
            this.myEmail = theEmail;
        }

        @Override
        public void run() {
            ourLog.info("Email sent" + MailSvc.this.makeMessage(this.myEmail));
        }
    }

    private class ErrorHandler
    implements AsyncResponse.ExceptionConsumer {
        private final Email myEmail;

        private ErrorHandler(Email theEmail) {
            this.myEmail = theEmail;
        }

        public void accept(Exception t) {
            ourLog.error("Email not sent" + MailSvc.this.makeMessage(this.myEmail), (Throwable)t);
        }
    }
}

