/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.server.interceptor.auth;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.RuntimeResourceDefinition;
import ca.uhn.fhir.context.RuntimeSearchParam;
import ca.uhn.fhir.context.support.IValidationSupport;
import ca.uhn.fhir.context.support.ValidationSupportContext;
import ca.uhn.fhir.context.support.ValueSetExpansionOptions;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.interceptor.api.Hook;
import ca.uhn.fhir.interceptor.api.Pointcut;
import ca.uhn.fhir.rest.api.QualifiedParamList;
import ca.uhn.fhir.rest.api.RestOperationTypeEnum;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.param.ParameterUtil;
import ca.uhn.fhir.rest.server.exceptions.AuthenticationException;
import ca.uhn.fhir.rest.server.exceptions.ForbiddenOperationException;
import ca.uhn.fhir.rest.server.interceptor.auth.AllowedCodeInValueSet;
import ca.uhn.fhir.rest.server.interceptor.auth.AuthorizedList;
import ca.uhn.fhir.rest.server.method.BaseMethodBinding;
import ca.uhn.fhir.rest.server.servlet.ServletRequestDetails;
import ca.uhn.fhir.rest.server.servlet.ServletSubRequestDetails;
import ca.uhn.fhir.rest.server.util.ServletRequestUtil;
import ca.uhn.fhir.util.BundleUtil;
import ca.uhn.fhir.util.FhirTerser;
import ca.uhn.fhir.util.UrlUtil;
import ca.uhn.fhir.util.ValidateUtil;
import ca.uhn.fhir.util.bundle.ModifiableBundleEntry;
import com.google.common.collect.ArrayListMultimap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseBundle;

public class SearchNarrowingInterceptor {
    public static final String POST_FILTERING_LIST_ATTRIBUTE_NAME = SearchNarrowingInterceptor.class.getName() + "_POST_FILTERING_LIST";
    private IValidationSupport myValidationSupport;
    private int myPostFilterLargeValueSetThreshold = 500;

    public void setPostFilterLargeValueSetThreshold(int thePostFilterLargeValueSetThreshold) {
        Validate.isTrue((thePostFilterLargeValueSetThreshold > 0 ? 1 : 0) != 0, (String)"thePostFilterLargeValueSetThreshold must be a positive integer", (Object[])new Object[0]);
        this.myPostFilterLargeValueSetThreshold = thePostFilterLargeValueSetThreshold;
    }

    public SearchNarrowingInterceptor setValidationSupport(IValidationSupport theValidationSupport) {
        this.myValidationSupport = theValidationSupport;
        return this;
    }

    protected AuthorizedList buildAuthorizedList(RequestDetails theRequestDetails) {
        return null;
    }

    @Hook(value=Pointcut.SERVER_INCOMING_REQUEST_POST_PROCESSED)
    public boolean hookIncomingRequestPostProcessed(RequestDetails theRequestDetails, HttpServletRequest theRequest, HttpServletResponse theResponse) throws AuthenticationException {
        List<AllowedCodeInValueSet> allowedCodeInValueSet;
        List<String> resources;
        Validate.isTrue((theRequestDetails.getRestOperationType() != RestOperationTypeEnum.SEARCH_SYSTEM ? 1 : 0) != 0);
        if (this.shouldSkipNarrowing(theRequestDetails)) {
            return true;
        }
        AuthorizedList authorizedList = this.buildAuthorizedList(theRequestDetails);
        if (authorizedList == null) {
            return true;
        }
        List<AllowedCodeInValueSet> postFilteringList = SearchNarrowingInterceptor.getPostFilteringList(theRequestDetails);
        if (authorizedList.getAllowedCodeInValueSets() != null) {
            postFilteringList.addAll(authorizedList.getAllowedCodeInValueSets());
        }
        FhirContext ctx = theRequestDetails.getServer().getFhirContext();
        RuntimeResourceDefinition resDef = ctx.getResourceDefinition(theRequestDetails.getResourceName());
        List<String> compartments = authorizedList.getAllowedCompartments();
        if (compartments != null) {
            Map<String, List<String>> parameterToOrValues = this.processResourcesOrCompartments(theRequestDetails, resDef, compartments, true);
            this.applyParametersToRequestDetails(theRequestDetails, parameterToOrValues, true);
        }
        if ((resources = authorizedList.getAllowedInstances()) != null) {
            Map<String, List<String>> parameterToOrValues = this.processResourcesOrCompartments(theRequestDetails, resDef, resources, false);
            this.applyParametersToRequestDetails(theRequestDetails, parameterToOrValues, true);
        }
        if ((allowedCodeInValueSet = authorizedList.getAllowedCodeInValueSets()) != null) {
            Map<String, List<String>> parameterToOrValues = this.processAllowedCodes(resDef, allowedCodeInValueSet);
            this.applyParametersToRequestDetails(theRequestDetails, parameterToOrValues, false);
        }
        return true;
    }

    private boolean shouldSkipNarrowing(RequestDetails theRequestDetails) {
        return theRequestDetails.getRestOperationType() != RestOperationTypeEnum.SEARCH_TYPE && !"$everything".equalsIgnoreCase(theRequestDetails.getOperation());
    }

    @Hook(value=Pointcut.SERVER_INCOMING_REQUEST_PRE_HANDLED)
    public void hookIncomingRequestPreHandled(ServletRequestDetails theRequestDetails, HttpServletRequest theRequest, HttpServletResponse theResponse) throws AuthenticationException {
        if (theRequestDetails.getRestOperationType() != RestOperationTypeEnum.TRANSACTION) {
            return;
        }
        IBaseBundle bundle = (IBaseBundle)theRequestDetails.getResource();
        FhirContext ctx = theRequestDetails.getFhirContext();
        BundleEntryUrlProcessor processor = new BundleEntryUrlProcessor(ctx, theRequestDetails, theRequest, theResponse);
        BundleUtil.processEntries((FhirContext)ctx, (IBaseBundle)bundle, (Consumer)processor);
    }

    private void applyParametersToRequestDetails(RequestDetails theRequestDetails, @Nullable Map<String, List<String>> theParameterToOrValues, boolean thePatientIdMode) {
        if (theParameterToOrValues != null) {
            HashMap<String, String[]> newParameters = new HashMap<String, String[]>(theRequestDetails.getParameters());
            for (Map.Entry<String, List<String>> nextEntry : theParameterToOrValues.entrySet()) {
                int i;
                String nextParamName = nextEntry.getKey();
                List<String> nextAllowedValues = nextEntry.getValue();
                if (!newParameters.containsKey(nextParamName)) {
                    String nextValuesJoined = ParameterUtil.escapeAndJoinOrList(nextAllowedValues);
                    String[] paramValues = new String[]{nextValuesJoined};
                    newParameters.put(nextParamName, paramValues);
                    continue;
                }
                String[] existingValues = (String[])newParameters.get(nextParamName);
                if (thePatientIdMode) {
                    List nextAllowedValueIds = nextAllowedValues.stream().map(t -> t.lastIndexOf("/") > -1 ? t.substring(t.lastIndexOf("/") + 1) : t).collect(Collectors.toList());
                    boolean restrictedExistingList = false;
                    for (i = 0; i < existingValues.length; ++i) {
                        String nextExistingValue = existingValues[i];
                        QualifiedParamList nextRequestedValues = QualifiedParamList.splitQueryStringByCommasIgnoreEscape(null, (String)nextExistingValue);
                        List nextPermittedValues = ListUtils.union((List)ListUtils.intersection((List)nextRequestedValues, nextAllowedValues), (List)ListUtils.intersection((List)nextRequestedValues, nextAllowedValueIds));
                        if (nextPermittedValues.size() <= 0) continue;
                        restrictedExistingList = true;
                        existingValues[i] = ParameterUtil.escapeAndJoinOrList((Collection)nextPermittedValues);
                    }
                    if (restrictedExistingList) continue;
                    throw new ForbiddenOperationException(Msg.code((int)2026) + "Value not permitted for parameter " + UrlUtil.escapeUrlParam((String)nextParamName));
                }
                int existingValuesCount = existingValues.length;
                String[] newValues = Arrays.copyOf(existingValues, existingValuesCount + nextAllowedValues.size());
                for (i = 0; i < nextAllowedValues.size(); ++i) {
                    newValues[existingValuesCount + i] = nextAllowedValues.get(i);
                }
                newParameters.put(nextParamName, newValues);
            }
            theRequestDetails.setParameters(newParameters);
        }
    }

    @Nullable
    private Map<String, List<String>> processResourcesOrCompartments(RequestDetails theRequestDetails, RuntimeResourceDefinition theResDef, Collection<String> theResourcesOrCompartments, boolean theAreCompartments) {
        HashMap<String, List> retVal = null;
        String lastCompartmentName = null;
        String lastSearchParamName = null;
        for (String nextCompartment : theResourcesOrCompartments) {
            Validate.isTrue((StringUtils.countMatches((CharSequence)nextCompartment, (char)'/') == 1 ? 1 : 0) != 0, (String)"Invalid compartment name (must be in form \"ResourceType/xxx\": %s", (Object[])new Object[]{nextCompartment});
            String compartmentName = nextCompartment.substring(0, nextCompartment.indexOf(47));
            String searchParamName = null;
            if (compartmentName.equalsIgnoreCase(lastCompartmentName)) {
                searchParamName = lastSearchParamName;
            } else {
                if (compartmentName.equalsIgnoreCase(theRequestDetails.getResourceName())) {
                    searchParamName = "_id";
                } else if (theAreCompartments) {
                    searchParamName = this.selectBestSearchParameterForCompartment(theRequestDetails, theResDef, compartmentName);
                }
                lastCompartmentName = compartmentName;
                lastSearchParamName = searchParamName;
            }
            if (searchParamName == null) continue;
            if (retVal == null) {
                retVal = new HashMap<String, List>();
            }
            List orValues = retVal.computeIfAbsent(searchParamName, t -> new ArrayList());
            orValues.add(nextCompartment);
        }
        return retVal;
    }

    @Nullable
    private Map<String, List<String>> processAllowedCodes(RuntimeResourceDefinition theResDef, List<AllowedCodeInValueSet> theAllowedCodeInValueSet) {
        HashMap<String, List> retVal = null;
        for (AllowedCodeInValueSet next : theAllowedCodeInValueSet) {
            String resourceName = next.getResourceName();
            String valueSetUrl = next.getValueSetUrl();
            ValidateUtil.isNotBlankOrThrowIllegalArgument((String)resourceName, (String)"Resource name supplied by SearchNarrowingInterceptor must not be null");
            ValidateUtil.isNotBlankOrThrowIllegalArgument((String)valueSetUrl, (String)"ValueSet URL supplied by SearchNarrowingInterceptor must not be null");
            if (!resourceName.equals(theResDef.getName()) || this.shouldHandleThroughConsentService(valueSetUrl)) continue;
            String paramName = next.isNegate() ? next.getSearchParameterName() + ":not-in" : next.getSearchParameterName() + ":in";
            if (retVal == null) {
                retVal = new HashMap<String, List>();
            }
            retVal.computeIfAbsent(paramName, k -> new ArrayList()).add(valueSetUrl);
        }
        return retVal;
    }

    private boolean shouldHandleThroughConsentService(String theValueSetUrl) {
        if (this.myValidationSupport != null && this.myPostFilterLargeValueSetThreshold != -1) {
            ValidationSupportContext ctx = new ValidationSupportContext(this.myValidationSupport);
            ValueSetExpansionOptions options = new ValueSetExpansionOptions();
            options.setCount(this.myPostFilterLargeValueSetThreshold);
            options.setIncludeHierarchy(false);
            IValidationSupport.ValueSetExpansionOutcome outcome = this.myValidationSupport.expandValueSet(ctx, options, theValueSetUrl);
            if (outcome != null && outcome.getValueSet() != null) {
                FhirTerser terser = this.myValidationSupport.getFhirContext().newTerser();
                List contains = terser.getValues((IBase)outcome.getValueSet(), "ValueSet.expansion.contains");
                int codeCount = contains.size();
                return codeCount >= this.myPostFilterLargeValueSetThreshold;
            }
        }
        return false;
    }

    private String selectBestSearchParameterForCompartment(RequestDetails theRequestDetails, RuntimeResourceDefinition theResDef, String compartmentName) {
        String searchParamName = null;
        Set<String> queryParameters = theRequestDetails.getParameters().keySet();
        List searchParams = theResDef.getSearchParamsForCompartmentName(compartmentName);
        if (searchParams.size() > 0) {
            Optional<RuntimeSearchParam> synonymInUse;
            String primarySearchParamName;
            Optional<RuntimeSearchParam> primarySearchParam = searchParams.stream().filter(t -> t.getName().equalsIgnoreCase(compartmentName)).findFirst();
            searchParamName = primarySearchParam.isPresent() ? (queryParameters.contains(primarySearchParamName = primarySearchParam.get().getName()) ? primarySearchParamName : ((synonymInUse = this.findSynonyms(searchParams, primarySearchParam.get()).stream().filter(t -> queryParameters.contains(t.getName())).findFirst()).isPresent() ? synonymInUse.get().getName() : primarySearchParamName)) : ((RuntimeSearchParam)searchParams.get(0)).getName();
        }
        return searchParamName;
    }

    private List<RuntimeSearchParam> findSynonyms(List<RuntimeSearchParam> searchParams, RuntimeSearchParam primarySearchParam) {
        String primaryBasePath = this.getBasePath(primarySearchParam);
        return searchParams.stream().filter(t -> primaryBasePath.equals(this.getBasePath((RuntimeSearchParam)t))).collect(Collectors.toList());
    }

    private String getBasePath(RuntimeSearchParam searchParam) {
        int qualifierIndex = searchParam.getPath().indexOf(".where");
        if (qualifierIndex == -1) {
            return searchParam.getPath();
        }
        return searchParam.getPath().substring(0, qualifierIndex);
    }

    static List<AllowedCodeInValueSet> getPostFilteringList(RequestDetails theRequestDetails) {
        List<AllowedCodeInValueSet> retVal = SearchNarrowingInterceptor.getPostFilteringListOrNull(theRequestDetails);
        if (retVal == null) {
            retVal = new ArrayList<AllowedCodeInValueSet>();
            theRequestDetails.setAttribute(POST_FILTERING_LIST_ATTRIBUTE_NAME, retVal);
        }
        return retVal;
    }

    static List<AllowedCodeInValueSet> getPostFilteringListOrNull(RequestDetails theRequestDetails) {
        return (List)theRequestDetails.getAttribute(POST_FILTERING_LIST_ATTRIBUTE_NAME);
    }

    private class BundleEntryUrlProcessor
    implements Consumer<ModifiableBundleEntry> {
        private final FhirContext myFhirContext;
        private final ServletRequestDetails myRequestDetails;
        private final HttpServletRequest myRequest;
        private final HttpServletResponse myResponse;

        public BundleEntryUrlProcessor(FhirContext theFhirContext, ServletRequestDetails theRequestDetails, HttpServletRequest theRequest, HttpServletResponse theResponse) {
            this.myFhirContext = theFhirContext;
            this.myRequestDetails = theRequestDetails;
            this.myRequest = theRequest;
            this.myResponse = theResponse;
        }

        @Override
        public void accept(ModifiableBundleEntry theModifiableBundleEntry) {
            ArrayListMultimap paramValues = ArrayListMultimap.create();
            String url = theModifiableBundleEntry.getRequestUrl();
            ServletSubRequestDetails subServletRequestDetails = ServletRequestUtil.getServletSubRequestDetails(this.myRequestDetails, url, (ArrayListMultimap<String, String>)paramValues);
            BaseMethodBinding<?> method = subServletRequestDetails.getServer().determineResourceMethod(subServletRequestDetails, url);
            RestOperationTypeEnum restOperationType = method.getRestOperationType();
            subServletRequestDetails.setRestOperationType(restOperationType);
            SearchNarrowingInterceptor.this.hookIncomingRequestPostProcessed(subServletRequestDetails, this.myRequest, this.myResponse);
            theModifiableBundleEntry.setRequestUrl(this.myFhirContext, ServletRequestUtil.extractUrl(subServletRequestDetails));
        }
    }
}

