/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.batch.config;

import org.springframework.batch.core.configuration.annotation.DefaultBatchConfigurer;
import org.springframework.batch.core.explore.JobExplorer;
import org.springframework.batch.core.explore.support.MapJobExplorerFactoryBean;
import org.springframework.batch.core.launch.JobLauncher;
import org.springframework.batch.core.launch.support.SimpleJobLauncher;
import org.springframework.batch.core.repository.JobRepository;
import org.springframework.batch.core.repository.support.MapJobRepositoryFactoryBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.core.task.TaskExecutor;
import org.springframework.transaction.PlatformTransactionManager;

public class NonPersistedBatchConfigurer
extends DefaultBatchConfigurer {
    @Autowired
    @Qualifier(value="hapiTransactionManager")
    private PlatformTransactionManager myHapiPlatformTransactionManager;
    @Autowired
    @Qualifier(value="jobLaunchingTaskExecutor")
    private TaskExecutor myTaskExecutor;
    private MapJobRepositoryFactoryBean myJobRepositoryFactory;

    public PlatformTransactionManager getTransactionManager() {
        return this.myHapiPlatformTransactionManager;
    }

    protected JobRepository createJobRepository() throws Exception {
        MapJobRepositoryFactoryBean factory = new MapJobRepositoryFactoryBean();
        factory.setTransactionManager(this.getTransactionManager());
        factory.afterPropertiesSet();
        this.myJobRepositoryFactory = factory;
        return factory.getObject();
    }

    public JobExplorer createJobExplorer() throws Exception {
        MapJobExplorerFactoryBean jobExplorerFactoryBean = new MapJobExplorerFactoryBean(this.myJobRepositoryFactory);
        jobExplorerFactoryBean.afterPropertiesSet();
        return jobExplorerFactoryBean.getObject();
    }

    protected JobLauncher createJobLauncher() throws Exception {
        SimpleJobLauncher launcher = new SimpleJobLauncher();
        launcher.setTaskExecutor(this.myTaskExecutor);
        launcher.setJobRepository(this.getJobRepository());
        launcher.afterPropertiesSet();
        return launcher;
    }
}

