/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.util;

import ca.uhn.fhir.context.ConfigurationException;
import ca.uhn.fhir.i18n.Msg;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReflectionUtil {
    public static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    public static final Class<?>[] EMPTY_CLASS_ARRAY = new Class[0];
    private static final ConcurrentHashMap<String, Object> ourFhirServerVersions = new ConcurrentHashMap();
    private static final Logger ourLog = LoggerFactory.getLogger(ReflectionUtil.class);

    private ReflectionUtil() {
    }

    public static List<Method> getDeclaredMethods(Class<?> theClazz) {
        return ReflectionUtil.getDeclaredMethods(theClazz, false);
    }

    public static List<Method> getDeclaredMethods(Class<?> theClazz, boolean theIncludeMethodsFromSuperclasses) {
        HashMap<String, Method> foundMethods = new HashMap<String, Method>();
        ReflectionUtil.populateDeclaredMethodsMap(theClazz, foundMethods, theIncludeMethodsFromSuperclasses);
        ArrayList<Method> retVal = new ArrayList<Method>(foundMethods.values());
        retVal.sort(Comparator.comparing(ReflectionUtil::describeMethodInSortFriendlyWay));
        return retVal;
    }

    private static void populateDeclaredMethodsMap(Class<?> theClazz, HashMap<String, Method> foundMethods, boolean theIncludeMethodsFromSuperclasses) {
        Method[] declaredMethods;
        for (Method next : declaredMethods = theClazz.getDeclaredMethods()) {
            String description;
            if (Modifier.isAbstract(next.getModifiers()) || Modifier.isStatic(next.getModifiers()) || Modifier.isPrivate(next.getModifiers()) || foundMethods.containsKey(description = next.getName() + Arrays.asList(next.getParameterTypes()))) continue;
            try {
                Method method = theClazz.getMethod(next.getName(), next.getParameterTypes());
                foundMethods.put(description, method);
            }
            catch (NoSuchMethodException | SecurityException e) {
                foundMethods.put(description, next);
            }
        }
        if (theIncludeMethodsFromSuperclasses && !theClazz.getSuperclass().equals(Object.class)) {
            ReflectionUtil.populateDeclaredMethodsMap(theClazz.getSuperclass(), foundMethods, theIncludeMethodsFromSuperclasses);
        }
    }

    public static String describeMethodInSortFriendlyWay(Method theMethod) {
        StringBuilder b = new StringBuilder();
        b.append(theMethod.getName());
        b.append(" returns(");
        b.append(theMethod.getReturnType().getName());
        b.append(") params(");
        Class<?>[] parameterTypes = theMethod.getParameterTypes();
        int parameterTypesLength = parameterTypes.length;
        for (int i = 0; i < parameterTypesLength; ++i) {
            if (i > 0) {
                b.append(", ");
            }
            Class<?> next = parameterTypes[i];
            b.append(next.getName());
        }
        b.append(")");
        return b.toString();
    }

    public static Class<?> getGenericCollectionTypeOfField(Field next) {
        ParameterizedType collectionType = (ParameterizedType)next.getGenericType();
        return ReflectionUtil.getGenericCollectionTypeOf(collectionType.getActualTypeArguments()[0]);
    }

    public static Class<?> getGenericCollectionTypeOfFieldWithSecondOrderForList(Field next) {
        if (!List.class.isAssignableFrom(next.getType())) {
            return ReflectionUtil.getGenericCollectionTypeOfField(next);
        }
        ParameterizedType collectionType = (ParameterizedType)next.getGenericType();
        Type firstArg = collectionType.getActualTypeArguments()[0];
        if (ParameterizedType.class.isAssignableFrom(firstArg.getClass())) {
            ParameterizedType pt = (ParameterizedType)firstArg;
            Type pt2 = pt.getActualTypeArguments()[0];
            return (Class)pt2;
        }
        Class type = (Class)firstArg;
        return type;
    }

    public static Class<?> getGenericCollectionTypeOfMethodParameter(Method theMethod, int theParamIndex) {
        Type genericParameterType = theMethod.getGenericParameterTypes()[theParamIndex];
        if (Class.class.equals((Object)genericParameterType) || Class.class.equals(genericParameterType.getClass())) {
            return null;
        }
        ParameterizedType collectionType = (ParameterizedType)genericParameterType;
        return ReflectionUtil.getGenericCollectionTypeOf(collectionType.getActualTypeArguments()[0]);
    }

    public static Class<?> getGenericCollectionTypeOfMethodReturnType(Method theMethod) {
        Type genericReturnType = theMethod.getGenericReturnType();
        if (!(genericReturnType instanceof ParameterizedType)) {
            return null;
        }
        ParameterizedType collectionType = (ParameterizedType)genericReturnType;
        return ReflectionUtil.getGenericCollectionTypeOf(collectionType.getActualTypeArguments()[0]);
    }

    private static Class<?> getGenericCollectionTypeOf(Type theType) {
        Class type;
        if (ParameterizedType.class.isAssignableFrom(theType.getClass())) {
            ParameterizedType pt = (ParameterizedType)theType;
            type = (Class)pt.getRawType();
        } else {
            if (theType instanceof TypeVariable) {
                Type decl = ((TypeVariable)theType).getBounds()[0];
                return (Class)decl;
            }
            if (theType instanceof WildcardType) {
                Type decl = ((WildcardType)theType).getUpperBounds()[0];
                return (Class)decl;
            }
            type = (Class)theType;
        }
        return type;
    }

    public static boolean isInstantiable(Class<?> theType) {
        return !theType.isInterface() && !Modifier.isAbstract(theType.getModifiers());
    }

    public static <T> T newInstance(Class<T> theType) {
        Validate.notNull(theType, (String)"theType must not be null", (Object[])new Object[0]);
        try {
            return theType.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new ConfigurationException(Msg.code(1784) + "Failed to instantiate " + theType.getName(), e);
        }
    }

    public static <T> T newInstance(Class<T> theType, Class<?> theArgumentType, Object theArgument) {
        Validate.notNull(theType, (String)"theType must not be null", (Object[])new Object[0]);
        try {
            Constructor<T> constructor = theType.getConstructor(theArgumentType);
            return constructor.newInstance(theArgument);
        }
        catch (Exception e) {
            throw new ConfigurationException(Msg.code(1785) + "Failed to instantiate " + theType.getName(), e);
        }
    }

    public static Object newInstanceOfFhirServerType(String theType) {
        String errorMessage = "Unable to instantiate server framework. Please make sure that hapi-fhir-server library is on your classpath!";
        String wantedType = "ca.uhn.fhir.rest.api.server.IFhirVersionServer";
        return ReflectionUtil.newInstanceOfType(theType, theType, errorMessage, wantedType, new Class[0], new Object[0]);
    }

    private static Object newInstanceOfType(String theKey, String theType, String errorMessage, String wantedType, Class<?>[] theParameterArgTypes, Object[] theConstructorArgs) {
        Object fhirServerVersion = ourFhirServerVersions.get(theKey);
        if (fhirServerVersion == null) {
            try {
                Class<?> type = Class.forName(theType);
                Class<?> serverType = Class.forName(wantedType);
                Validate.isTrue((boolean)serverType.isAssignableFrom(type));
                fhirServerVersion = type.getConstructor(theParameterArgTypes).newInstance(theConstructorArgs);
            }
            catch (Exception e) {
                throw new ConfigurationException(Msg.code(1786) + errorMessage, e);
            }
            ourFhirServerVersions.put(theKey, fhirServerVersion);
        }
        return fhirServerVersion;
    }

    public static <T> T newInstanceOrReturnNull(String theClassName, Class<T> theType) {
        return ReflectionUtil.newInstanceOrReturnNull(theClassName, theType, EMPTY_CLASS_ARRAY, EMPTY_OBJECT_ARRAY);
    }

    public static <T> T newInstanceOrReturnNull(String theClassName, Class<T> theType, Class<?>[] theArgTypes, Object[] theArgs) {
        try {
            Class<?> clazz = Class.forName(theClassName);
            if (!theType.isAssignableFrom(clazz)) {
                throw new ConfigurationException(Msg.code(1787) + theClassName + " is not assignable to " + theType);
            }
            return (T)clazz.getConstructor(theArgTypes).newInstance(theArgs);
        }
        catch (ConfigurationException e) {
            throw e;
        }
        catch (Exception e) {
            ourLog.info("Failed to instantiate {}: {}", (Object)theClassName, (Object)e.toString());
            return null;
        }
    }

    public static boolean typeExists(String theName) {
        try {
            Class.forName(theName);
            return true;
        }
        catch (ClassNotFoundException theE) {
            return false;
        }
    }
}

