/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.util;

import ca.uhn.fhir.context.BaseRuntimeChildDefinition;
import ca.uhn.fhir.context.BaseRuntimeElementDefinition;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.RuntimeResourceDefinition;
import ca.uhn.fhir.model.primitive.IdDt;
import java.util.Objects;
import org.apache.commons.lang3.Validate;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.instance.model.api.IBaseBundle;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IPrimitiveType;

public class BundleBuilder {
    private final FhirContext myContext;
    private final IBaseBundle myBundle;
    private final RuntimeResourceDefinition myBundleDef;
    private final BaseRuntimeChildDefinition myEntryChild;
    private final BaseRuntimeChildDefinition myMetaChild;
    private final BaseRuntimeChildDefinition mySearchChild;
    private final BaseRuntimeElementDefinition<?> myEntryDef;
    private final BaseRuntimeElementDefinition<?> myMetaDef;
    private final BaseRuntimeElementDefinition mySearchDef;
    private final BaseRuntimeChildDefinition myEntryResourceChild;
    private final BaseRuntimeChildDefinition myEntryFullUrlChild;
    private final BaseRuntimeChildDefinition myEntryRequestChild;
    private final BaseRuntimeElementDefinition<?> myEntryRequestDef;
    private final BaseRuntimeChildDefinition myEntryRequestUrlChild;
    private final BaseRuntimeChildDefinition myEntryRequestMethodChild;
    private final BaseRuntimeElementDefinition<?> myEntryRequestMethodDef;
    private final BaseRuntimeChildDefinition myEntryRequestIfNoneExistChild;

    public BundleBuilder(FhirContext theContext) {
        this.myContext = theContext;
        this.myBundleDef = this.myContext.getResourceDefinition("Bundle");
        this.myBundle = (IBaseBundle)this.myBundleDef.newInstance();
        this.myEntryChild = this.myBundleDef.getChildByName("entry");
        this.myEntryDef = this.myEntryChild.getChildByName("entry");
        this.mySearchChild = this.myEntryDef.getChildByName("search");
        this.mySearchDef = this.mySearchChild.getChildByName("search");
        this.myMetaChild = this.myBundleDef.getChildByName("meta");
        this.myMetaDef = this.myMetaChild.getChildByName("meta");
        this.myEntryResourceChild = this.myEntryDef.getChildByName("resource");
        this.myEntryFullUrlChild = this.myEntryDef.getChildByName("fullUrl");
        this.myEntryRequestChild = this.myEntryDef.getChildByName("request");
        this.myEntryRequestDef = this.myEntryRequestChild.getChildByName("request");
        this.myEntryRequestUrlChild = this.myEntryRequestDef.getChildByName("url");
        this.myEntryRequestMethodChild = this.myEntryRequestDef.getChildByName("method");
        this.myEntryRequestMethodDef = this.myEntryRequestMethodChild.getChildByName("method");
        this.myEntryRequestIfNoneExistChild = this.myEntryRequestDef.getChildByName("ifNoneExist");
    }

    public BundleBuilder setBundleField(String theFieldName, String theFieldValue) {
        BaseRuntimeChildDefinition typeChild = this.myBundleDef.getChildByName(theFieldName);
        Validate.notNull((Object)typeChild, (String)"Unable to find field %s", (Object[])new Object[]{theFieldName});
        IPrimitiveType type = (IPrimitiveType)typeChild.getChildByName(theFieldName).newInstance(typeChild.getInstanceConstructorArguments());
        type.setValueAsString(theFieldValue);
        typeChild.getMutator().setValue(this.myBundle, type);
        return this;
    }

    public BundleBuilder setSearchField(IBase theSearch, String theFieldName, String theFieldValue) {
        BaseRuntimeChildDefinition typeChild = this.mySearchDef.getChildByName(theFieldName);
        Validate.notNull((Object)typeChild, (String)"Unable to find field %s", (Object[])new Object[]{theFieldName});
        IPrimitiveType type = (IPrimitiveType)typeChild.getChildByName(theFieldName).newInstance(typeChild.getInstanceConstructorArguments());
        type.setValueAsString(theFieldValue);
        typeChild.getMutator().setValue(theSearch, type);
        return this;
    }

    public BundleBuilder setSearchField(IBase theSearch, String theFieldName, IPrimitiveType<?> theFieldValue) {
        BaseRuntimeChildDefinition typeChild = this.mySearchDef.getChildByName(theFieldName);
        Validate.notNull((Object)typeChild, (String)"Unable to find field %s", (Object[])new Object[]{theFieldName});
        typeChild.getMutator().setValue(theSearch, theFieldValue);
        return this;
    }

    public UpdateBuilder addTransactionUpdateEntry(IBaseResource theResource) {
        this.setBundleField("type", "transaction");
        IBase request = this.addEntryAndReturnRequest(theResource);
        IPrimitiveType url = (IPrimitiveType)this.myContext.getElementDefinition("uri").newInstance();
        String resourceType = this.myContext.getResourceType(theResource);
        url.setValueAsString(theResource.getIdElement().toUnqualifiedVersionless().withResourceType(resourceType).getValue());
        this.myEntryRequestUrlChild.getMutator().setValue(request, url);
        IPrimitiveType method = (IPrimitiveType)this.myEntryRequestMethodDef.newInstance(this.myEntryRequestMethodChild.getInstanceConstructorArguments());
        method.setValueAsString("PUT");
        this.myEntryRequestMethodChild.getMutator().setValue(request, method);
        return new UpdateBuilder(url);
    }

    public CreateBuilder addTransactionCreateEntry(IBaseResource theResource) {
        this.setBundleField("type", "transaction");
        IBase request = this.addEntryAndReturnRequest(theResource);
        String resourceType = this.myContext.getResourceType(theResource);
        IPrimitiveType url = (IPrimitiveType)this.myContext.getElementDefinition("uri").newInstance();
        url.setValueAsString(resourceType);
        this.myEntryRequestUrlChild.getMutator().setValue(request, url);
        IPrimitiveType method = (IPrimitiveType)this.myEntryRequestMethodDef.newInstance(this.myEntryRequestMethodChild.getInstanceConstructorArguments());
        method.setValueAsString("POST");
        this.myEntryRequestMethodChild.getMutator().setValue(request, method);
        return new CreateBuilder(request);
    }

    public void addTransactionDeleteEntry(IBaseResource theResource) {
        String resourceType = this.myContext.getResourceType(theResource);
        String idPart = theResource.getIdElement().toUnqualifiedVersionless().getIdPart();
        this.addTransactionDeleteEntry(resourceType, idPart);
    }

    public void addTransactionDeleteEntry(String theResourceType, String theIdPart) {
        this.setBundleField("type", "transaction");
        IBase request = this.addEntryAndReturnRequest();
        IdDt idDt = new IdDt(theIdPart);
        IPrimitiveType url = (IPrimitiveType)this.myContext.getElementDefinition("uri").newInstance();
        url.setValueAsString(idDt.toUnqualifiedVersionless().withResourceType(theResourceType).getValue());
        this.myEntryRequestUrlChild.getMutator().setValue(request, url);
        IPrimitiveType method = (IPrimitiveType)this.myEntryRequestMethodDef.newInstance(this.myEntryRequestMethodChild.getInstanceConstructorArguments());
        method.setValueAsString("DELETE");
        this.myEntryRequestMethodChild.getMutator().setValue(request, method);
    }

    public void addCollectionEntry(IBaseResource theResource) {
        this.setType("collection");
        this.addEntryAndReturnRequest(theResource);
    }

    public IBase addEntry() {
        Object entry = this.myEntryDef.newInstance();
        this.myEntryChild.getMutator().addValue(this.myBundle, (IBase)entry);
        return entry;
    }

    public IBaseBackboneElement addSearch(IBase entry) {
        Object searchInstance = this.mySearchDef.newInstance();
        this.mySearchChild.getMutator().setValue(entry, (IBase)searchInstance);
        return (IBaseBackboneElement)searchInstance;
    }

    public IBase addEntryAndReturnRequest(IBaseResource theResource) {
        Validate.notNull((Object)theResource, (String)"theResource must not be null", (Object[])new Object[0]);
        IBase entry = this.addEntry();
        IPrimitiveType fullUrl = (IPrimitiveType)this.myContext.getElementDefinition("uri").newInstance();
        fullUrl.setValueAsString(theResource.getIdElement().getValue());
        this.myEntryFullUrlChild.getMutator().setValue(entry, fullUrl);
        this.myEntryResourceChild.getMutator().setValue(entry, theResource);
        Object request = this.myEntryRequestDef.newInstance();
        this.myEntryRequestChild.getMutator().setValue(entry, (IBase)request);
        return request;
    }

    public IBase addEntryAndReturnRequest() {
        IBase entry = this.addEntry();
        Object request = this.myEntryRequestDef.newInstance();
        this.myEntryRequestChild.getMutator().setValue(entry, (IBase)request);
        return request;
    }

    public IBaseBundle getBundle() {
        return this.myBundle;
    }

    public BundleBuilder setMetaField(String theFieldName, IBase theFieldValue) {
        BaseRuntimeChildDefinition.IMutator mutator = this.myMetaDef.getChildByName(theFieldName).getMutator();
        mutator.setValue(this.myBundle.getMeta(), theFieldValue);
        return this;
    }

    public void addToEntry(IBase theEntry, String theEntryChildName, IBase theValue) {
        this.addToBase(theEntry, theEntryChildName, theValue, this.myEntryDef);
    }

    public void addToSearch(IBase theSearch, String theSearchFieldName, IBase theSearchFieldValue) {
        this.addToBase(theSearch, theSearchFieldName, theSearchFieldValue, this.mySearchDef);
    }

    private void addToBase(IBase theBase, String theSearchChildName, IBase theValue, BaseRuntimeElementDefinition mySearchDef) {
        BaseRuntimeChildDefinition defn = mySearchDef.getChildByName(theSearchChildName);
        Validate.notNull((Object)defn, (String)"Unable to get child definition %s from %s", (Object[])new Object[]{theSearchChildName, theBase});
        defn.getMutator().addValue(theBase, theValue);
    }

    public <T> IPrimitiveType<T> newPrimitive(String theTypeName) {
        BaseRuntimeElementDefinition<?> primitiveDefinition = this.myContext.getElementDefinition(theTypeName);
        Validate.notNull(primitiveDefinition, (String)"Unable to find definition for %s", (Object[])new Object[]{theTypeName});
        return (IPrimitiveType)primitiveDefinition.newInstance();
    }

    public <T> IPrimitiveType<T> newPrimitive(String theTypeName, T theInitialValue) {
        IPrimitiveType<T> retVal = this.newPrimitive(theTypeName);
        retVal.setValue(theInitialValue);
        return retVal;
    }

    public void setType(String theType) {
        this.setBundleField("type", theType);
    }

    public static class UpdateBuilder {
        private final IPrimitiveType<?> myUrl;

        public UpdateBuilder(IPrimitiveType<?> theUrl) {
            this.myUrl = theUrl;
        }

        public void conditional(String theConditionalUrl) {
            this.myUrl.setValueAsString(theConditionalUrl);
        }
    }

    public class CreateBuilder {
        private final IBase myRequest;

        public CreateBuilder(IBase theRequest) {
            this.myRequest = theRequest;
        }

        public void conditional(String theConditionalUrl) {
            BaseRuntimeElementDefinition<?> stringDefinition = Objects.requireNonNull(BundleBuilder.this.myContext.getElementDefinition("string"));
            IPrimitiveType ifNoneExist = (IPrimitiveType)stringDefinition.newInstance();
            ifNoneExist.setValueAsString(theConditionalUrl);
            BundleBuilder.this.myEntryRequestIfNoneExistChild.getMutator().setValue(this.myRequest, ifNoneExist);
        }
    }
}

