/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.api;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;

public enum PatchTypeEnum {
    JSON_PATCH("application/json-patch+json"),
    XML_PATCH("application/xml-patch+xml"),
    FHIR_PATCH_JSON("application/fhir+json"),
    FHIR_PATCH_XML("application/fhir+xml");

    private static volatile Map<String, PatchTypeEnum> ourContentTypeToPatchType;
    private final String myContentType;

    private PatchTypeEnum(String theContentType) {
        this.myContentType = theContentType;
    }

    public String getContentType() {
        return this.myContentType;
    }

    @Nonnull
    public static PatchTypeEnum forContentTypeOrThrowInvalidRequestException(FhirContext theContext, String theContentType) {
        PatchTypeEnum retVal;
        String contentType = StringUtils.defaultString((String)theContentType);
        int semiColonIdx = contentType.indexOf(59);
        if (semiColonIdx != -1) {
            contentType = theContentType.substring(0, semiColonIdx);
        }
        contentType = contentType.trim();
        Map<String, PatchTypeEnum> map = ourContentTypeToPatchType;
        if (map == null) {
            map = new HashMap<String, PatchTypeEnum>();
            for (PatchTypeEnum next : PatchTypeEnum.values()) {
                map.put(next.getContentType(), next);
            }
            ourContentTypeToPatchType = map;
        }
        if ((retVal = map.get(contentType)) == null) {
            if (StringUtils.isBlank((CharSequence)contentType)) {
                String msg = theContext.getLocalizer().getMessage(PatchTypeEnum.class, "missingPatchContentType", new Object[0]);
                throw new InvalidRequestException(Msg.code(1964) + msg);
            }
            String msg = theContext.getLocalizer().getMessageSanitized(PatchTypeEnum.class, "invalidPatchContentType", contentType);
            throw new InvalidRequestException(Msg.code(1965) + msg);
        }
        return retVal;
    }
}

