/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.api;

import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.valueset.BundleTypeEnum;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public class BundleLinks {
    public final String serverBase;
    public final boolean prettyPrint;
    public final BundleTypeEnum bundleType;
    private final List<Include> includes;
    private String self;
    private String next;
    private String prev;

    public BundleLinks(String theServerBase, Set<Include> theIncludes, boolean thePrettyPrint, BundleTypeEnum theBundleType) {
        this.serverBase = theServerBase;
        this.includes = theIncludes == null ? null : new ArrayList<Include>(theIncludes);
        this.prettyPrint = thePrettyPrint;
        this.bundleType = theBundleType;
    }

    public String getSelf() {
        return this.self;
    }

    public BundleLinks setSelf(String theSelf) {
        this.self = theSelf;
        return this;
    }

    public String getNext() {
        return this.next;
    }

    public BundleLinks setNext(String theNext) {
        this.next = theNext;
        return this;
    }

    public String getPrev() {
        return this.prev;
    }

    public BundleLinks setPrev(String thePrev) {
        this.prev = thePrev;
        return this;
    }

    public Collection<Include> getIncludes() {
        if (this.includes == null) {
            return null;
        }
        return Collections.unmodifiableList(this.includes);
    }
}

