/*
 * Decompiled with CFR 0.152.
 */
package br.gov.lexml.eta.etaservices.printing.pdf;

import br.gov.lexml.eta.etaservices.emenda.Emenda;
import br.gov.lexml.eta.etaservices.printing.pdf.FOPProcessor;
import br.gov.lexml.eta.etaservices.printing.pdf.PdfGenerator;
import br.gov.lexml.eta.etaservices.printing.pdf.VelocityTemplateProcessorFactory;
import br.gov.lexml.eta.etaservices.printing.xml.EmendaXmlMarshaller;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.stream.Collectors;

public class PdfGeneratorBean
implements PdfGenerator {
    private final VelocityTemplateProcessorFactory templateProcessorFactory;
    private final EmendaXmlMarshaller emendaXmlMarshaller;

    public PdfGeneratorBean(VelocityTemplateProcessorFactory templateProcessorFactory, EmendaXmlMarshaller emendaXmlMarshaller) {
        this.templateProcessorFactory = templateProcessorFactory;
        this.emendaXmlMarshaller = emendaXmlMarshaller;
    }

    @Override
    public void generate(Emenda emenda, OutputStream outputStream) throws IOException {
        String xml = this.emendaXmlMarshaller.toXml(emenda);
        String templateResult = this.templateProcessorFactory.get().getTemplateResult(emenda);
        List<ByteArrayInputStream> anexos = this.getAnexos(emenda);
        new FOPProcessor().processFOP(outputStream, templateResult, xml, anexos);
    }

    private List<ByteArrayInputStream> getAnexos(Emenda emenda) {
        if (emenda.getAnexos() != null) {
            return emenda.getAnexos().parallelStream().map(anexo -> Base64.getDecoder().decode(anexo.getBase64())).map(anexo -> new ByteArrayInputStream((byte[])anexo)).collect(Collectors.toList());
        }
        return new ArrayList<ByteArrayInputStream>();
    }
}

