/*
 * Decompiled with CFR 0.152.
 */
package br.gov.lexml.eta.etaservices.printing.pdf;

import br.gov.lexml.eta.etaservices.printing.pdf.FOHelper;
import br.gov.lexml.pdfa.PDFA;
import br.gov.lexml.pdfa.PDFAttachmentFile;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXResult;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.apps.Fop;
import org.apache.fop.apps.FopConfParser;
import org.apache.fop.apps.FopFactory;
import org.apache.fop.apps.FopFactoryBuilder;
import org.apache.fop.pdf.PDFAMode;
import org.apache.pdfbox.io.MemoryUsageSetting;
import org.apache.pdfbox.multipdf.PDFMergerUtility;
import org.apache.xmlgraphics.io.Resource;
import org.apache.xmlgraphics.io.ResourceResolver;
import org.dom4j.io.DocumentSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FOPProcessor {
    private static final Logger log = LoggerFactory.getLogger(FOPProcessor.class);
    private static FopFactory fopFactory;
    private static Map<String, byte[]> fontes;

    private static void carregaFonte(String fonte) throws FileNotFoundException, IOException {
        InputStream is = FOPProcessor.class.getResourceAsStream("/pdfa-fonts/" + fonte);
        fontes.put(fonte, IOUtils.toByteArray((InputStream)is));
    }

    public void processFOP(OutputStream outputStream, String xslFo, String emendaXML) {
        this.processFOP(outputStream, xslFo, emendaXML, new ArrayList<ByteArrayInputStream>());
    }

    public void processFOP(OutputStream outputStream, String xslFo, String emendaXML, List<ByteArrayInputStream> anexos) {
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            FOUserAgent foUserAgent = fopFactory.newFOUserAgent();
            FOHelper helper = new FOHelper(xslFo);
            DocumentSource src = new DocumentSource(helper.getFOPDocumentWithoutXmpmeta());
            if (helper.isPDFAMode()) {
                foUserAgent.getRendererOptions().put("pdf-a-mode", PDFAMode.PDFA_3B.getName());
                foUserAgent.setAccessibility(true);
                String cmpCreateDate = helper.getCmpCreateDate();
                if (cmpCreateDate == null) {
                    log.info("cmpCreateDate is null");
                } else {
                    Date date = Date.from(ZonedDateTime.parse(cmpCreateDate).toInstant());
                    foUserAgent.setCreationDate(date);
                }
            }
            Fop fop = fopFactory.newFop("application/pdf", foUserAgent, (OutputStream)out);
            SAXResult res = new SAXResult(fop.getDefaultHandler());
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.transform((Source)src, res);
            byte[] data = out.toByteArray();
            ByteArrayInputStream inputStream = new ByteArrayInputStream(data);
            boolean temAnexos = !anexos.isEmpty();
            OutputStream outPdfa = temAnexos ? new ByteArrayOutputStream() : outputStream;
            PDFA pdfa = PDFA.getNewInstance((OutputStream)outPdfa, (InputStream)inputStream, (String)helper.getPDFAPart(), (String)helper.getPDFAConformance());
            if (pdfa == null) {
                log.error("Could not find a PDF/A part " + helper.getPDFAPart() + ", conformance " + helper.getPDFAConformance() + " constructor on PDFA class.");
            } else {
                pdfa.addXMP(helper.getXmpmeta().getBytes());
                pdfa.addAttachments(new PDFAttachmentFile[]{new PDFAttachmentFile(emendaXML.getBytes(), "emenda.xml", "text/xml", helper.getCmpCreateDate(), PDFAttachmentFile.AFRelationShip.SOURCE)});
                pdfa.setVersion(PDFA.PDFVersion.PDF_VERSION_1_7);
                pdfa.close();
                if (temAnexos) {
                    PDFMergerUtility merger = new PDFMergerUtility();
                    merger.addSource((InputStream)new ByteArrayInputStream(((ByteArrayOutputStream)outPdfa).toByteArray()));
                    anexos.forEach(anexo -> merger.addSource((InputStream)anexo));
                    merger.setDestinationStream(outputStream);
                    merger.mergeDocuments(MemoryUsageSetting.setupMainMemoryOnly());
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Error processing FOP. " + e.getMessage(), e);
        }
    }

    static {
        fontes = new HashMap<String, byte[]>();
        try {
            FOPProcessor.carregaFonte("GenBasB.ttf");
            FOPProcessor.carregaFonte("GenBasBI.ttf");
            FOPProcessor.carregaFonte("GenBasI.ttf");
            FOPProcessor.carregaFonte("GenBasR.ttf");
            InputStream xconf = FOPProcessor.class.getResourceAsStream("/fop.xconf");
            UriResolver resolver = new UriResolver();
            FopConfParser parser = new FopConfParser(xconf, new URI("file://./"), (ResourceResolver)resolver);
            FopFactoryBuilder builder = parser.getFopFactoryBuilder();
            fopFactory = builder.build();
        }
        catch (Exception e) {
            log.error("N\u00e3o foi poss\u00edvel configurar o FOP.", (Throwable)e);
        }
    }

    static class UriResolver
    implements ResourceResolver {
        UriResolver() {
        }

        public OutputStream getOutputStream(URI arg0) {
            return null;
        }

        public Resource getResource(URI uri) {
            String strUri = uri.toString().replaceAll("^file://\\./", "");
            try {
                return new Resource("image/x-afp+truetype", (InputStream)new ByteArrayInputStream(fontes.get(strUri)));
            }
            catch (Exception e) {
                log.error("Fonte " + strUri + " n\u00e3o encontrada.");
                return null;
            }
        }
    }
}

