/*
 * Decompiled with CFR 0.152.
 */
package br.com.six2six.fixturefactory.util;

import com.thoughtworks.paranamer.AdaptiveParanamer;
import com.thoughtworks.paranamer.Paranamer;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.vidageek.mirror.dsl.Mirror;
import net.vidageek.mirror.list.dsl.Matcher;
import org.apache.commons.beanutils.BeanUtilsBean;
import org.apache.commons.beanutils.PropertyUtilsBean;
import org.apache.commons.lang.StringUtils;

public class ReflectionUtils {
    public static final String CGLIB_CLASS_SEPARATOR = "$$";
    private static final String NO_SUCH_ATTRIBUTE_MESSAGE = "%s-> No such attribute: %s[%s]";

    public static <T> T cast(Object source) {
        try {
            return (T)(source == null ? null : source);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Cannot convert to type");
        }
    }

    public static <T> T invokeGetter(Object bean, String attribute) {
        return ReflectionUtils.invokeGetter(bean, attribute, true);
    }

    public static <T> T invokeGetter(Object bean, String attribute, boolean fail) {
        try {
            return (T)ReflectionUtils.getPropertyUtilsBean().getProperty(bean, attribute);
        }
        catch (Exception e) {
            if (fail) {
                throw new IllegalArgumentException("Error invoking get method for " + attribute);
            }
            return null;
        }
    }

    public static Object invokeRecursiveGetter(Object bean, String objectsPath) {
        Object lastValue = null;
        Object lastBean = bean;
        for (String propertyItem : objectsPath.split("\\.")) {
            lastValue = ReflectionUtils.invokeGetter(lastBean, propertyItem);
            lastBean = lastValue;
            if (lastValue == null) break;
        }
        return lastValue;
    }

    public static <T> void invokeSetter(Object bean, String attribute, Object value, boolean fail) {
        block2: {
            try {
                new Mirror().on(bean).set().field(attribute).withValue(value);
            }
            catch (Exception ex) {
                if (!fail) break block2;
                throw new IllegalArgumentException(String.format(NO_SUCH_ATTRIBUTE_MESSAGE, bean.getClass().getName(), attribute, value.getClass().getName()));
            }
        }
    }

    public static <T> void invokeSetter(Object bean, String attribute, Object value) {
        ReflectionUtils.invokeSetter(bean, attribute, value, true);
    }

    public static void invokeRecursiveSetter(Object bean, String attribute, Object value) {
        ReflectionUtils.invokeSetter(ReflectionUtils.prepareInvokeRecursiveSetter(bean, attribute, value), attribute.substring(attribute.lastIndexOf(".") + 1), value, true);
    }

    public static Class<?> invokeRecursiveType(Class<?> clazz, String attribute) {
        return ReflectionUtils.invokeRecursiveField(clazz, attribute).getType();
    }

    public static Field invokeRecursiveField(Class<?> clazz, String attribute) {
        Field field = null;
        Class<?> targetBeanClass = ReflectionUtils.getTargetClass(clazz);
        for (String propertyItem : attribute.split("\\.")) {
            field = new Mirror().on(targetBeanClass).reflect().field(propertyItem);
            if (field == null) {
                throw new IllegalArgumentException(String.format("%s-> Field %s doesn't exists", clazz.getName(), attribute));
            }
            targetBeanClass = field.getType();
        }
        return field;
    }

    public static <T> T newInstance(Class<?> clazz) {
        return (T)ReflectionUtils.newInstance(clazz, Collections.emptyList());
    }

    public static <T> T newInstance(Class<T> target, List<? extends Object> parameters) {
        if (parameters.size() > 0) {
            return (T)new Mirror().on(target).invoke().constructor().withArgs(parameters.toArray());
        }
        return (T)new Mirror().on(target).invoke().constructor().withoutArgs();
    }

    public static <T> List<String> filterConstructorParameters(Class<T> target, Collection<String> names) {
        List<String> result = Collections.emptyList();
        AdaptiveParanamer paranamer = new AdaptiveParanamer();
        for (Constructor constructor : new Mirror().on(target).reflectAll().constructors()) {
            List<String> constructorParameterNames = ReflectionUtils.lookupParameterNames((Paranamer)paranamer, constructor);
            if (result.size() >= constructorParameterNames.size() || !names.containsAll(constructorParameterNames) || !ReflectionUtils.constructorParameterTypesMatch(target, constructorParameterNames, Arrays.asList(constructor.getParameterTypes()))) continue;
            result = constructorParameterNames;
        }
        return result;
    }

    private static <T> List<String> lookupParameterNames(Paranamer paranamer, Constructor<T> ctor) {
        String[] paramNames = paranamer.lookupParameterNames(ctor, false);
        if (ReflectionUtils.isInnerClass(ctor.getDeclaringClass()) && paramNames[0].startsWith("this$")) {
            paramNames = Arrays.copyOfRange(paramNames, 1, paramNames.length);
        }
        return Arrays.asList(paramNames);
    }

    private static boolean constructorParameterTypesMatch(Class<?> target, List<String> parameterNames, List<Class<?>> parameterTypes) {
        for (int idx = 0; idx < parameterNames.size(); ++idx) {
            String parameterName = parameterNames.get(idx);
            Class<?> parameterType = parameterTypes.get(idx);
            if (ReflectionUtils.isInnerClass(target) && parameterType.equals(target.getEnclosingClass()) || parameterType.equals(ReflectionUtils.invokeRecursiveType(target, parameterName))) continue;
            return false;
        }
        return true;
    }

    public static Class<?> getTargetClass(Class<?> clazz) {
        if (ReflectionUtils.isCglibProxy(clazz) || Proxy.isProxyClass(clazz)) {
            clazz = clazz.getSuperclass();
        }
        return clazz;
    }

    public static boolean isCglibProxy(Class<?> clazz) {
        return clazz != null && clazz.getName().indexOf(CGLIB_CLASS_SEPARATOR) != -1;
    }

    public static PropertyUtilsBean getPropertyUtilsBean() {
        return BeanUtilsBean.getInstance().getPropertyUtils();
    }

    private static Object prepareInvokeRecursiveSetter(Object bean, String attribute, Object value) {
        Object targetBean = bean;
        Object lastBean = null;
        int lastAttributeIdx = attribute.lastIndexOf(".");
        String path = null;
        if (lastAttributeIdx > 0) {
            path = StringUtils.defaultIfEmpty((String)attribute.substring(0, lastAttributeIdx), null);
        }
        if (path != null) {
            for (String propertyItem : path.split("\\.")) {
                lastBean = targetBean;
                if ((targetBean = ReflectionUtils.invokeGetter(targetBean, propertyItem)) != null) continue;
                Class<?> type = ReflectionUtils.invokeRecursiveType(lastBean.getClass(), propertyItem);
                try {
                    ArrayList<Object> args = new ArrayList<Object>();
                    if (ReflectionUtils.isInnerClass(type)) {
                        args.add(lastBean);
                    }
                    targetBean = ReflectionUtils.newInstance(type, args);
                    ReflectionUtils.invokeSetter(lastBean, propertyItem, targetBean, true);
                }
                catch (Exception e) {
                    throw new IllegalArgumentException(String.format(NO_SUCH_ATTRIBUTE_MESSAGE, lastBean.getClass().getName(), propertyItem, type.getName()));
                }
            }
        }
        return targetBean;
    }

    public static boolean isInnerClass(Class<?> clazz) {
        return clazz.getEnclosingClass() != null && !Modifier.isStatic(clazz.getModifiers());
    }

    public static <T, U> Collection<U> map(Collection<T> collection, String propertyName) {
        ArrayList<T> map = null;
        try {
            map = (ArrayList<T>)collection.getClass().newInstance();
        }
        catch (Exception e) {
            map = new ArrayList<T>();
        }
        for (T item : collection) {
            map.add(ReflectionUtils.invokeGetter(item, propertyName, true));
        }
        return map;
    }

    public static <T> boolean hasDefaultConstructor(final Class<T> clazz) {
        return !new Mirror().on(clazz).reflectAll().constructors().matching(new Matcher<Constructor<T>>(){

            public boolean accepts(Constructor<T> constructor) {
                if (ReflectionUtils.isInnerClass(clazz)) {
                    return constructor.getParameterTypes().length == 1 && constructor.getParameterTypes()[0].equals(clazz.getEnclosingClass());
                }
                return Arrays.asList(constructor.getParameterTypes()).isEmpty();
            }
        }).isEmpty();
    }
}

