/*
 * Decompiled with CFR 0.152.
 */
package br.com.six2six.fixturefactory.util;

import br.com.six2six.fixturefactory.Property;
import br.com.six2six.fixturefactory.function.impl.IdentityFunction;
import br.com.six2six.fixturefactory.transformer.PlaceholderTransformer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;

public class PropertySorter {
    private static final String CYCLIC_MESSAGE_ERROR = "Fixture Factory failed to calculate ${} field references. Either a cyclic dependency exists or one of the fields references a non-existent field.";
    private final Map<String, Property> mappedProperties;
    private List<Property> independents;
    private final Map<Property, Set<Property>> incoming;
    private final Map<Property, Set<Property>> outcoming;
    private Set<Property> sortedProperties;

    public PropertySorter(Set<Property> properties) {
        this.mappedProperties = this.mapProperties(properties);
        this.incoming = new LinkedHashMap<Property, Set<Property>>();
        this.outcoming = new LinkedHashMap<Property, Set<Property>>();
    }

    public Set<Property> sort() {
        this.extractDependencies();
        this.sortDependencies();
        if (this.allDependenciesSorted()) {
            return this.sortedProperties;
        }
        throw new IllegalArgumentException(CYCLIC_MESSAGE_ERROR);
    }

    private boolean allDependenciesSorted() {
        return this.incoming.isEmpty() && this.outcoming.isEmpty();
    }

    private void sortDependencies() {
        this.sortedProperties = new LinkedHashSet<Property>();
        while (!this.independents.isEmpty()) {
            Property independentProperty = this.independents.remove(0);
            this.sortedProperties.add(independentProperty);
            Set<Property> dependents = this.outcoming.get(independentProperty);
            if (dependents == null) continue;
            for (Property dependentProperty : dependents) {
                Set<Property> incomingProperty = this.incoming.get(dependentProperty);
                incomingProperty.remove(independentProperty);
                if (!incomingProperty.isEmpty()) continue;
                this.independents.add(dependentProperty);
                this.incoming.remove(dependentProperty);
            }
            this.outcoming.remove(independentProperty);
        }
    }

    private void extractDependencies() {
        this.independents = new ArrayList<Property>();
        for (Property property : this.mappedProperties.values()) {
            Object value;
            if (property.getFunction() instanceof IdentityFunction && (value = property.getValue()) != null) {
                Matcher matcher = PlaceholderTransformer.PLACEHOLDER.matcher(value.toString());
                while (matcher.find()) {
                    Property referencedProperty = this.mappedProperties.get(matcher.group(2));
                    this.getOrInitialize(this.outcoming, referencedProperty).add(property);
                    this.getOrInitialize(this.incoming, property).add(referencedProperty);
                }
                if (this.incoming.containsKey(property)) continue;
            }
            this.independents.add(property);
        }
    }

    private Set<Property> getOrInitialize(Map<Property, Set<Property>> map, Property property) {
        if (!map.containsKey(property)) {
            map.put(property, new HashSet());
        }
        return map.get(property);
    }

    private Map<String, Property> mapProperties(Set<Property> properties) {
        LinkedHashMap<String, Property> propertiesMapped = new LinkedHashMap<String, Property>();
        for (Property property : properties) {
            propertiesMapped.put(property.getName(), property);
        }
        return propertiesMapped;
    }
}

