/*
 * Decompiled with CFR 0.152.
 */
package br.com.six2six.fixturefactory.function.impl;

import br.com.six2six.fixturefactory.function.AtomicFunction;
import java.util.Random;

public class UniqueRandomFunction
implements AtomicFunction {
    private Object[] dataset;
    private int nextValueIndex = 0;

    public UniqueRandomFunction(int minValue, int maxValue) {
        if (minValue >= maxValue) {
            throw new IllegalArgumentException("maxValue cannot be greater than minValue.");
        }
        this.dataset = this.initIntegerDataset(minValue, maxValue);
        this.shuffleDataset();
    }

    public UniqueRandomFunction(Object[] dataset) {
        if (dataset.length == 0) {
            throw new IllegalArgumentException("provided dataset has no elements.");
        }
        this.dataset = dataset;
        this.shuffleDataset();
    }

    public UniqueRandomFunction(Class<? extends Enum<?>> clazz) {
        if (clazz.getEnumConstants().length == 0) {
            throw new IllegalArgumentException("Enum has no values.");
        }
        this.dataset = clazz.getEnumConstants();
        this.shuffleDataset();
    }

    private Object[] initIntegerDataset(int minValue, int maxValue) {
        Object[] dataset = new Integer[maxValue - minValue + 1];
        int currValue = minValue;
        for (int i = 0; i < dataset.length; ++i) {
            dataset[i] = currValue;
            ++currValue;
        }
        return dataset;
    }

    private void shuffleDataset() {
        Random random = new Random();
        int shufflePosition = 0;
        for (int iterator = this.dataset.length - 1; iterator > 0; --iterator) {
            shufflePosition = random.nextInt(iterator);
            Object temp = this.dataset[iterator];
            this.dataset[iterator] = this.dataset[shufflePosition];
            this.dataset[shufflePosition] = temp;
        }
    }

    @Override
    public <T> T generateValue() {
        if (this.nextValueIndex >= this.dataset.length) {
            this.nextValueIndex = 0;
        }
        Object nextValue = this.dataset[this.nextValueIndex];
        ++this.nextValueIndex;
        return (T)nextValue;
    }
}

