/*
 * Decompiled with CFR 0.152.
 */
package br.com.six2six.fixturefactory.function.impl;

import br.com.six2six.fixturefactory.base.Sequence;

public class NumberSequence
implements Sequence<Number> {
    private Number base;
    private int amount;
    private int multiplier;

    public NumberSequence(Number base, int amount) {
        this.base = base;
        this.amount = amount;
    }

    @Override
    public Number nextValue() {
        Number result = null;
        if (this.base instanceof Integer) {
            result = this.base.intValue() + this.amount * this.multiplier;
        } else if (this.base instanceof Long) {
            result = this.base.longValue() + (long)(this.amount * this.multiplier);
        } else if (this.base instanceof Float) {
            result = Float.valueOf(this.base.floatValue() + (float)(this.amount * this.multiplier));
        } else if (this.base instanceof Double) {
            result = this.base.doubleValue() + (double)(this.amount * this.multiplier);
        }
        ++this.multiplier;
        return result;
    }
}

