/*
 * Decompiled with CFR 0.152.
 */
package br.com.six2six.fixturefactory.function.impl;

import br.com.six2six.fixturefactory.base.Range;
import br.com.six2six.fixturefactory.function.AtomicFunction;
import br.com.six2six.fixturefactory.function.impl.RandomFunction;
import java.util.Calendar;

public class DateTimeFunction
implements AtomicFunction {
    private RandomFunction random;

    public DateTimeFunction(Calendar referenceDate, DateType type) {
        long start;
        long end;
        if (type == DateType.BEFORE) {
            end = referenceDate.getTimeInMillis();
            Calendar startDate = (Calendar)referenceDate.clone();
            startDate.add(1, -28);
            start = startDate.getTimeInMillis();
        } else {
            start = referenceDate.getTimeInMillis();
            Calendar endDate = (Calendar)referenceDate.clone();
            endDate.add(1, 28);
            end = endDate.getTimeInMillis();
        }
        this.random = new RandomFunction(Long.class, new Range(start, end));
    }

    public DateTimeFunction(Calendar startDate, Calendar endDate) {
        this.random = new RandomFunction(Long.class, new Range(startDate.getTimeInMillis(), endDate.getTimeInMillis()));
    }

    @Override
    public <T> T generateValue() {
        Calendar result = Calendar.getInstance();
        result.setTimeInMillis((Long)this.random.generateValue());
        return (T)result;
    }

    public static enum DateType {
        BEFORE,
        AFTER;

    }
}

