/*
 * Decompiled with CFR 0.152.
 */
package br.com.six2six.fixturefactory.function;

import br.com.six2six.fixturefactory.Fixture;
import br.com.six2six.fixturefactory.ObjectFactory;
import br.com.six2six.fixturefactory.function.AtomicFunction;
import br.com.six2six.fixturefactory.function.RelationFunction;
import br.com.six2six.fixturefactory.processor.Processor;
import java.util.Arrays;
import java.util.List;

public class FixtureFunction
implements AtomicFunction,
RelationFunction {
    private Class<?> clazz;
    private List<String> labels;
    private Integer quantity;

    public FixtureFunction(Class<?> clazz, String label) {
        this.clazz = clazz;
        this.labels = Arrays.asList(label);
    }

    public FixtureFunction(Class<?> clazz, String label, Integer quantity) {
        this(clazz, Arrays.asList(label), quantity);
    }

    public FixtureFunction(Class<?> clazz, List<String> labels, Integer quantity) {
        this.clazz = clazz;
        this.labels = labels;
        this.quantity = quantity;
    }

    @Override
    public <T> T generateValue() {
        return this.generate(Fixture.from(this.clazz));
    }

    @Override
    public <T> T generateValue(Processor processor) {
        return this.generate(Fixture.from(this.clazz).uses(processor));
    }

    @Override
    public <T> T generateValue(Object owner) {
        return this.generate(new ObjectFactory(Fixture.of(this.clazz), owner));
    }

    @Override
    public <T> T generateValue(Object owner, Processor processor) {
        return this.generate(Fixture.from(this.clazz).uses(processor));
    }

    private <T> T generate(ObjectFactory objectFactory) {
        if (this.quantity != null) {
            return this.gimmeWithQuantity(objectFactory);
        }
        return objectFactory.gimme(this.getLabel());
    }

    private <T> T gimmeWithQuantity(ObjectFactory objectFactory) {
        if (this.labels.size() == 1) {
            return (T)objectFactory.gimme(this.quantity, this.getLabel());
        }
        return (T)objectFactory.gimme(this.quantity, this.labels);
    }

    private String getLabel() {
        return this.labels.get(0);
    }
}

