/*
 * Decompiled with CFR 0.152.
 */
package br.com.six2six.fixturefactory;

import br.com.six2six.fixturefactory.Property;
import br.com.six2six.fixturefactory.Rule;
import br.com.six2six.fixturefactory.TemplateHolder;
import br.com.six2six.fixturefactory.processor.Processor;
import br.com.six2six.fixturefactory.transformer.CalendarTransformer;
import br.com.six2six.fixturefactory.transformer.ParameterPlaceholderTransformer;
import br.com.six2six.fixturefactory.transformer.PrimitiveTransformer;
import br.com.six2six.fixturefactory.transformer.PropertyPlaceholderTransformer;
import br.com.six2six.fixturefactory.transformer.SetTransformer;
import br.com.six2six.fixturefactory.transformer.Transformer;
import br.com.six2six.fixturefactory.transformer.TransformerChain;
import br.com.six2six.fixturefactory.transformer.WrapperTransformer;
import br.com.six2six.fixturefactory.util.PropertySorter;
import br.com.six2six.fixturefactory.util.ReflectionUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

public class ObjectFactory {
    private static final String NO_SUCH_LABEL_MESSAGE = "%s-> No such label: %s";
    private static final String LABELS_AMOUNT_DOES_NOT_MATCH = "%s-> labels amount does not match asked quantity (%s)";
    private TemplateHolder templateHolder;
    private Object owner;
    private Processor processor;

    public ObjectFactory(TemplateHolder templateHolder) {
        this.templateHolder = templateHolder;
    }

    public ObjectFactory(TemplateHolder templateHolder, Object owner) {
        this(templateHolder);
        this.owner = owner;
    }

    public ObjectFactory(TemplateHolder templateHolder, Processor processor) {
        this(templateHolder);
        this.processor = processor;
    }

    public ObjectFactory uses(Processor processor) {
        this.processor = processor;
        return this;
    }

    public <T> T gimme(String label) {
        Rule rule = this.findRule(label);
        return (T)this.createObject(rule);
    }

    public <T> T gimme(String label, Rule propertiesToOverride) {
        Rule rule = this.findRule(label);
        return (T)this.createObject(new Rule(rule, propertiesToOverride));
    }

    public <T> List<T> gimme(Integer quantity, String label) {
        Rule rule = this.findRule(label);
        return this.createObjects((int)quantity, rule);
    }

    public <T> List<T> gimme(Integer quantity, String ... labels) {
        return this.gimme(quantity, Arrays.asList(labels));
    }

    public <T> List<T> gimme(Integer quantity, List<String> labels) {
        if (labels.size() != quantity.intValue()) {
            throw new IllegalArgumentException(String.format(LABELS_AMOUNT_DOES_NOT_MATCH, this.templateHolder.getClazz().getName(), StringUtils.join(labels, (String)",")));
        }
        List<Rule> rules = this.findRules(labels);
        return this.createObjects((int)quantity, rules);
    }

    public <T> List<T> gimme(int quantity, String label, Rule propertiesToOverride) {
        Rule rule = this.findRule(label);
        return this.createObjects(quantity, new Rule(rule, propertiesToOverride));
    }

    protected Object createObject(Rule rule) {
        HashMap<String, Property> constructorArguments = new HashMap<String, Property>();
        ArrayList<Property> deferredProperties = new ArrayList<Property>();
        Class<?> clazz = this.templateHolder.getClazz();
        Set<Property> properties = new PropertySorter(rule.getProperties()).sort();
        ArrayList<String> parameterNames = !ReflectionUtils.hasDefaultConstructor(clazz) ? this.lookupConstructorParameterNames(clazz, properties) : new ArrayList();
        for (Property property : properties) {
            if (parameterNames.contains(property.getRootAttribute())) {
                constructorArguments.put(property.getName(), property);
                continue;
            }
            deferredProperties.add(property);
        }
        Object result = ReflectionUtils.newInstance(clazz, this.processConstructorArguments(parameterNames, constructorArguments));
        Set<Property> propertiesNotUsedInConstructor = this.getPropertiesNotUsedInConstructor(constructorArguments, parameterNames);
        if (propertiesNotUsedInConstructor.size() > 0) {
            deferredProperties.addAll(propertiesNotUsedInConstructor);
        }
        for (Property property : deferredProperties) {
            ReflectionUtils.invokeRecursiveSetter(result, property.getName(), this.processPropertyValue(result, property));
        }
        if (this.processor != null) {
            this.processor.execute(result);
        }
        return result;
    }

    private Set<Property> getPropertiesNotUsedInConstructor(Map<String, Property> constructorArguments, List<String> parameterNames) {
        HashMap<String, Property> propertiesNotUsedInConstructor = new HashMap<String, Property>(constructorArguments);
        for (String parameterName : parameterNames) {
            propertiesNotUsedInConstructor.remove(parameterName);
        }
        return new HashSet<Property>(propertiesNotUsedInConstructor.values());
    }

    protected <T> List<T> createObjects(int quantity, Rule rule) {
        ArrayList<Object> results = new ArrayList<Object>(quantity);
        for (int i = 0; i < quantity; ++i) {
            results.add(this.createObject(rule));
        }
        return results;
    }

    protected <T> List<T> createObjects(int quantity, List<Rule> rules) {
        ArrayList<Object> results = new ArrayList<Object>(quantity);
        for (int i = 0; i < quantity; ++i) {
            results.add(this.createObject(rules.get(i)));
        }
        return results;
    }

    private Rule findRule(String label) {
        Rule rule = this.templateHolder.getRules().get(label);
        if (rule == null) {
            throw new IllegalArgumentException(String.format(NO_SUCH_LABEL_MESSAGE, this.templateHolder.getClazz().getName(), label));
        }
        return rule;
    }

    private List<Rule> findRules(List<String> labels) {
        ArrayList<Rule> rules = new ArrayList<Rule>();
        for (String label : labels) {
            Rule rule = this.templateHolder.getRules().get(label);
            if (rule == null) {
                throw new IllegalArgumentException(String.format(NO_SUCH_LABEL_MESSAGE, this.templateHolder.getClazz().getName(), label));
            }
            rules.add(rule);
        }
        return rules;
    }

    private Object generateConstructorParamValue(Property property) {
        if (property.hasRelationFunction() && this.processor != null) {
            return property.getValue(this.processor);
        }
        return property.getValue();
    }

    protected List<Object> processConstructorArguments(List<String> parameterNames, Map<String, Property> arguments) {
        ArrayList<Object> values = new ArrayList<Object>();
        Map<String, Object> processedArguments = this.processArguments(arguments);
        if (this.owner != null && ReflectionUtils.isInnerClass(this.templateHolder.getClazz())) {
            values.add(this.owner);
        }
        TransformerChain transformerChain = this.buildTransformerChain(new ParameterPlaceholderTransformer(processedArguments));
        for (String parameterName : parameterNames) {
            Class<?> fieldType = ReflectionUtils.invokeRecursiveType(this.templateHolder.getClazz(), parameterName);
            Object result = processedArguments.get(parameterName);
            if (result == null) {
                result = this.processChainedProperty(parameterName, fieldType, processedArguments);
            }
            values.add(transformerChain.transform(result, fieldType));
        }
        return values;
    }

    private Map<String, Object> processArguments(Map<String, Property> arguments) {
        HashMap<String, Object> processedArguments = new HashMap<String, Object>();
        for (Map.Entry<String, Property> entry : arguments.entrySet()) {
            processedArguments.put(entry.getKey(), this.generateConstructorParamValue(entry.getValue()));
        }
        return processedArguments;
    }

    protected Object processChainedProperty(String parameterName, Class<?> fieldType, Map<String, Object> arguments) {
        Rule rule = new Rule();
        for (String argument : arguments.keySet()) {
            int index = argument.indexOf(".");
            if (index <= 0 || !argument.substring(0, index).equals(parameterName)) continue;
            rule.add(argument.substring(index + 1), arguments.get(argument));
        }
        return new ObjectFactory(new TemplateHolder(fieldType), this.processor).createObject(rule);
    }

    protected Object processPropertyValue(Object object, Property property) {
        Class<?> fieldType = ReflectionUtils.invokeRecursiveType(object.getClass(), property.getName());
        Object value = null;
        value = property.hasRelationFunction() || ReflectionUtils.isInnerClass(fieldType) ? (this.processor != null ? property.getValue(object, this.processor) : property.getValue(object)) : property.getValue();
        TransformerChain transformerChain = this.buildTransformerChain(new PropertyPlaceholderTransformer(object));
        return transformerChain.transform(value, fieldType);
    }

    protected <T> List<String> lookupConstructorParameterNames(Class<T> target, Set<Property> properties) {
        Collection<String> propertyNames = ReflectionUtils.map(properties, "rootAttribute");
        return ReflectionUtils.filterConstructorParameters(target, propertyNames);
    }

    protected TransformerChain buildTransformerChain(Transformer transformer) {
        TransformerChain transformerChain = new TransformerChain(transformer);
        transformerChain.add(new CalendarTransformer());
        transformerChain.add(new SetTransformer());
        transformerChain.add(new PrimitiveTransformer());
        transformerChain.add(new WrapperTransformer());
        return transformerChain;
    }
}

